/*
 * Decompiled with CFR 0.152.
 */
package dispatching.util;

import activity.Activity;
import activity.ActivitySet;
import activity.HasResourceAndItem;
import activity.ResourceAction;
import activity.util.ActivityParametersUtil;
import common.Parameter;
import common.ParameterReference;
import common.TypeDefinition;
import dispatching.ActivityDispatching;
import dispatching.Attribute;
import dispatching.Constraint;
import dispatching.Dispatch;
import dispatching.DispatchGroup;
import dispatching.DispatchingFactory;
import dispatching.DispatchingPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import machine.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DispatchingUtil {
    private DispatchingUtil() {
    }

    public static void expand(ActivityDispatching dispatching) {
        DispatchingUtil.unfold(dispatching);
        DispatchingUtil.expandActivities(dispatching);
    }

    public static void expandActivities(ActivityDispatching dispatching) {
        LinkedHashSet remove = new LinkedHashSet();
        dispatching.getDispatchGroups().stream().flatMap(dg -> dg.getDispatches().stream()).filter(d -> !d.getParameters().isEmpty()).forEach(d -> {
            remove.add(d.getActivity());
            List<Parameter> dParameters = DispatchingUtil.getParameters(d);
            d.setActivity(ActivityParametersUtil.queryCreateExpandedActivity((Activity)d.getActivity(), dParameters.stream().map(p -> p.getReferences().stream().map(ParameterReference::getReference).toList()).toList()));
            d.getParameters().clear();
        });
    }

    private static List<Parameter> getParameters(Dispatch dispatch) {
        Activity activity = dispatch.getActivity();
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        List declatarions = ActivityParametersUtil.getDeclarations((Activity)activity);
        int index = 0;
        for (TypeDefinition decl : declatarions) {
            EList parameters = dispatch.getParameters();
            Parameter parameter = parameters.stream().filter(p -> p.getDeclaration() == decl).findFirst().orElse((Parameter)parameters.get(index));
            result.add(parameter);
            ++index;
        }
        return result;
    }

    public static void unfold(ActivityDispatching dispatching) {
        DispatchingUtil.convertYield(dispatching);
        for (DispatchGroup dg : new ArrayList<DispatchGroup>((Collection<DispatchGroup>)dispatching.getDispatchGroups())) {
            DispatchGroup newGroup = (DispatchGroup)EcoreUtil.copy((EObject)dg);
            newGroup.getConstraints().clear();
            dispatching.getDispatchGroups().add(dispatching.getDispatchGroups().indexOf((Object)dg), (Object)newGroup);
            int numberRepeats = DispatchingUtil.getNumberRepeats(dg);
            newGroup.setYield(DispatchingUtil.getYield(dg) * numberRepeats);
            newGroup.getResourceYield().forEach(d -> d.setValue(numberRepeats * DispatchingUtil.getYield(newGroup, (IResource)d.getKey())));
            newGroup.getRepeats().clear();
            newGroup.eUnset((EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__ITERATOR_NAME);
            newGroup.getDispatches().clear();
            HashMap<Dispatch, List> dispatchMapping = new HashMap<Dispatch, List>();
            Integer[] integerArray = DispatchingUtil.getRepeatSeries(dg);
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer iteration = integerArray[n2];
                for (Dispatch d2 : dg.getDispatches()) {
                    Dispatch newDispatch = (Dispatch)EcoreUtil.copy((EObject)d2);
                    if (d2.getName() != null) {
                        newDispatch.setName(d2.getName() + "_" + String.valueOf(iteration));
                    }
                    if (newDispatch.getDescription() != null) {
                        DispatchingUtil.userAttr(newDispatch, "description", d2.getDescription());
                        newDispatch.setDescription(null);
                    }
                    DispatchingUtil.userAttr(newDispatch, "phase", dg.getName());
                    DispatchingUtil.userAttr(newDispatch, dg.getIteratorName(), Integer.toString(iteration));
                    newGroup.getDispatches().add((Object)newDispatch);
                    dispatchMapping.computeIfAbsent(d2, k -> new ArrayList()).add(newDispatch);
                }
                for (Constraint c : dg.getConstraints()) {
                    Constraint newConstraint = (Constraint)EcoreUtil.copy((EObject)c);
                    newConstraint.setSourceDispatch((Dispatch)((List)dispatchMapping.get(c.getSourceDispatch())).getLast());
                    newConstraint.setTargetDispatch((Dispatch)((List)dispatchMapping.get(c.getTargetDispatch())).getLast());
                    newGroup.getConstraints().add((Object)newConstraint);
                }
                ++n2;
            }
            dispatching.getDispatchGroups().remove((Object)dg);
            for (Constraint c : dispatching.getConstraints()) {
                if (c.getSourceDispatchGroup() == dg) {
                    c.setSourceDispatchGroup(newGroup);
                    c.setSourceDispatch((Dispatch)((List)dispatchMapping.get(c.getSourceDispatch())).getLast());
                }
                if (c.getTargetDispatchGroup() != dg) continue;
                c.setTargetDispatchGroup(newGroup);
                c.setTargetDispatch((Dispatch)((List)dispatchMapping.get(c.getTargetDispatch())).getFirst());
            }
        }
    }

    public static ActivityDispatching convertYield(ActivityDispatching dispatching) {
        if (dispatching.eIsSet((EStructuralFeature)DispatchingPackage.Literals.ACTIVITY_DISPATCHING__NUMBER_OF_ITERATIONS) || dispatching.getResourceIterations().size() > 0) {
            for (DispatchGroup dg : new ArrayList<DispatchGroup>((Collection<DispatchGroup>)dispatching.getDispatchGroups())) {
                dg.setYield(DispatchingUtil.getYield(dg));
                Collection<IResource> resources = DispatchingUtil.getResources(dg);
                dg.getResourceYield().forEach(d -> resources.remove(d.getKey()));
                dispatching.getResourceIterations().stream().filter(r -> resources.contains(r.getKey())).forEach(r -> {
                    Object object = dg.getResourceYield().put((Object)((IResource)r.getKey()), (Object)((Integer)r.getValue()));
                });
            }
            dispatching.eUnset((EStructuralFeature)DispatchingPackage.Literals.ACTIVITY_DISPATCHING__NUMBER_OF_ITERATIONS);
            dispatching.getResourceIterations().clear();
        }
        return dispatching;
    }

    public static void removeUnusedActivities(ActivityDispatching dispatching) {
        Collection used = dispatching.getDispatchGroups().stream().flatMap(dg -> dg.getDispatches().stream()).map(d -> d.getActivity()).collect(Collectors.toCollection(LinkedHashSet::new));
        Collection activitySets = used.stream().map(EObject::eContainer).filter(ActivitySet.class::isInstance).map(ActivitySet.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
        Collection remove = activitySets.stream().flatMap(as -> as.getActivities().stream()).filter(a -> !used.contains(a)).collect(Collectors.toCollection(LinkedHashSet::new));
        remove.forEach(a -> {
            boolean bl = ((ActivitySet)a.eContainer()).getActivities().remove(a);
        });
    }

    public static Collection<IResource> getResources(DispatchGroup group) {
        return group.getDispatches().stream().map(Dispatch::getActivity).flatMap(a -> a.getNodes().stream()).filter(ResourceAction.class::isInstance).map(ResourceAction.class::cast).map(HasResourceAndItem::getResource).distinct().collect(Collectors.toSet());
    }

    public static int getNumberRepeats(DispatchGroup group) {
        return DispatchingUtil.getRepeatSeries(group).length;
    }

    public static int getYield(DispatchGroup dg, IResource resource) {
        Integer result = (Integer)dg.getResourceYield().get((Object)resource);
        return result != null ? result : (dg.eIsSet((EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__YIELD) ? dg.getYield() : DispatchingUtil.getYield((ActivityDispatching)dg.eContainer(), resource));
    }

    private static Integer[] getRepeatSeries(DispatchGroup group) {
        if (group.getRepeats().size() == 0) {
            return new Integer[]{1};
        }
        return (Integer[])group.getRepeats().stream().flatMap(r -> IntStream.range(r.getStart(), r.getStart() + r.getCount()).boxed()).toArray(Integer[]::new);
    }

    private static int getYield(DispatchGroup dg) {
        return dg.eIsSet((EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__YIELD) ? dg.getYield() : ((ActivityDispatching)dg.eContainer()).getNumberOfIterations();
    }

    private static int getYield(ActivityDispatching ad, IResource resource) {
        if (ad != null) {
            Integer result = (Integer)ad.getResourceIterations().get((Object)resource);
            return result != null ? result.intValue() : ad.getNumberOfIterations();
        }
        return 1;
    }

    private static void userAttr(Dispatch group, String name, String value) {
        Attribute attribute = DispatchingFactory.eINSTANCE.createAttribute();
        attribute.setName(name);
        group.getUserAttributes().put((Object)attribute, (Object)value);
    }
}

