/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.benchmarking;

import java.io.PrintWriter;
import org.eclipse.lsat.common.ludus.backend.games.benchmarking.Benchmark;
import org.eclipse.lsat.common.ludus.backend.games.benchmarking.generator.Sprand;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGIntImplJGraphT;

public class SprandIntBenchmark
extends Benchmark {
    private final String name;
    private final Integer numberOfVerticesMin;
    private final Integer numberOfVerticesMax;
    private final Integer stepSize;
    private final Integer edgeRatio;
    private final Integer maxWeight1;
    private final Integer maxWeight2;
    private PrintWriter file;

    public SprandIntBenchmark(String name, Integer numberOfVerticesMin, Integer numberOfVerticesMax, Integer stepSize, Integer edgeRatio, Integer maxWeight1, Integer maxWeight2) {
        this.name = name;
        this.numberOfVerticesMin = numberOfVerticesMin;
        this.numberOfVerticesMax = numberOfVerticesMax;
        this.stepSize = stepSize;
        this.edgeRatio = edgeRatio;
        this.maxWeight1 = maxWeight1;
        this.maxWeight2 = maxWeight2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void run(Integer numberOfIterations, boolean runPI, boolean runEG, boolean runZP) {
        this.file = this.getFile(this.name);
        this.file.printf("%s,%s,%s,%s,%s,%s,%s\n", "N", "edgeRatio", "maxWeight1", "maxWeight2", "PolicyIteration", "EnergyGame", "ZwickPaterson");
        System.out.printf("%s,%s,%s,%s,%s,%s,%s\n", "N", "edgeRatio", "maxWeight1", "maxWeight2", "PolicyIteration", "EnergyGame", "ZwickPaterson");
        int runId = 0;
        while (runId < numberOfIterations) {
            int v = this.numberOfVerticesMin;
            while (v <= this.numberOfVerticesMax) {
                this.runAlgorithmsSprand(v, this.edgeRatio, this.maxWeight1, this.maxWeight2, runPI, runEG, runZP);
                v += this.stepSize.intValue();
            }
            ++runId;
        }
        this.file.close();
    }

    private void runAlgorithmsSprand(Integer numberOfVertices, Integer edgeRatio, Integer maxWeight1, Integer maxWeight2, boolean runPI, boolean runEG, boolean runZP) {
        RGIntImplJGraphT sprandGraph = Sprand.generateRatioGame(numberOfVertices, edgeRatio, maxWeight1, maxWeight2);
        float piSec = 0.0f;
        if (runPI) {
            long piResult = this.runPI(sprandGraph);
            piSec = (float)piResult / 1.0E9f;
        }
        float egSec = 0.0f;
        if (runEG) {
            long egResult = this.runEG(sprandGraph);
            egSec = (float)egResult / 1.0E9f;
        }
        float zpSec = 0.0f;
        if (runZP) {
            long zpResult = this.runZP(sprandGraph);
            zpSec = (float)zpResult / 1.0E9f;
        }
        this.file.printf("%d,%d,%d,%d,%f,%f,%f\n", numberOfVertices, edgeRatio, maxWeight1, maxWeight2, Float.valueOf(piSec), Float.valueOf(egSec), Float.valueOf(zpSec));
        System.out.printf("%d,%d,%d,%d,%f,%f,%f\n", numberOfVertices, edgeRatio, maxWeight1, maxWeight2, Float.valueOf(piSec), Float.valueOf(egSec), Float.valueOf(zpSec));
    }
}

