/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.util;

import activity.Move;
import activity.SimpleAction;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import machine.ActionType;
import machine.IResource;
import machine.Peripheral;
import machine.SetPoint;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.util.IterableUtil;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.motioncalculator.MotionSegment;
import org.eclipse.lsat.timing.calculator.MotionCalculatorExtension;
import org.eclipse.lsat.timing.util.ITimingCalculator;
import org.eclipse.lsat.timing.util.MotionCalculatorHelper;
import org.eclipse.lsat.timing.util.SpecificationException;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import setting.PhysicalSettings;
import setting.Settings;
import timing.Array;
import timing.CalculationMode;
import timing.Distribution;
import timing.DistributionsFactory;
import timing.FixedValue;
import timing.Timing;
import timing.distribution.ModeDistribution;

public class TimingCalculator
implements ITimingCalculator {
    private static final MathContext MICRO_SECONDS = new MathContext(6, RoundingMode.HALF_UP);
    private final Map<Array, Integer> _IntermediateProperty_pointer = new WeakHashMap<Array, Integer>();
    private final RandomGenerator distributionRandom = new JDKRandomGenerator(1618033989);
    private final Map<Distribution, ModeDistribution> distributionSession = new IdentityHashMap<Distribution, ModeDistribution>();
    private final MotionCalculatorHelper motionCalculatorHelper;
    private final CalculationMode mode;
    private final boolean synchronizeAxes;
    private final Map<Node, BigDecimal> nodeTimes;
    private final Map<Move, Map<SetPoint, BigDecimal>> motionTimes;
    private static final Integer _DEFAULT_ARRAY_POINTER = -1;

    public TimingCalculator(Settings settings, MotionCalculatorExtension motionCalculator) {
        this(settings, motionCalculator, CalculationMode.MEAN, true, true);
    }

    public TimingCalculator(Settings settings, MotionCalculatorExtension motionCalculator, CalculationMode mode) {
        this(settings, motionCalculator, mode, true, true);
    }

    public TimingCalculator(Settings settings, MotionCalculatorExtension motionCalculator, CalculationMode mode, boolean synchronizeAxes, boolean useCache) {
        MotionCalculatorHelper _motionCalculatorHelper;
        this.motionCalculatorHelper = _motionCalculatorHelper = new MotionCalculatorHelper(settings, motionCalculator);
        this.mode = mode;
        this.synchronizeAxes = synchronizeAxes;
        IdentityHashMap _xifexpression = null;
        if (useCache && Objects.equals(mode, CalculationMode.MEAN)) {
            _xifexpression = new IdentityHashMap();
        }
        this.nodeTimes = _xifexpression;
        IdentityHashMap _xifexpression_1 = null;
        if (useCache) {
            _xifexpression_1 = new IdentityHashMap();
        }
        this.motionTimes = _xifexpression_1;
    }

    public Settings getSettings() {
        return this.motionCalculatorHelper.getSettings();
    }

    public MotionCalculatorExtension getMotionCalculator() {
        return this.motionCalculatorHelper.getMotionCalculator();
    }

    @Override
    public void reset() {
        this.distributionSession.clear();
        this._IntermediateProperty_pointer.clear();
        if (this.nodeTimes != null) {
            this.nodeTimes.clear();
        }
        if (this.motionTimes != null) {
            this.motionTimes.clear();
        }
    }

    @Override
    public BigDecimal calculateDuration(Node node) throws MotionException {
        BigDecimal _xifexpression = null;
        if (this.nodeTimes == null) {
            _xifexpression = this.doCalculateDuration(node);
        } else {
            Function<Node, BigDecimal> _function = it -> this.doCalculateDuration((Node)it);
            _xifexpression = this.nodeTimes.computeIfAbsent(node, _function);
        }
        return _xifexpression;
    }

    protected BigDecimal _doCalculateDuration(Node node) {
        return BigDecimal.ZERO;
    }

    protected BigDecimal _doCalculateDuration(SimpleAction action) {
        return this.doCalculateValue(action.getType(), action.getResource(), action.getPeripheral());
    }

    protected BigDecimal doCalculateValue(ActionType actionType, IResource resource, Peripheral peripheral) {
        try {
            return this.doCalculateValue((Timing)this.getPhysicalSettings(resource, peripheral).getTimingSettings().get((Object)actionType));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected BigDecimal _doCalculateValue(FixedValue fixedValue) {
        return fixedValue.getValue();
    }

    protected BigDecimal _doCalculateValue(Array array) {
        BigDecimal _switchResult = null;
        CalculationMode mode = this.mode;
        if (mode != null) {
            switch (mode) {
                case LINEAIR: {
                    BigDecimal _xblockexpression = null;
                    Integer _pointer = this.getPointer(array);
                    int _plus = _pointer + 1;
                    int _size = array.getValues().size();
                    int _modulo = _plus % _size;
                    this.setPointer(array, _modulo);
                    _switchResult = _xblockexpression = (BigDecimal)array.getValues().get(this.getPointer(array).intValue());
                    break;
                }
                default: {
                    _switchResult = TimingCalculator.getAverage((Collection<BigDecimal>)array.getValues());
                    break;
                }
            }
        } else {
            _switchResult = TimingCalculator.getAverage((Collection<BigDecimal>)array.getValues());
        }
        return _switchResult;
    }

    protected BigDecimal _doCalculateValue(Distribution distribution) {
        BigDecimal _xblockexpression = null;
        Function<Distribution, ModeDistribution> _function = it -> DistributionsFactory.createRealDistribution((Distribution)it, (RandomGenerator)this.distributionRandom);
        ModeDistribution realDistribution = this.distributionSession.computeIfAbsent(distribution, _function);
        BigDecimal _switchResult = null;
        CalculationMode mode = this.mode;
        if (mode != null) {
            switch (mode) {
                case DISTRIBUTED: {
                    _switchResult = TimingCalculator.normalize(realDistribution.sample());
                    break;
                }
                default: {
                    _switchResult = TimingCalculator.normalize(realDistribution.getDefault());
                    break;
                }
            }
        } else {
            _switchResult = TimingCalculator.normalize(realDistribution.getDefault());
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected BigDecimal _doCalculateDuration(Move move) {
        try {
            return (BigDecimal)IterableUtil.max(this.calculateMotionTime(move).values(), (Comparable)BigDecimal.ZERO);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public Map<SetPoint, BigDecimal> calculateMotionTime(Move move) throws MotionException {
        boolean _not;
        if (this.motionTimes == null) {
            return this.doCalculateMotionTimes(move).get(move);
        }
        boolean _containsKey = this.motionTimes.containsKey(move);
        boolean bl = _not = !_containsKey;
        if (_not) {
            this.motionTimes.putAll(this.doCalculateMotionTimes(move));
        }
        return this.motionTimes.get(move);
    }

    protected Map<Move, ? extends Map<SetPoint, BigDecimal>> doCalculateMotionTimes(Move move) {
        try {
            Map _xifexpression = null;
            if (this.synchronizeAxes) {
                EList _axes = move.getPeripheral().getType().getAxes();
                EList _setPoints = move.getPeripheral().getType().getSetPoints();
                Pair _mappedTo = Pair.of((Object)_axes, (Object)_setPoints);
                _xifexpression = CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo});
            } else {
                Functions.Function1 _function = it -> it.getAxes();
                _xifexpression = IterableExtensions.groupBy((Iterable)move.getPeripheral().getType().getSetPoints(), (Functions.Function1)_function);
            }
            Map axesAndSetPoints = _xifexpression;
            List<Move> concatenatedMove = this.motionCalculatorHelper.getConcatenatedMove(move);
            int _size = concatenatedMove.size();
            IdentityHashMap<Move, IdentityHashMap> result = new IdentityHashMap<Move, IdentityHashMap>(_size);
            Set _entrySet = axesAndSetPoints.entrySet();
            for (Map.Entry e : _entrySet) {
                List<MotionSegment> motionSegments = this.motionCalculatorHelper.createMotionSegments(concatenatedMove, (Collection)e.getKey());
                List<Double> motionTimes = this.motionCalculatorHelper.getMotionCalculator().calculateTimes(motionSegments);
                BigDecimal startTime = BigDecimal.ZERO;
                int i = 0;
                while (i < motionTimes.size()) {
                    BigDecimal endTime = TimingCalculator.normalize(motionTimes.get(i));
                    Function<Move, IdentityHashMap> _function_1 = it -> {
                        int _size_1 = move.getPeripheral().getType().getSetPoints().size();
                        return new IdentityHashMap(_size_1);
                    };
                    TimingCalculator.fill(result.computeIfAbsent(concatenatedMove.get(i), _function_1), (Collection)e.getValue(), endTime.subtract(startTime));
                    startTime = endTime;
                    ++i;
                }
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected PhysicalSettings getPhysicalSettings(IResource resource, Peripheral peripheral) throws SpecificationException {
        PhysicalSettings physicalSettings = this.getSettings().getPhysicalSettings(resource, peripheral);
        if (physicalSettings == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Physical settings not specified for peripheral: ");
            String _fqn = peripheral.fqn();
            _builder.append(_fqn);
            Settings _settings = this.getSettings();
            throw new SpecificationException(_builder.toString(), new EObject[]{_settings});
        }
        return physicalSettings;
    }

    public static <K, V> void fill(Map<K, V> map, Collection<? extends K> keys, V value) {
        Consumer<Object> _function = it -> map.put(it, value);
        keys.forEach(_function);
    }

    public static BigDecimal getAverage(Collection<BigDecimal> values) {
        BigDecimal sum = (BigDecimal)IterableExtensions.head(values);
        Iterable _tail = IterableExtensions.tail(values);
        for (BigDecimal value : _tail) {
            BigDecimal _sum = sum;
            sum = _sum.add(value);
        }
        int _size = values.size();
        BigDecimal _bigDecimal = new BigDecimal(_size);
        return sum.divide(_bigDecimal, MICRO_SECONDS);
    }

    public static BigDecimal normalize(Number number) {
        BigDecimal result = BigDecimal.valueOf(number.doubleValue());
        return result.max(BigDecimal.ZERO).round(MICRO_SECONDS);
    }

    @XbaseGenerated
    protected BigDecimal doCalculateDuration(Node move) {
        if (move instanceof Move) {
            return this._doCalculateDuration((Move)move);
        }
        if (move instanceof SimpleAction) {
            return this._doCalculateDuration((SimpleAction)move);
        }
        if (move != null) {
            return this._doCalculateDuration(move);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(move).toString());
    }

    @XbaseGenerated
    protected BigDecimal doCalculateValue(Timing array) {
        if (array instanceof Array) {
            return this._doCalculateValue((Array)array);
        }
        if (array instanceof Distribution) {
            return this._doCalculateValue((Distribution)array);
        }
        if (array instanceof FixedValue) {
            return this._doCalculateValue((FixedValue)array);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(array).toString());
    }

    private Integer getPointer(Array owner) {
        Integer value = this._IntermediateProperty_pointer.get(owner);
        return value == null ? _DEFAULT_ARRAY_POINTER : value;
    }

    private void setPointer(Array owner, Integer value) {
        if (value == _DEFAULT_ARRAY_POINTER) {
            this._IntermediateProperty_pointer.remove(owner);
        } else {
            this._IntermediateProperty_pointer.put(owner, value);
        }
    }

    private void disposePointer() {
        this._IntermediateProperty_pointer.clear();
    }
}

