/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.scheduler;

import activity.PeripheralAction;
import activity.SchedulingType;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import lsat_graph.PeripheralActionTask;
import lsat_graph.ReleaseTask;
import org.eclipse.lsat.common.graph.directed.Node;
import org.eclipse.lsat.common.graph.directed.util.DirectedGraphQueries;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.schedule.Schedule;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;
import org.eclipse.lsat.common.xtend.Queries;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ALAPScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ALAPScheduler.class);

    public static <T extends Task> Schedule<T> applyALAPScheduling(Schedule<T> schedule) {
        LOGGER.debug("Starting transformation");
        Functions.Function1 _function = it -> ALAPScheduler.supportsALAP(it);
        Consumer<ScheduledTask> _function_1 = it -> ALAPScheduler.moveALAP(it);
        IterableExtensions.filter((Iterable)DirectedGraphQueries.reverseTopologicalOrdering((Iterable)DirectedGraphQueries.allSubNodes(schedule)), (Functions.Function1)_function).forEach(_function_1);
        Functions.Function1 _function_2 = it -> ALAPScheduler.supportsASAP(it);
        Consumer<ScheduledTask> _function_3 = it -> ALAPScheduler.moveASAP(it);
        IterableExtensions.filter((Iterable)DirectedGraphQueries.topologicalOrdering((Iterable)DirectedGraphQueries.allSubNodes(schedule)), (Functions.Function1)_function_2).forEach(_function_3);
        LOGGER.debug("Finished transformation");
        return schedule;
    }

    private static <T extends Task> boolean supportsALAP(ScheduledTask<T> scheduledTask) {
        Task _task;
        boolean _switchResult = false;
        Task it = _task = scheduledTask.getTask();
        boolean _matched = false;
        if (it instanceof PeripheralActionTask) {
            _matched = true;
            SchedulingType _schedulingType = ((PeripheralAction)((PeripheralActionTask)it).getAction()).getSchedulingType();
            _switchResult = Objects.equals(_schedulingType, SchedulingType.ALAP);
        }
        if (!_matched && it instanceof ReleaseTask) {
            _matched = true;
            _switchResult = false;
        }
        if (!_matched) {
            _switchResult = true;
        }
        return _switchResult;
    }

    private static <T extends Task> void moveALAP(ScheduledTask<T> scheduledTask) {
        BigDecimal _endTime;
        boolean _greaterThan;
        boolean _isEmpty = scheduledTask.getOutgoingEdges().isEmpty();
        if (_isEmpty) {
            return;
        }
        Functions.Function1 _function = it -> {
            Node _targetNode = it.getTargetNode();
            return (ScheduledTask)_targetNode;
        };
        Functions.Function1 _function_1 = it -> it.getStartTime();
        BigDecimal newEndTime = (BigDecimal)IterableExtensions.min((Iterable)ListExtensions.map((List)ListExtensions.map((List)scheduledTask.getOutgoingEdges(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        boolean bl = _greaterThan = newEndTime.compareTo(_endTime = scheduledTask.getEndTime()) > 0;
        if (_greaterThan) {
            BigDecimal _endTime_1 = scheduledTask.getEndTime();
            BigDecimal timeShift = newEndTime.subtract(_endTime_1);
            BigDecimal _startTime = scheduledTask.getStartTime();
            scheduledTask.setStartTime(_startTime.add(timeShift).stripTrailingZeros());
            BigDecimal _endTime_2 = scheduledTask.getEndTime();
            scheduledTask.setEndTime(_endTime_2.add(timeShift).stripTrailingZeros());
        }
    }

    private static <T extends Task> boolean supportsASAP(ScheduledTask<T> scheduledTask) {
        Task _task;
        boolean _switchResult = false;
        Task it = _task = scheduledTask.getTask();
        boolean _matched = false;
        if (it instanceof PeripheralActionTask) {
            _matched = true;
            SchedulingType _schedulingType = ((PeripheralAction)((PeripheralActionTask)it).getAction()).getSchedulingType();
            _switchResult = Objects.equals(_schedulingType, SchedulingType.ASAP);
        }
        if (!_matched) {
            _switchResult = true;
        }
        return _switchResult;
    }

    private static <T extends Task> void moveASAP(ScheduledTask<T> scheduledTask) {
        BigDecimal _startTime;
        boolean _lessThan;
        Functions.Function1 _function = it -> {
            Node _sourceNode = it.getSourceNode();
            return (ScheduledTask)_sourceNode;
        };
        Functions.Function1 _function_1 = it -> it.getEndTime();
        BigDecimal newStartTime = (BigDecimal)Queries.max((Iterable)ListExtensions.map((List)ListExtensions.map((List)scheduledTask.getIncomingEdges(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Comparable)BigDecimal.ZERO);
        boolean bl = _lessThan = newStartTime.compareTo(_startTime = scheduledTask.getStartTime()) < 0;
        if (_lessThan) {
            BigDecimal _startTime_1 = scheduledTask.getStartTime();
            BigDecimal timeShift = newStartTime.subtract(_startTime_1);
            BigDecimal _startTime_2 = scheduledTask.getStartTime();
            scheduledTask.setStartTime(_startTime_2.add(timeShift).stripTrailingZeros());
            BigDecimal _endTime = scheduledTask.getEndTime();
            scheduledTask.setEndTime(_endTime.add(timeShift).stripTrailingZeros());
        }
    }
}

