/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.motioncalculator;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsat.motioncalculator.TimePosition;

public final class PositionInfo
implements Serializable {
    private static final long serialVersionUID = 6966667096730059599L;
    private String setPointId;
    private List<double[]> timePositions = new ArrayList<double[]>();

    public PositionInfo(String setPointId) {
        this.setPointId = setPointId;
    }

    public String getSetPointId() {
        return this.setPointId;
    }

    public void addTimePosition(double time, double position) {
        this.timePositions.add(new double[]{time, position});
    }

    public Collection<TimePosition> getTimePositions() {
        return Collections.unmodifiableCollection(new AbstractList<TimePosition>(){

            @Override
            public TimePosition get(int index) {
                double[] d = PositionInfo.this.timePositions.get(index);
                return new TimePosition(d[0], d[1]);
            }

            @Override
            public int size() {
                return PositionInfo.this.timePositions.size();
            }
        });
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.setPointId == null ? 0 : this.setPointId.hashCode());
        result = 31 * result + (this.timePositions == null ? 0 : this.timePositions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PositionInfo other = (PositionInfo)obj;
        if (this.setPointId == null ? other.setPointId != null : !this.setPointId.equals(other.setPointId)) {
            return false;
        }
        return !(this.timePositions == null ? other.timePositions != null : !this.timePositions.equals(other.timePositions));
    }

    public String toString() {
        return "PositionInfo [setPointId=" + this.setPointId + ", timePositions=" + String.valueOf(this.timePositions) + "]";
    }
}

