/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.ui.model;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ModelWorkbenchLabelProvider
implements ILabelProvider {
    public static final ModelWorkbenchLabelProvider REFLECTIVE = new ModelWorkbenchLabelProvider(new AdapterFactory[0]);
    private final WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
    private final AdapterFactoryLabelProvider adapterFactoryLabelProvider;

    protected static AdapterFactory createAdapterFactory(AdapterFactory ... adapterFactories) {
        if (adapterFactories.length == 1 && adapterFactories[0] instanceof ComposedAdapterFactory) {
            return adapterFactories[0];
        }
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactory[] adapterFactoryArray = adapterFactories;
        int n = adapterFactories.length;
        int n2 = 0;
        while (n2 < n) {
            AdapterFactory adapterFactory = adapterFactoryArray[n2];
            composedAdapterFactory.addAdapterFactory(adapterFactory);
            ++n2;
        }
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return composedAdapterFactory;
    }

    public ModelWorkbenchLabelProvider(AdapterFactory ... adapterFactories) {
        this.adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(ModelWorkbenchLabelProvider.createAdapterFactory(adapterFactories));
    }

    protected ILabelProvider getLabelProviderFor(Object element) {
        boolean useAdapterFactory = this.adapterFactoryLabelProvider.getAdapterFactory().isFactoryForType(element);
        return useAdapterFactory ? this.adapterFactoryLabelProvider : this.workbenchLabelProvider;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactoryLabelProvider.getAdapterFactory();
    }

    public Image getImage(Object element) {
        return this.getLabelProviderFor(element).getImage(element);
    }

    public String getText(Object element) {
        return this.getLabelProviderFor(element).getText(element);
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.getLabelProviderFor(element).isLabelProperty(element, property);
    }

    public void addListener(ILabelProviderListener listener) {
        this.workbenchLabelProvider.addListener(listener);
        this.adapterFactoryLabelProvider.addListener(listener);
    }

    public void dispose() {
        this.workbenchLabelProvider.dispose();
        this.adapterFactoryLabelProvider.dispose();
    }

    public void removeListener(ILabelProviderListener listener) {
        this.workbenchLabelProvider.removeListener(listener);
        this.adapterFactoryLabelProvider.removeListener(listener);
    }
}

