/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.util;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import machine.Axis;
import machine.Peripheral;
import machine.PeripheralType;
import machine.SymbolicPosition;
import org.eclipse.lsat.common.queries.QueryableIterable;

public final class AxesLocation
extends HashMap<Axis, BigDecimal> {
    private static final long serialVersionUID = 6227801704225324973L;
    private final SymbolicPosition position;

    AxesLocation(SymbolicPosition position) {
        super(AxesLocation.safeGetAxes(position).size());
        this.position = position;
    }

    public SymbolicPosition getPosition() {
        return this.position;
    }

    public PeripheralType getPeripheralType() {
        return this.position.getPeripheral().getType();
    }

    public Set<Axis> getMovingAxes(AxesLocation other) {
        if (!this.keySet().equals(other.keySet())) {
            throw new IllegalArgumentException(String.format("Expected axes to be the same! %s.%s%s != %s.%s%s", this.getPosition().getPeripheral().fqn(), this.getPosition().getName(), QueryableIterable.from(this.keySet()).collectOne(a -> a.getName()), other.getPosition().getPeripheral().fqn(), other.getPosition().getName(), QueryableIterable.from(other.keySet()).collectOne(a -> a.getName())));
        }
        LinkedHashSet<Axis> movingAxes = new LinkedHashSet<Axis>(this.getPeripheralType().getAxes().size());
        for (Map.Entry entry : this.entrySet()) {
            if (((BigDecimal)entry.getValue()).compareTo((BigDecimal)other.get(entry.getKey())) == 0) continue;
            movingAxes.add((Axis)entry.getKey());
        }
        return movingAxes;
    }

    static final List<Axis> safeGetAxes(SymbolicPosition position) {
        if (position == null) {
            return Collections.emptyList();
        }
        Peripheral peripheral = position.getPeripheral();
        if (peripheral == null) {
            return Collections.emptyList();
        }
        PeripheralType peripheralType = peripheral.getType();
        if (peripheralType == null) {
            return Collections.emptyList();
        }
        return peripheralType.getAxes();
    }
}

