/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.motioncalculator.util;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsat.motioncalculator.MotionProfile;
import org.eclipse.lsat.motioncalculator.MotionSetPoint;

public final class MotionSetPointUtilities {
    private MotionSetPointUtilities() {
    }

    public static boolean isMotionProfile(Collection<MotionSetPoint> setPoints, String motionProfileKey) {
        return setPoints.stream().map(MotionSetPoint::getMotionProfile).allMatch(p -> Objects.equals(p.getKey(), motionProfileKey));
    }

    public static Set<MotionProfile> getMotionProfiles(Collection<MotionSetPoint> setPoints) {
        return setPoints.stream().map(MotionSetPoint::getMotionProfile).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static BigDecimal getFrom(List<MotionSetPoint> setPoints) {
        BigDecimal from;
        if (setPoints.size() > 0 && (from = setPoints.get(0).getFrom()) != null) {
            return from;
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getTo(List<MotionSetPoint> setPoints) {
        BigDecimal to;
        if (setPoints.size() > 0 && (to = setPoints.get(setPoints.size() - 1).getTo()) != null) {
            return to;
        }
        return MotionSetPointUtilities.getFrom(setPoints).add(MotionSetPointUtilities.getDistance(setPoints));
    }

    public static BigDecimal getFrom(MotionSetPoint setPoint, BigDecimal defaultValue) {
        BigDecimal from = setPoint.getFrom();
        if (from != null) {
            return from;
        }
        return defaultValue;
    }

    public static BigDecimal getTo(MotionSetPoint setPoint, BigDecimal defaultValue) {
        BigDecimal to = setPoint.getTo();
        if (to != null) {
            return to;
        }
        return defaultValue;
    }

    public static BigDecimal getDistance(List<MotionSetPoint> setPoints) {
        double sAbsOld;
        BigDecimal distance = setPoints.stream().map(MotionSetPoint::getDistance).reduce((a, b) -> a.add((BigDecimal)b)).get();
        double sAbs = distance.abs().doubleValue();
        MotionSetPoint first = setPoints.get(0);
        MotionSetPoint last = setPoints.get(setPoints.size() - 1);
        if (first.getFrom() != null && last.getTo() != null && (sAbsOld = last.getTo().subtract(first.getFrom()).abs().doubleValue()) != sAbs) {
            throw new RuntimeException("New Calculation method differs from old method");
        }
        return distance;
    }
}

