/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.statespace;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.graph.DoubleWeightedGraph;
import org.eclipse.lsat.common.ludus.backend.graph.SingleWeightedGraph;
import org.eclipse.lsat.common.ludus.backend.statespace.Configuration;
import org.eclipse.lsat.common.ludus.backend.statespace.Transition;

public class MaxPlusStateSpace
implements SingleWeightedGraph<Configuration, Transition, Value>,
DoubleWeightedGraph<Configuration, Transition, Value> {
    private static final long serialVersionUID = 1L;
    private final Set<Configuration> configurations = new HashSet<Configuration>();
    private final Set<Transition> transitions = new HashSet<Transition>();
    private Configuration initial;
    private final Map<Configuration, Set<Transition>> outgoingMap = new HashMap<Configuration, Set<Transition>>();
    private final Map<Configuration, Set<Transition>> incomingMap = new HashMap<Configuration, Set<Transition>>();

    public Set<Configuration> getConfigurations() {
        return this.configurations;
    }

    public Configuration getInitialConfiguration() {
        return this.initial;
    }

    public void setInitialConfiguration(Configuration initialConfiguration) {
        this.initial = initialConfiguration;
    }

    public boolean hasInitialConfiguration() {
        return this.initial != null;
    }

    public void addConfiguration(Configuration configuration) {
        this.configurations.add(configuration);
    }

    public void addTransition(Transition transition) {
        Configuration src = transition.getSource();
        Configuration tgt = transition.getTarget();
        this.outgoingMap.putIfAbsent(src, new HashSet());
        Set<Transition> out = this.outgoingMap.get(src);
        out.add(transition);
        this.incomingMap.putIfAbsent(tgt, new HashSet());
        Set<Transition> in = this.incomingMap.get(tgt);
        in.add(transition);
        this.transitions.add(transition);
    }

    @Override
    public Value getWeight1(Transition edge) {
        return edge.getReward();
    }

    @Override
    public Value getWeight2(Transition edge) {
        return edge.getDuration();
    }

    @Override
    public Value getWeight(Transition edge) {
        return edge.getDuration();
    }

    @Override
    public Set<Configuration> getVertices() {
        return this.getConfigurations();
    }

    @Override
    public Set<Transition> getEdges() {
        return this.transitions;
    }

    @Override
    public Collection<Transition> incomingEdgesOf(Configuration configuration) {
        return this.incomingMap.getOrDefault(configuration, Collections.emptySet());
    }

    @Override
    public Collection<Transition> outgoingEdgesOf(Configuration configuration) {
        return this.outgoingMap.getOrDefault(configuration, Collections.emptySet());
    }

    @Override
    public Configuration getEdgeSource(Transition transition) {
        return transition.getSource();
    }

    @Override
    public Configuration getEdgeTarget(Transition transition) {
        return transition.getTarget();
    }

    @Override
    public Transition getEdge(Configuration source, Configuration target) {
        for (Transition t : this.outgoingEdgesOf(source)) {
            if (!t.getTarget().equals(target)) continue;
            return t;
        }
        return null;
    }
}

