/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.fsm.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsat.common.ludus.backend.fsm.FSM;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;

public class FSMImpl
implements FSM<Location, Edge> {
    private static final long serialVersionUID = 257010773286341614L;
    private Set<Location> locations = new LinkedHashSet<Location>();
    private Set<Location> markedLocations = new HashSet<Location>();
    private HashMap<String, Location> locMap = new HashMap();
    private Location initial;
    private Map<Location, Set<Edge>> outgoingMap;
    private Set<String> controllable = new HashSet<String>();
    private Set<String> uncontrollable = new HashSet<String>();

    public FSMImpl() {
        this.outgoingMap = new HashMap<Location, Set<Edge>>();
    }

    public void addLocation(Location ... locations) {
        Location[] locationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            Location loc = locationArray[n2];
            this.locMap.put(loc.getName(), loc);
            this.locations.add(loc);
            ++n2;
        }
    }

    public Location getLocation(String name) {
        return this.locMap.get(name);
    }

    public void setInitial(Location initial) {
        this.initial = initial;
    }

    public Edge addEdge(Location source, Location target, String event) {
        Edge edge = new Edge(source, event, target);
        this.addEdge(edge);
        return edge;
    }

    public void removeEdge(Location source, Location target, String event) {
        this.outgoingMap.get(source).remove(this.getEdge(source, target, event));
    }

    public void addEdge(Edge edge) {
        Location src = edge.getSource();
        this.outgoingMap.putIfAbsent(src, new HashSet());
        Set<Edge> out = this.outgoingMap.get(src);
        out.add(edge);
    }

    public void addControllable(String ... events) {
        Collections.addAll(this.controllable, events);
    }

    public void addUncontrollable(String ... events) {
        Collections.addAll(this.uncontrollable, events);
    }

    public void removeControllable(String ... events) {
        String[] stringArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            String event = stringArray[n2];
            this.controllable.remove(event);
            ++n2;
        }
    }

    public void removeUncontrollable(String ... events) {
        String[] stringArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            String event = stringArray[n2];
            this.uncontrollable.remove(event);
            ++n2;
        }
    }

    @Override
    public Location getInitial() {
        return this.initial;
    }

    @Override
    public Set<String> getControllable() {
        return this.controllable;
    }

    @Override
    public Set<String> getUncontrollable() {
        return this.uncontrollable;
    }

    @Override
    public Set<Edge> incomingEdgesOf(Location location) {
        HashSet<Edge> incoming = new HashSet<Edge>();
        for (Location l : this.getVertices()) {
            for (Edge e : this.outgoingEdgesOf(l)) {
                if (!e.getTarget().equals(location)) continue;
                incoming.add(e);
            }
        }
        return incoming;
    }

    @Override
    public Set<Edge> outgoingEdgesOf(Location location) {
        return this.outgoingMap.getOrDefault(location, Collections.emptySet());
    }

    @Override
    public Set<Location> getVertices() {
        return this.locations;
    }

    @Override
    public Set<Edge> getEdges() {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (Location l : this.getVertices()) {
            edges.addAll(this.outgoingEdgesOf(l));
        }
        return edges;
    }

    @Override
    public Location getEdgeSource(Edge edge) {
        return edge.getSource();
    }

    @Override
    public Location getEdgeTarget(Edge edge) {
        return edge.getTarget();
    }

    @Override
    public Edge getEdge(Location source, Location target) {
        for (Edge e : this.outgoingEdgesOf(source)) {
            if (!e.getTarget().equals(target)) continue;
            return e;
        }
        return null;
    }

    @Override
    public Collection<Edge> getEdges(Location source, Location target) {
        return this.outgoingEdgesOf(source).stream().filter(e -> e.getTarget().equals(target)).collect(Collectors.toSet());
    }

    @Override
    public Edge getEdge(Location source, Location target, String event) {
        for (Edge e : this.outgoingEdgesOf(source)) {
            if (!e.getTarget().equals(target) || !e.getEvent().equals(event)) continue;
            return e;
        }
        return null;
    }

    @Override
    public boolean isMarked(Location l) {
        return this.markedLocations.contains(l);
    }

    public void setMarked(Location ... l) {
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location loc = locationArray[n2];
            this.markedLocations.add(loc);
            ++n2;
        }
    }

    public void unsetMarked(Location ... l) {
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location loc = locationArray[n2];
            this.markedLocations.remove(loc);
            ++n2;
        }
    }

    public Set<Location> getMarkedVertices() {
        return this.markedLocations;
    }

    @Override
    public String getEvent(Edge e) {
        return e.getEvent();
    }

    @Override
    public Set<String> getAlphabet() {
        HashSet<String> alphabet = new HashSet<String>();
        alphabet.addAll(this.getControllable());
        alphabet.addAll(this.getUncontrollable());
        return alphabet;
    }

    @Override
    public boolean hasEdge(Location source, Location target, String event) {
        return this.outgoingEdgesOf(source).stream().anyMatch(e -> e.getTarget().equals(target) && e.getEvent().equals(event));
    }

    public static FSMImpl clone(FSM<Location, Edge> fsm) {
        FSMImpl newFSM = new FSMImpl();
        for (String uEvent : fsm.getUncontrollable()) {
            newFSM.addUncontrollable(uEvent);
        }
        for (String cEvent : fsm.getControllable()) {
            newFSM.addControllable(cEvent);
        }
        newFSM.markedLocations = new HashSet<Location>();
        Location initial = fsm.getInitial();
        for (Location l : fsm.getVertices()) {
            Location lNew = new Location(l.getName());
            newFSM.addLocation(lNew);
            if (l.equals(initial)) {
                newFSM.setInitial(lNew);
            }
            if (!fsm.isMarked(l)) continue;
            newFSM.markedLocations.add(lNew);
        }
        for (Edge edge : fsm.getEdges()) {
            String srcName = edge.getSource().getName();
            String tgtName = edge.getTarget().getName();
            newFSM.addEdge(newFSM.getLocation(srcName), newFSM.getLocation(tgtName), edge.getEvent());
        }
        return newFSM;
    }
}

