/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.mpt.ui;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ActivityTransformationHandler {
    @Inject
    UISynchronize sync;
    IFile activityFile;
    IFile cifFile;

    @Execute
    public void execute(@Optional @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, Shell shell, IWorkspace workspace) {
        if (selection == null || !(selection.getFirstElement() instanceof IFile)) {
            return;
        }
        if (!PlatformUI.getWorkbench().saveAllEditors(true)) {
            return;
        }
        this.activityFile = (IFile)selection.getFirstElement();
        this.cifFile = this.selectCifSpecification();
        if (this.cifFile == null) {
            return;
        }
    }

    protected IFile selectCifSpecification() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle("Select a CIF specification");
        dialog.setMessage("Select a CIF specification to attach to the activity specification.");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return ((IFile)element).getFileExtension().equalsIgnoreCase("cif");
                }
                return element instanceof IContainer;
            }
        });
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length != 1 || !(selection[0] instanceof IFile)) {
                    return new Status(4, "org.eclipse.lsat.mpt.ui", 0, "Please select one CIF specification.", null);
                }
                return new Status(0, "org.eclipse.lsat.mpt.ui", 0, "OK", null);
            }
        });
        dialog.setInitialSelection((Object)ResourcesPlugin.getWorkspace().getRoot().getFile(this.activityFile.getFullPath().removeFileExtension().addFileExtension("cif")));
        dialog.open();
        return dialog.getResult() == null ? null : (IFile)dialog.getResult()[0];
    }
}

