/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.mpt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FSMType implements Enumerator
{
    REQUIREMENT(1, "Requirement", "Requirement"),
    PLANT(2, "Plant", "Plant"),
    SUPERVISOR(3, "Supervisor", "Supervisor"),
    NONE(0, "None", "None");

    public static final int REQUIREMENT_VALUE = 1;
    public static final int PLANT_VALUE = 2;
    public static final int SUPERVISOR_VALUE = 3;
    public static final int NONE_VALUE = 0;
    private static final FSMType[] VALUES_ARRAY;
    public static final List<FSMType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FSMType[]{REQUIREMENT, PLANT, SUPERVISOR, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FSMType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FSMType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FSMType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FSMType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FSMType get(int value) {
        switch (value) {
            case 1: {
                return REQUIREMENT;
            }
            case 2: {
                return PLANT;
            }
            case 3: {
                return SUPERVISOR;
            }
            case 0: {
                return NONE;
            }
        }
        return null;
    }

    private FSMType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

