/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timinganalysis.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.internal.browser.WebBrowserEditor;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.panel.CrosshairOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.Crosshair;

public class AnimationView
extends WebBrowserEditor {
    private final DomainCrosshairOverlay traceOverlay = new DomainCrosshairOverlay();
    private TraceView traceView;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.installBrowserFunctions(this.webBrowser.getBrowser());
    }

    protected void installBrowserFunctions(Browser browser) {
        new BrowserFunction(browser, "setAnimationTime"){

            public Object function(Object[] arguments) {
                double value = (Double)arguments[0];
                AnimationView.this.traceOverlay.getDomainCrosshair().setValue(value);
                return null;
            }
        };
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        final IPartService service = (IPartService)this.getSite().getService(IPartService.class);
        service.addPartListener(new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part == AnimationView.this.traceView || part == AnimationView.this) {
                    AnimationView.this.unlinkTraceEditor();
                }
                if (part == AnimationView.this) {
                    service.removePartListener((IPartListener)this);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        });
    }

    public synchronized void linkTraceEditor(TraceView traceView) {
        this.unlinkTraceEditor();
        this.traceView = traceView;
        ChartPanel chartPanel = traceView.getViewer().getChartPanel();
        if (chartPanel != null) {
            chartPanel.addOverlay((Overlay)this.traceOverlay);
        }
        this.getSite().getShell().getDisplay().asyncExec(() -> ((BrowserViewer)this.webBrowser).refresh());
    }

    private synchronized void unlinkTraceEditor() {
        ChartPanel chartPanel;
        if (this.traceView != null && (chartPanel = this.traceView.getViewer().getChartPanel()) != null) {
            chartPanel.removeOverlay((Overlay)this.traceOverlay);
        }
        this.traceView = null;
    }

    private static class DomainCrosshairOverlay
    extends CrosshairOverlay {
        private static final long serialVersionUID = -241836797060724404L;
        private final Crosshair domainCrosshair = new Crosshair(0.0, (Paint)new Color(70, 130, 180, 192), (Stroke)new BasicStroke(4.0f));

        public DomainCrosshairOverlay() {
            this.addDomainCrosshair(this.domainCrosshair);
        }

        public Crosshair getDomainCrosshair() {
            return this.domainCrosshair;
        }
    }
}

