/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.scheduler;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.function.Consumer;
import lsat_graph.ActionTask;
import lsat_graph.DispatchGroupTask;
import org.eclipse.lsat.common.graph.directed.DirectedGraph;
import org.eclipse.lsat.common.graph.directed.Edge;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.timing.util.ITimingCalculator;
import org.eclipse.lsat.timing.util.SpecificationException;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FinalFieldsConstructor
public class AddExecutionTimes {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddExecutionTimes.class);
    @Extension
    private final ITimingCalculator timingCalculator;

    public <T extends Task> TaskDependencyGraph<T> transformModel(TaskDependencyGraph<T> graph) throws SpecificationException, MotionException {
        LOGGER.debug("Starting transformation");
        this.addExecutionTimes((DirectedGraph)graph);
        LOGGER.debug("Finished transformation");
        return graph;
    }

    private <T extends Task, E extends Edge> void addExecutionTimes(DirectedGraph<T, E> graph) throws SpecificationException, MotionException {
        Consumer<DirectedGraph> _function = it -> {
            try {
                this.addExecutionTimes((DirectedGraph)it);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        graph.getSubGraphs().forEach(_function);
        Consumer<Task> _function_1 = it -> {
            try {
                this.addExecutionTime((Task)it);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        graph.getNodes().forEach(_function_1);
    }

    private void _addExecutionTime(DispatchGroupTask task) {
        boolean _tripleEquals;
        BigDecimal _executionTime = task.getExecutionTime();
        boolean bl = _tripleEquals = _executionTime == null;
        if (_tripleEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Expected execution time to be set for task: ");
            _builder.append((Object)task);
            throw new IllegalStateException(_builder.toString());
        }
    }

    private void _addExecutionTime(ActionTask<?> task) throws SpecificationException, MotionException {
        task.setExecutionTime(this.timingCalculator.calculateDuration((Node)task.getAction()));
    }

    @XbaseGenerated
    private void addExecutionTime(Task task) throws SpecificationException, MotionException {
        if (task instanceof ActionTask) {
            this._addExecutionTime((ActionTask)task);
            return;
        }
        if (task instanceof DispatchGroupTask) {
            this._addExecutionTime((DispatchGroupTask)task);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(task).toString());
    }

    public AddExecutionTimes(ITimingCalculator timingCalculator) {
        this.timingCalculator = timingCalculator;
    }
}

