/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.qvto.util.internal;

import org.eclipse.lsat.common.qvto.util.internal.AbstractQvtLog;
import org.eclipse.lsat.common.qvto.util.internal.MessageTuple;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Log4Slf4jLog
extends AbstractQvtLog {
    private final Logger itsLogger;
    private MessageTuple itsLastMessage = null;

    public Log4Slf4jLog(Logger aLogger) {
        this.itsLogger = aLogger;
    }

    public MessageTuple getLastMessage() {
        return this.itsLastMessage;
    }

    public boolean hasLastMessage() {
        return this.itsLastMessage != null;
    }

    @Override
    protected synchronized void doLog(AbstractQvtLog.LogLevel aLevel, String aFormat, Object ... aArgs) {
        switch (aLevel) {
            case Trace: {
                if (this.itsLogger.isTraceEnabled()) break;
                return;
            }
            case Debug: {
                if (this.itsLogger.isDebugEnabled()) break;
                return;
            }
            case Info: {
                if (this.itsLogger.isInfoEnabled()) break;
                return;
            }
        }
        String message = this.createMessage(aFormat, aArgs);
        switch (aLevel) {
            case Trace: {
                this.itsLogger.trace(message);
                break;
            }
            case Debug: {
                this.itsLogger.debug(message);
                break;
            }
            case Info: {
                this.itsLogger.info(message);
                break;
            }
            case Warning: {
                this.itsLogger.warn(message);
                this.itsLastMessage = new MessageTuple(message);
                if (!this.itsLastMessage.hasErrorCode()) break;
                Marker marker = MarkerFactory.getMarker((String)this.itsLastMessage.getErrorCode());
                this.itsLogger.warn(marker, this.itsLastMessage.getMessage());
                break;
            }
            case Error: 
            case Fatal: {
                this.itsLogger.error(message);
                this.itsLastMessage = new MessageTuple(message);
            }
        }
    }
}

