/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.scheduler.schedule;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DependencyBoundary implements Enumerator
{
    IN_RESOURCE(0, "inResource", "inResource"),
    CROSS_RESOURCE(1, "crossResource", "crossResource"),
    CROSS_RESOURCE_CONTAINER(2, "crossResourceContainer", "crossResourceContainer");

    public static final int IN_RESOURCE_VALUE = 0;
    public static final int CROSS_RESOURCE_VALUE = 1;
    public static final int CROSS_RESOURCE_CONTAINER_VALUE = 2;
    private static final DependencyBoundary[] VALUES_ARRAY;
    public static final List<DependencyBoundary> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DependencyBoundary[]{IN_RESOURCE, CROSS_RESOURCE, CROSS_RESOURCE_CONTAINER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DependencyBoundary get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DependencyBoundary result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DependencyBoundary getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DependencyBoundary result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DependencyBoundary get(int value) {
        switch (value) {
            case 0: {
                return IN_RESOURCE;
            }
            case 1: {
                return CROSS_RESOURCE;
            }
            case 2: {
                return CROSS_RESOURCE_CONTAINER;
            }
        }
        return null;
    }

    private DependencyBoundary(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

