/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.ecore.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.lsat.common.emf.common.util.FastContainsEList;

public class EcoreUtility {
    private EcoreUtility() {
    }

    public static Notifier getRoot(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource == null) {
            return EcoreUtil.getRootContainer((EObject)eObject);
        }
        ResourceSet resourceSet = resource.getResourceSet();
        return resourceSet != null ? resourceSet : resource;
    }

    public static void deleteAll(Collection<? extends EObject> eObjects) {
        HashSet<Notifier> roots = new HashSet<Notifier>();
        for (EObject eObject : eObjects) {
            roots.add(EcoreUtility.getRoot(eObject));
        }
        Map map = EcoreUtil.UsageCrossReferencer.findAll(eObjects, roots);
        for (Map.Entry entry : map.entrySet()) {
            EObject eObject = (EObject)entry.getKey();
            for (EStructuralFeature.Setting setting : (Collection)entry.getValue()) {
                if (!setting.getEStructuralFeature().isChangeable()) continue;
                EcoreUtil.remove((EStructuralFeature.Setting)setting, (Object)eObject);
            }
        }
        EcoreUtility.removeAll(eObjects);
    }

    public static void deleteAll(Collection<? extends EObject> eObjects, boolean recursive) {
        if (!recursive) {
            EcoreUtility.deleteAll(eObjects);
            return;
        }
        HashSet<Notifier> roots = new HashSet<Notifier>();
        for (EObject eObject : eObjects) {
            roots.add(EcoreUtility.getRoot(eObject));
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<InternalEObject> crossResourceEObjects = new HashSet<InternalEObject>();
        hashSet.addAll(eObjects);
        for (EObject eObject : eObjects) {
            TreeIterator j = eObject.eAllContents();
            while (j.hasNext()) {
                InternalEObject childEObject = (InternalEObject)j.next();
                if (childEObject.eDirectResource() != null) {
                    crossResourceEObjects.add(childEObject);
                    continue;
                }
                hashSet.add(childEObject);
            }
        }
        Map map = EcoreUtil.UsageCrossReferencer.findAll(hashSet, roots);
        for (Map.Entry entry : map.entrySet()) {
            EObject deletedEObject = (EObject)entry.getKey();
            Collection settings = (Collection)entry.getValue();
            for (EStructuralFeature.Setting setting : settings) {
                if (hashSet.contains(setting.getEObject()) || !setting.getEStructuralFeature().isChangeable()) continue;
                EcoreUtil.remove((EStructuralFeature.Setting)setting, (Object)deletedEObject);
            }
        }
        EcoreUtility.removeAll(eObjects);
        for (EObject eObject : crossResourceEObjects) {
            EcoreUtil.remove((EObject)eObject.eContainer(), (EStructuralFeature)eObject.eContainmentFeature(), (Object)eObject);
        }
    }

    public static void removeAll(Collection<? extends EObject> eObjects) {
        IdentityHashMap<EStructuralFeature.Setting, Collection> buckets = new IdentityHashMap<EStructuralFeature.Setting, Collection>();
        for (EObject eObject : eObjects) {
            Resource.Internal resource;
            InternalEObject internalEObject = (InternalEObject)eObject;
            InternalEObject container = internalEObject.eInternalContainer();
            if (container != null) {
                EStructuralFeature.Setting setting = container.eSetting(eObject.eContainingFeature());
                Object values = (Collection)buckets.get(setting);
                if (values == null) {
                    values = new FastContainsEList.FastCompare();
                    buckets.put(setting, (Collection)values);
                }
                values.add(eObject);
            }
            if ((resource = internalEObject.eDirectResource()) == null) continue;
            resource.getContents().remove((Object)eObject);
        }
        for (Map.Entry entry : buckets.entrySet()) {
            EcoreUtility.removeAll((EStructuralFeature.Setting)entry.getKey(), (Collection)entry.getValue());
        }
    }

    public static void removeAll(EObject eObject, EStructuralFeature eStructuralFeature, Collection<?> values) {
        if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)eStructuralFeature)) {
            ((List)eObject.eGet(eStructuralFeature)).removeAll(values);
        } else {
            eObject.eUnset(eStructuralFeature);
        }
    }

    public static void removeAll(EStructuralFeature.Setting setting, Collection<?> values) {
        if (FeatureMapUtil.isMany((EObject)setting.getEObject(), (EStructuralFeature)setting.getEStructuralFeature())) {
            ((List)setting.get(false)).removeAll(values);
        } else {
            setting.unset();
        }
    }
}

