/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.diagram.design;

import activity.Activity;
import java.util.Collection;
import machine.IResource;
import machine.Machine;
import machine.provider.MachineItemProviderAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.lsat.activity.diagram.services.ActivityServices;
import org.eclipse.lsat.common.emf.ui.model.ModelWorkbenchContentProvider;
import org.eclipse.lsat.common.emf.ui.wizards.ElementTreeSelectionWizardPage;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class AddResourceWizard
extends Wizard {
    private final ElementTreeSelectionWizardPage resourceSelectionPage;
    private IResource resource;
    private final Activity activity;

    public AddResourceWizard(Collection<EObject> roots, Activity activity, EObject initialSelection) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new MachineItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.activity = activity;
        this.resourceSelectionPage = this.createResourceSelectionPage(roots, initialSelection, (AdapterFactory)adapterFactory);
    }

    private ElementTreeSelectionWizardPage createResourceSelectionPage(Collection<EObject> roots, EObject initialSelection, AdapterFactory adapterFactory) {
        ElementTreeSelectionWizardPage resourceSelectionPage = new ElementTreeSelectionWizardPage("PeripheralSelectionPage", (IBaseLabelProvider)new AdapterFactoryLabelProvider(adapterFactory), (ITreeContentProvider)new ModelWorkbenchContentProvider(new AdapterFactory[0]));
        resourceSelectionPage.setTitle("Select a resource");
        resourceSelectionPage.setMessage("Select an existing resource to add to the diagram.");
        resourceSelectionPage.setInput(roots);
        resourceSelectionPage.setAllowMultiple(false);
        final Collection<IResource> existing = ActivityServices.getResources(this.activity);
        resourceSelectionPage.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !existing.contains(element) && (element instanceof Machine || element instanceof IResource);
            }
        });
        resourceSelectionPage.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length <= 0) {
                    return new Status(4, "org.eclipse.lsat.activity.diagram.design", 0, "Please select a resource!", null);
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    if (!(selected instanceof IResource)) {
                        return new Status(4, "org.eclipse.lsat.activity.diagram.design", 0, "Only resource selection is allowed!", null);
                    }
                    ++n2;
                }
                return new Status(0, "org.eclipse.lsat.activity.diagram.design", 0, "OK", null);
            }
        });
        resourceSelectionPage.setInitialSelections(new Object[]{initialSelection});
        return resourceSelectionPage;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.resourceSelectionPage);
    }

    public IWizardPage getStartingPage() {
        if (this.resourceSelectionPage.isPageComplete()) {
            return this.getNextPage((IWizardPage)this.resourceSelectionPage);
        }
        return super.getStartingPage();
    }

    public boolean performFinish() {
        this.resource = (IResource)this.resourceSelectionPage.getResult()[0];
        return true;
    }

    public IResource getResource() {
        return this.resource;
    }
}

