/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.contributions.ui.project;

import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.lsat.contributions.ui.Activator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import setting.SettingActivator;

public class LogisticsProjectProperties
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Text text;

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gl_container = new GridLayout();
        gl_container.numColumns = 3;
        container.setLayout((Layout)gl_container);
        Label lblPhysicalSettings = new Label(container, 0);
        lblPhysicalSettings.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPhysicalSettings.setText("Physical settings:");
        this.text = new Text(container, 2048);
        this.text.setEditable(false);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        try {
            this.text.setText(SettingActivator.getDefault().getSettingIResource((IResource)this.getProject()).getProjectRelativePath().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Button btnBrowse = new Button(container, 0);
        btnBrowse.setText("Browse...");
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile settingIResource = LogisticsProjectProperties.this.selectSettingIResource();
                LogisticsProjectProperties.this.text.setText(settingIResource == null ? "" : settingIResource.getProjectRelativePath().toString());
            }
        });
        return container;
    }

    public boolean performOk() {
        Preferences preferences = SettingActivator.getDefault().getProjectPreferences(this.getProject());
        IResource settingIResource = this.getProject().findMember(this.text.getText());
        if (settingIResource == null) {
            preferences.remove(SettingActivator.PREFERENCE_SETTINGS);
        } else {
            preferences.put(SettingActivator.PREFERENCE_SETTINGS, settingIResource.getProjectRelativePath().toString());
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.lsat.contributions.ui", e.getMessage(), (Throwable)e));
        }
        return true;
    }

    private IFile selectSettingIResource() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle("Select physical settings");
        dialog.setMessage("Select the active setting file for this project");
        dialog.setAllowMultiple(false);
        dialog.setInput((Object)this.getProject());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return Objects.equals("setting", ((IFile)element).getFileExtension());
                }
                return element instanceof IContainer;
            }
        });
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length <= 0) {
                    return new Status(4, "org.eclipse.lsat.contributions.ui", 0, "Please select a setting file!", null);
                }
                return new Status(0, "org.eclipse.lsat.contributions.ui", 0, "OK", null);
            }
        });
        IResource settingIResource = this.getProject().findMember(this.text.getText());
        if (settingIResource != null) {
            dialog.setInitialSelection((Object)settingIResource);
        }
        return dialog.open() == 0 ? (IFile)dialog.getFirstResult() : null;
    }

    private IProject getProject() {
        return (IProject)IProject.class.cast(this.getElement().getAdapter(IProject.class));
    }
}

