/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.setting.teditor.validation;

import com.google.common.collect.Iterables;
import expressions.Declaration;
import expressions.ExpressionsPackage;
import expressions.impl.DeclarationRefImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import machine.ActionType;
import machine.Axis;
import machine.IResource;
import machine.Import;
import machine.Machine;
import machine.MachinePackage;
import machine.Peripheral;
import machine.Position;
import machine.Profile;
import machine.Resource;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.lsat.common.xtend.Queries;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.motioncalculator.MotionProfile;
import org.eclipse.lsat.setting.teditor.validation.AbstractSettingValidator;
import org.eclipse.lsat.timing.calculator.MotionCalculatorExtension;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import setting.MotionProfileSettings;
import setting.MotionSettings;
import setting.PhysicalSettings;
import setting.SettingPackage;
import setting.Settings;
import setting.impl.MotionSettingsMapEntryImpl;

public class SettingValidator
extends AbstractSettingValidator {
    public static final String INVALID_IMPORT = "invalidImport";

    @Check
    public void checkImportIsValid(Import imp) {
        try {
            boolean isUnderstood;
            boolean isImportUriValid = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
            if (!isImportUriValid) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("The import ");
                String _importURI = imp.getImportURI();
                _builder.append(_importURI);
                _builder.append(" cannot be resolved. Make sure that the name is spelled correctly.");
                this.error(_builder.toString(), (EObject)imp, (EStructuralFeature)MachinePackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
            if (!(isUnderstood = imp.getImportURI().matches(".*\\.(machine|setting)"))) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Importing ");
                String _importURI_1 = imp.getImportURI();
                _builder_1.append(_importURI_1);
                _builder_1.append(" is not allowed. Only 'machine' and 'setting' files are allowed");
                this.error(_builder_1.toString(), (EObject)imp, (EStructuralFeature)MachinePackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("The import ");
                String _importURI_2 = imp.getImportURI();
                _builder_2.append(_importURI_2);
                _builder_2.append(" is not a valid URI.");
                this.error(_builder_2.toString(), (EObject)imp, (EStructuralFeature)MachinePackage.Literals.IMPORT__IMPORT_URI, INVALID_IMPORT, new String[0]);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    @Check
    public void checkPhysicalSettingsForDuplicates(Settings settings) {
        Functions.Function1 _function = it -> it.getResource();
        Consumer<List> _function_1 = it -> {
            Functions.Function1 _function_2 = it_1 -> it_1.getPeripheral();
            Functions.Function1 _function_3 = it_1 -> {
                int _size = it_1.size();
                return _size > 1;
            };
            Consumer<PhysicalSettings> _function_4 = duplicate -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Physical settings have been defined more than once for peripheral ");
                String _fqn = duplicate.fqn();
                _builder.append(_fqn);
                _builder.append(". Please remove all duplicate instances.");
                this.error(_builder.toString(), (EObject)settings, (EStructuralFeature)SettingPackage.Literals.SETTINGS__PHYSICAL_SETTINGS, settings.getPhysicalSettings().indexOf(duplicate));
            };
            Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)it, (Functions.Function1)_function_2).values(), (Functions.Function1)_function_3)).forEach(_function_4);
        };
        IterableExtensions.groupBy((Iterable)settings.getPhysicalSettings(), (Functions.Function1)_function).values().forEach(_function_1);
    }

    @Check
    public void checkPhysicalSettingsForDuplicatesinResourceResourceImpl(Settings settings) {
        Functions.Function1 _function = it -> it.getResource().getResource();
        Consumer<List> _function_1 = it -> {
            Functions.Function1 _function_2 = it_1 -> it_1.getPeripheral();
            Functions.Function1 _function_3 = it_1 -> {
                Functions.Function1 _function_4 = it_2 -> it_2.getResource().getClass();
                int _size = IterableExtensions.groupBy((Iterable)it_1, (Functions.Function1)_function_4).size();
                return _size > 1;
            };
            Consumer<PhysicalSettings> _function_4 = it_1 -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Physical settings have been defined for resource and resource item. Settings must be defined on Resource or all Resource items.");
                this.error(_builder.toString(), (EObject)settings, (EStructuralFeature)SettingPackage.Literals.SETTINGS__PHYSICAL_SETTINGS, settings.getPhysicalSettings().indexOf(it_1));
            };
            Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)it, (Functions.Function1)_function_2).values(), (Functions.Function1)_function_3)).forEach(_function_4);
        };
        IterableExtensions.groupBy((Iterable)settings.getPhysicalSettings(), (Functions.Function1)_function).values().forEach(_function_1);
    }

    @Check
    public void checkTransitivePhysicalSettingsForDuplicates(Settings settings) {
        Consumer<Import> _function = imp -> {
            Functions.Function1 _function_1 = it -> it.getPhysicalSettings();
            Iterable importedSettings = Queries.collect(this.loadSettings((Import)imp), (Functions.Function1)_function_1);
            Functions.Function1 _function_2 = ps -> this.hasDuplicate(importedSettings, (PhysicalSettings)ps);
            Consumer<PhysicalSettings> _function_3 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Settings for peripheral '");
                String _fqn = it.fqn();
                _builder.append(_fqn);
                _builder.append("' are already defined in '");
                String _importURI = imp.getImportURI();
                _builder.append(_importURI);
                _builder.append("'. Remove either the import or this definition.");
                String errorText = _builder.toString();
                this.error(errorText, (EObject)settings, (EStructuralFeature)SettingPackage.Literals.SETTINGS__PHYSICAL_SETTINGS, settings.getPhysicalSettings().indexOf(it));
                this.error(errorText, (EObject)imp, (EStructuralFeature)MachinePackage.Literals.IMPORT__IMPORT_URI);
            };
            IterableExtensions.filter((Iterable)settings.getPhysicalSettings(), (Functions.Function1)_function_2).forEach(_function_3);
        };
        settings.getImports().forEach(_function);
    }

    public boolean hasDuplicate(Iterable<PhysicalSettings> col, PhysicalSettings ps) {
        Functions.Function1 _function = it -> Objects.equals(it.getPeripheral(), ps.getPeripheral()) && (Objects.equals(it.getResource(), ps.getResource()) || Objects.equals(it.getResource(), ps.getResource().getResource()));
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter(col, (Functions.Function1)_function));
        return !_isEmpty;
    }

    @Check
    public void checkTransitivePhysicalSettingsForDuplicatesInImports(Settings settings) {
        HashMap importContents = new HashMap();
        Consumer<Import> _function = it -> {
            Functions.Function1 _function_1 = it_1 -> it_1.getPhysicalSettings();
            importContents.put(it, IterableExtensions.toSet((Iterable)Queries.collect(this.loadSettings((Import)it), (Functions.Function1)_function_1)));
        };
        settings.getImports().forEach(_function);
        Functions.Function1 _function_1 = it -> it.getResource();
        Consumer<List> _function_2 = it -> {
            Functions.Function1 _function_3 = it_1 -> it_1.getPeripheral();
            Functions.Function1 _function_4 = it_1 -> {
                int _size = it_1.size();
                return _size > 1;
            };
            Consumer<PhysicalSettings> _function_5 = setting -> {
                Functions.Function1 _function_6 = it_1 -> ((Collection)it_1.getValue()).contains(setting);
                Import imp = (Import)((Map.Entry)IterableExtensions.findFirst(importContents.entrySet(), (Functions.Function1)_function_6)).getKey();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Duplicate definition of '");
                String _fqn = setting.fqn();
                _builder.append(_fqn);
                _builder.append("'. Remove import or one of the '");
                String _fqn_1 = setting.fqn();
                _builder.append(_fqn_1);
                _builder.append("' definitions.");
                String errorText = _builder.toString();
                this.error(errorText, (EObject)imp, (EStructuralFeature)MachinePackage.Literals.IMPORT__IMPORT_URI);
            };
            Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)it, (Functions.Function1)_function_3).values(), (Functions.Function1)_function_4)).forEach(_function_5);
        };
        IterableExtensions.groupBy((Iterable)Iterables.concat(importContents.values()), (Functions.Function1)_function_1).values().forEach(_function_2);
    }

    @Check
    public void checkDeclarationsForDuplicates(Settings settings) {
        Functions.Function1 _function = it -> it.getName();
        Functions.Function1 _function_1 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<Declaration> _function_2 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Declaration '");
            String _name = it.getName();
            _builder.append(_name);
            _builder.append("' declared more than once, please remove one");
            this.error(_builder.toString(), (EObject)settings, (EStructuralFeature)SettingPackage.Literals.SETTINGS__DECLARATIONS, settings.getDeclarations().indexOf(it));
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)settings.getDeclarations(), (Functions.Function1)_function).values(), (Functions.Function1)_function_1)).forEach(_function_2);
    }

    @Check
    public void checkTransitiveDeclarationsForDuplicates(Settings settings) {
        Consumer<Import> _function = imp -> {
            Functions.Function1 _function_1 = it -> it.getDeclarations();
            Iterable importedSettings = Queries.collect(this.loadSettings((Import)imp), (Functions.Function1)_function_1);
            Functions.Function1 _function_2 = d -> this.hasDuplicate(importedSettings, (Declaration)d);
            Consumer<Declaration> _function_3 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Declaration '");
                String _name = it.getName();
                _builder.append(_name);
                _builder.append("' is already defined in '");
                String _importURI = imp.getImportURI();
                _builder.append(_importURI);
                _builder.append("'. Remove either the import or the declaration.");
                String errorText = _builder.toString();
                this.error(errorText, (EObject)settings, (EStructuralFeature)SettingPackage.Literals.SETTINGS__DECLARATIONS, settings.getDeclarations().indexOf(it));
            };
            IterableExtensions.filter((Iterable)settings.getDeclarations(), (Functions.Function1)_function_2).forEach(_function_3);
        };
        settings.getImports().forEach(_function);
    }

    @Check
    public void checkTransitiveDeclarationForDuplicatesInImports(Settings settings) {
        HashMap importContents = new HashMap();
        Consumer<Import> _function = it -> {
            Functions.Function1 _function_1 = it_1 -> it_1.getDeclarations();
            importContents.put(it, IterableExtensions.toSet((Iterable)Queries.collect(this.loadSettings((Import)it), (Functions.Function1)_function_1)));
        };
        settings.getImports().forEach(_function);
        Functions.Function1 _function_1 = it -> it.getName();
        Functions.Function1 _function_2 = it -> {
            int _size = it.size();
            return _size > 1;
        };
        Consumer<Declaration> _function_3 = d -> {
            Functions.Function1 _function_4 = it -> ((Collection)it.getValue()).contains(d);
            Import imp = (Import)((Map.Entry)IterableExtensions.findFirst(importContents.entrySet(), (Functions.Function1)_function_4)).getKey();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Declaration '");
            String _name = d.getName();
            _builder.append(_name);
            _builder.append("' declared more than once in imports. Remove import or one of the '");
            String _name_1 = d.getName();
            _builder.append(_name_1);
            _builder.append("' declarations.");
            String errorText = _builder.toString();
            this.error(errorText, (EObject)imp, (EStructuralFeature)MachinePackage.Literals.IMPORT__IMPORT_URI);
        };
        Iterables.concat((Iterable)IterableExtensions.filter(IterableExtensions.groupBy((Iterable)Queries.unique((Iterable)Iterables.concat(importContents.values())), (Functions.Function1)_function_1).values(), (Functions.Function1)_function_2)).forEach(_function_3);
    }

    public boolean hasDuplicate(Iterable<Declaration> col, Declaration d) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            String _name_1 = d.getName();
            return Objects.equals(_name, _name_1);
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter(col, (Functions.Function1)_function));
        return !_isEmpty;
    }

    private HashSet<Settings> loadSettings(Import imp) {
        HashSet<Settings> result;
        block2: {
            result = new HashSet<Settings>();
            try {
                Set load = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)imp.load(), Settings.class));
                result.addAll(load);
                Functions.Function1 _function = it -> it.loadAll();
                Consumer<Settings> _function_1 = it -> result.add((Settings)it);
                Iterables.filter((Iterable)Queries.collect((Iterable)load, (Functions.Function1)_function), Settings.class).forEach(_function_1);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) break block2;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return result;
    }

    @Check
    public void checkCircularReference(DeclarationRefImpl ref) {
        boolean _hasCircularDependencies = ref.hasCircularDependencies((EObject)ref);
        if (_hasCircularDependencies) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Circular reference");
            this.error(_builder.toString(), (EObject)ref, (EStructuralFeature)ExpressionsPackage.Literals.DECLARATION_REF__DECLARATION);
        }
    }

    @Check
    public void checkPhysicalSettingsForResourceComplete(Settings settings) {
        Procedures.Procedure2 _function = (machineImport, index) -> {
            boolean _not;
            Functions.Function1 _function_3;
            Functions.Function1 _function_1 = it -> it.getResources();
            Functions.Function1 _function_2 = it -> it.getPeripherals();
            Set importedPeripherals = IterableExtensions.toSet((Iterable)Queries.collect((Iterable)Queries.collect((Iterable)Iterables.filter((Iterable)machineImport.load(), Machine.class), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
            Set incompletePeripherals = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)importedPeripherals, (Functions.Function1)(_function_3 = peripheral -> {
                boolean _isEmpty = IterableExtensions.isEmpty(this.incompleteResourceSettings((Peripheral)peripheral, settings));
                return !_isEmpty;
            })));
            boolean _isEmpty = incompletePeripherals.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("No settings specified for peripheral ");
                boolean _hasElements = false;
                for (Peripheral peripheral2 : incompletePeripherals) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    String _incompleteSettingsStr = this.incompleteSettingsStr(peripheral2, settings);
                    _builder.append(_incompleteSettingsStr);
                }
                String text = _builder.toString();
                this.warning(text, (EStructuralFeature)MachinePackage.Literals.IMPORT_CONTAINER__IMPORTS, (int)index);
            }
        };
        IterableExtensions.forEach((Iterable)settings.getImports(), (Procedures.Procedure2)_function);
    }

    public String incompleteSettingsStr(Peripheral peripheral, Settings settings) {
        Functions.Function1 _function = it -> {
            String _fqn = it.fqn();
            String _plus = "'" + _fqn;
            String _plus_1 = _plus + ".";
            String _name = peripheral.getName();
            String _plus_2 = _plus_1 + _name;
            return _plus_2 + "'";
        };
        return String.join((CharSequence)",", IterableExtensions.map(this.incompleteResourceSettings(peripheral, settings), (Functions.Function1)_function));
    }

    public Iterable<? extends IResource> incompleteResourceSettings(Peripheral peripheral, Settings settings) {
        Functions.Function1 _function = it -> {
            PhysicalSettings _physicalSettings = settings.getPhysicalSettings(it, peripheral);
            return _physicalSettings == null;
        };
        return IterableExtensions.filter(this.resourceOrItems(peripheral.getResource()), (Functions.Function1)_function);
    }

    public List<? extends IResource> resourceOrItems(Resource resource) {
        Object _xifexpression = null;
        boolean _isEmpty = resource.getItems().isEmpty();
        _xifexpression = _isEmpty ? CollectionLiterals.newArrayList((Object[])new Resource[]{resource}) : resource.getItems();
        return _xifexpression;
    }

    @Check
    public void checkMotionSettingsComplete(PhysicalSettings physicalSettings) {
        boolean _not;
        Set peripheralAxes = this.noSettings((Iterable)physicalSettings.getPeripheral().getType().getAxes(), (EMap)physicalSettings.getMotionSettings());
        boolean _isEmpty = peripheralAxes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No motion settings specified for axes ");
            boolean _hasElements = false;
            for (Axis axis : peripheralAxes) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _name = axis.getName();
                _builder.append(_name);
            }
            this.warning(_builder.toString(), (EStructuralFeature)SettingPackage.Literals.PHYSICAL_SETTINGS__MOTION_SETTINGS);
        }
    }

    @Check
    public void checkTimingSettingsComplete(PhysicalSettings physicalSettings) {
        boolean _not;
        Set peripheralActions = this.noSettings((Iterable)physicalSettings.getPeripheral().getType().getActions(), (EMap)physicalSettings.getTimingSettings());
        boolean _isEmpty = peripheralActions.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No timing settings specified for actions ");
            boolean _hasElements = false;
            for (ActionType action : peripheralActions) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _name = action.getName();
                _builder.append(_name);
            }
            this.warning(_builder.toString(), (EStructuralFeature)SettingPackage.Literals.PHYSICAL_SETTINGS__TIMING_SETTINGS);
        }
    }

    @Check
    public void checkProfileSettingsComplete(MotionSettings motionSettings) {
        boolean _not;
        Map.Entry _entry = motionSettings.getEntry();
        Peripheral peripheral = ((MotionSettingsMapEntryImpl)_entry).getSettings().getPeripheral();
        Set peripheralProfiles = this.noSettings((Iterable)peripheral.getProfiles(), (EMap)motionSettings.getProfileSettings());
        boolean _isEmpty = peripheralProfiles.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No settings specified for profiles ");
            boolean _hasElements = false;
            for (Profile profile : peripheralProfiles) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _name = profile.getName();
                _builder.append(_name);
            }
            this.warning(_builder.toString(), (EStructuralFeature)SettingPackage.Literals.MOTION_SETTINGS__PROFILE_SETTINGS);
        }
    }

    @Check
    public void checkTimingSettingsComplete(MotionSettings motionSettings) {
        boolean _not;
        Map.Entry _entry = motionSettings.getEntry();
        Axis axis = ((MotionSettingsMapEntryImpl)_entry).getKey();
        Map.Entry _entry_1 = motionSettings.getEntry();
        Peripheral peripheral = ((MotionSettingsMapEntryImpl)_entry_1).getSettings().getPeripheral();
        Functions.Function1 _function = it -> it.getPosition(axis);
        Set peripheralPositions = this.noSettings(ListExtensions.map((List)peripheral.getPositions(), (Functions.Function1)_function), motionSettings.getLocationSettings());
        boolean _isEmpty = peripheralPositions.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No settings specified for positions ");
            boolean _hasElements = false;
            for (Position position : peripheralPositions) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _name = position.getName();
                _builder.append(_name);
            }
            this.warning(_builder.toString(), (EStructuralFeature)SettingPackage.Literals.MOTION_SETTINGS__LOCATION_SETTINGS);
        }
    }

    @Check
    public void checkMotionProfileSettings(MotionProfileSettings mps) {
        try {
            boolean _not;
            MotionCalculatorExtension motionCalculator = MotionCalculatorExtension.getSelectedMotionCalculator();
            MotionProfile motionProfile = motionCalculator.getMotionProfile(mps.getMotionProfile());
            if (motionProfile == null) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Selected motion calculator ");
                String _name = motionCalculator.getName();
                _builder.append(_name);
                _builder.append(" does not support ");
                String _xifexpression = null;
                String _motionProfile = mps.getMotionProfile();
                boolean _tripleEquals = _motionProfile == null;
                _xifexpression = _tripleEquals ? "default " : "";
                _builder.append(_xifexpression);
                _builder.append("motion profile ");
                String _motionProfile_1 = mps.getMotionProfile();
                _builder.append(_motionProfile_1);
                this.error(_builder.toString(), (EStructuralFeature)SettingPackage.Literals.MOTION_PROFILE_SETTINGS__MOTION_PROFILE);
                return;
            }
            Functions.Function1 _function = it -> it.isRequired();
            Functions.Function1 _function_1 = it -> it.getKey();
            Set requiredParameterKeys = this.noSettings(IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)motionProfile.getParameters(), (Functions.Function1)_function), (Functions.Function1)_function_1), mps.getMotionArguments());
            boolean _isEmpty = requiredParameterKeys.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("No settings specified for required parameters ");
                boolean _hasElements = false;
                for (String parameter : requiredParameterKeys) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder_1.appendImmediate((Object)", ", "");
                    }
                    _builder_1.append(parameter);
                }
                this.error(_builder_1.toString(), (EStructuralFeature)SettingPackage.Literals.MOTION_PROFILE_SETTINGS__MOTION_ARGUMENTS);
            }
            Functions.Function1 _function_2 = it -> it.getKey();
            Iterable parameterKeys = IterableExtensions.map((Iterable)motionProfile.getParameters(), (Functions.Function1)_function_2);
            Procedures.Procedure2 _function_3 = (argument, index) -> {
                boolean _not_1;
                boolean _contains = IterableExtensions.contains((Iterable)parameterKeys, argument.getKey());
                boolean bl = _not_1 = !_contains;
                if (_not_1) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("Unknown parameter ");
                    String _key = (String)argument.getKey();
                    _builder_2.append(_key);
                    _builder_2.append("  for motion profile ");
                    String _motionProfile_2 = mps.getMotionProfile();
                    _builder_2.append(_motionProfile_2);
                    this.error(_builder_2.toString(), (EStructuralFeature)SettingPackage.Literals.MOTION_PROFILE_SETTINGS__MOTION_ARGUMENTS, (int)index);
                }
            };
            IterableExtensions.forEach((Iterable)mps.getMotionArguments(), (Procedures.Procedure2)_function_3);
        }
        catch (Throwable _t) {
            if (_t instanceof MotionException) {
                MotionException e = (MotionException)_t;
                this.error(e.getMessage(), null);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public <T> Set<T> noSettings(Iterable<T> col, EMap<T, ?> settings) {
        Functions.Function1 _function = k -> {
            Functions.Function1 _function_1 = it -> Objects.equals(it, k);
            Object _findFirst = IterableExtensions.findFirst((Iterable)settings.keySet(), (Functions.Function1)_function_1);
            return _findFirst == null;
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter(col, (Functions.Function1)_function));
    }
}

