/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
package org.eclipse.lsat.setting.teditor.services;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.common.services.TerminalsGrammarAccess;
import org.eclipse.xtext.service.AbstractElementFinder;
import org.eclipse.xtext.service.GrammarProvider;

@Singleton
public class SettingGrammarAccess extends AbstractElementFinder.AbstractGrammarElementFinder {
	
	public class SettingsElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.Settings");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cSettingsAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cImportsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cImportsImportParserRuleCall_1_0 = (RuleCall)cImportsAssignment_1.eContents().get(0);
		private final Assignment cDeclarationsAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cDeclarationsDeclarationParserRuleCall_2_0 = (RuleCall)cDeclarationsAssignment_2.eContents().get(0);
		private final Assignment cPhysicalSettingsAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cPhysicalSettingsPhysicalSettingsParserRuleCall_3_0 = (RuleCall)cPhysicalSettingsAssignment_3.eContents().get(0);
		
		//Settings returns Settings:
		//    {Settings}
		//    imports+=Import*
		//    declarations += Declaration*
		//    physicalSettings += PhysicalSettings*;
		@Override public ParserRule getRule() { return rule; }
		
		//{Settings}
		//imports+=Import*
		//declarations += Declaration*
		//physicalSettings += PhysicalSettings*
		public Group getGroup() { return cGroup; }
		
		//{Settings}
		public Action getSettingsAction_0() { return cSettingsAction_0; }
		
		//imports+=Import*
		public Assignment getImportsAssignment_1() { return cImportsAssignment_1; }
		
		//Import
		public RuleCall getImportsImportParserRuleCall_1_0() { return cImportsImportParserRuleCall_1_0; }
		
		//declarations += Declaration*
		public Assignment getDeclarationsAssignment_2() { return cDeclarationsAssignment_2; }
		
		//Declaration
		public RuleCall getDeclarationsDeclarationParserRuleCall_2_0() { return cDeclarationsDeclarationParserRuleCall_2_0; }
		
		//physicalSettings += PhysicalSettings*
		public Assignment getPhysicalSettingsAssignment_3() { return cPhysicalSettingsAssignment_3; }
		
		//PhysicalSettings
		public RuleCall getPhysicalSettingsPhysicalSettingsParserRuleCall_3_0() { return cPhysicalSettingsPhysicalSettingsParserRuleCall_3_0; }
	}
	public class ImportElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.Import");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cImportKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cImportURIAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cImportURISTRINGTerminalRuleCall_1_0 = (RuleCall)cImportURIAssignment_1.eContents().get(0);
		
		//Import returns machine::Import:
		//    "import" importURI=STRING;
		@Override public ParserRule getRule() { return rule; }
		
		//"import" importURI=STRING
		public Group getGroup() { return cGroup; }
		
		//"import"
		public Keyword getImportKeyword_0() { return cImportKeyword_0; }
		
		//importURI=STRING
		public Assignment getImportURIAssignment_1() { return cImportURIAssignment_1; }
		
		//STRING
		public RuleCall getImportURISTRINGTerminalRuleCall_1_0() { return cImportURISTRINGTerminalRuleCall_1_0; }
	}
	public class PhysicalSettingsElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.PhysicalSettings");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cPhysicalSettingsAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cResourceAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cResourceIResourceCrossReference_1_0 = (CrossReference)cResourceAssignment_1.eContents().get(0);
		private final RuleCall cResourceIResourceResourceQualifiedNameParserRuleCall_1_0_1 = (RuleCall)cResourceIResourceCrossReference_1_0.eContents().get(1);
		private final Keyword cFullStopKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cPeripheralAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final CrossReference cPeripheralPeripheralCrossReference_3_0 = (CrossReference)cPeripheralAssignment_3.eContents().get(0);
		private final RuleCall cPeripheralPeripheralIIDParserRuleCall_3_0_1 = (RuleCall)cPeripheralPeripheralCrossReference_3_0.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cTimingsKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_5_1 = (Keyword)cGroup_5.eContents().get(1);
		private final Assignment cTimingSettingsAssignment_5_2 = (Assignment)cGroup_5.eContents().get(2);
		private final RuleCall cTimingSettingsTimingSettingsMapEntryParserRuleCall_5_2_0 = (RuleCall)cTimingSettingsAssignment_5_2.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_5_3 = (Keyword)cGroup_5.eContents().get(3);
		private final Assignment cMotionSettingsAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cMotionSettingsMotionSettingsMapEntryParserRuleCall_6_0 = (RuleCall)cMotionSettingsAssignment_6.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_7 = (Keyword)cGroup.eContents().get(7);
		
		//PhysicalSettings returns PhysicalSettings:
		//    {PhysicalSettings}
		//    resource=[machine::IResource|ResourceQualifiedName] '.' (peripheral=[machine::Peripheral|IID]) '{'
		//        ('Timings' '{' timingSettings+=TimingSettingsMapEntry* '}' )?
		//        motionSettings+=MotionSettingsMapEntry*
		//    '}';
		@Override public ParserRule getRule() { return rule; }
		
		//{PhysicalSettings}
		//resource=[machine::IResource|ResourceQualifiedName] '.' (peripheral=[machine::Peripheral|IID]) '{'
		//    ('Timings' '{' timingSettings+=TimingSettingsMapEntry* '}' )?
		//    motionSettings+=MotionSettingsMapEntry*
		//'}'
		public Group getGroup() { return cGroup; }
		
		//{PhysicalSettings}
		public Action getPhysicalSettingsAction_0() { return cPhysicalSettingsAction_0; }
		
		//resource=[machine::IResource|ResourceQualifiedName]
		public Assignment getResourceAssignment_1() { return cResourceAssignment_1; }
		
		//[machine::IResource|ResourceQualifiedName]
		public CrossReference getResourceIResourceCrossReference_1_0() { return cResourceIResourceCrossReference_1_0; }
		
		//ResourceQualifiedName
		public RuleCall getResourceIResourceResourceQualifiedNameParserRuleCall_1_0_1() { return cResourceIResourceResourceQualifiedNameParserRuleCall_1_0_1; }
		
		//'.'
		public Keyword getFullStopKeyword_2() { return cFullStopKeyword_2; }
		
		//(peripheral=[machine::Peripheral|IID])
		public Assignment getPeripheralAssignment_3() { return cPeripheralAssignment_3; }
		
		//[machine::Peripheral|IID]
		public CrossReference getPeripheralPeripheralCrossReference_3_0() { return cPeripheralPeripheralCrossReference_3_0; }
		
		//IID
		public RuleCall getPeripheralPeripheralIIDParserRuleCall_3_0_1() { return cPeripheralPeripheralIIDParserRuleCall_3_0_1; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_4() { return cLeftCurlyBracketKeyword_4; }
		
		//('Timings' '{' timingSettings+=TimingSettingsMapEntry* '}' )?
		public Group getGroup_5() { return cGroup_5; }
		
		//'Timings'
		public Keyword getTimingsKeyword_5_0() { return cTimingsKeyword_5_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_5_1() { return cLeftCurlyBracketKeyword_5_1; }
		
		//timingSettings+=TimingSettingsMapEntry*
		public Assignment getTimingSettingsAssignment_5_2() { return cTimingSettingsAssignment_5_2; }
		
		//TimingSettingsMapEntry
		public RuleCall getTimingSettingsTimingSettingsMapEntryParserRuleCall_5_2_0() { return cTimingSettingsTimingSettingsMapEntryParserRuleCall_5_2_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_5_3() { return cRightCurlyBracketKeyword_5_3; }
		
		//motionSettings+=MotionSettingsMapEntry*
		public Assignment getMotionSettingsAssignment_6() { return cMotionSettingsAssignment_6; }
		
		//MotionSettingsMapEntry
		public RuleCall getMotionSettingsMotionSettingsMapEntryParserRuleCall_6_0() { return cMotionSettingsMotionSettingsMapEntryParserRuleCall_6_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_7() { return cRightCurlyBracketKeyword_7; }
	}
	public class MotionSettingsMapEntryElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.MotionSettingsMapEntry");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cMotionSettingsMapEntryAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cAxisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cKeyAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final CrossReference cKeyAxisCrossReference_2_0 = (CrossReference)cKeyAssignment_2.eContents().get(0);
		private final RuleCall cKeyAxisIDTerminalRuleCall_2_0_1 = (RuleCall)cKeyAxisCrossReference_2_0.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cValueAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cValueMotionSettingsParserRuleCall_4_0 = (RuleCall)cValueAssignment_4.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_5 = (Keyword)cGroup.eContents().get(5);
		
		//MotionSettingsMapEntry returns MotionSettingsMapEntry:
		//    {MotionSettingsMapEntry}
		//    'Axis' key=[machine::Axis|ID] '{' value=MotionSettings '}';
		@Override public ParserRule getRule() { return rule; }
		
		//{MotionSettingsMapEntry}
		//'Axis' key=[machine::Axis|ID] '{' value=MotionSettings '}'
		public Group getGroup() { return cGroup; }
		
		//{MotionSettingsMapEntry}
		public Action getMotionSettingsMapEntryAction_0() { return cMotionSettingsMapEntryAction_0; }
		
		//'Axis'
		public Keyword getAxisKeyword_1() { return cAxisKeyword_1; }
		
		//key=[machine::Axis|ID]
		public Assignment getKeyAssignment_2() { return cKeyAssignment_2; }
		
		//[machine::Axis|ID]
		public CrossReference getKeyAxisCrossReference_2_0() { return cKeyAxisCrossReference_2_0; }
		
		//ID
		public RuleCall getKeyAxisIDTerminalRuleCall_2_0_1() { return cKeyAxisIDTerminalRuleCall_2_0_1; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_3() { return cLeftCurlyBracketKeyword_3; }
		
		//value=MotionSettings
		public Assignment getValueAssignment_4() { return cValueAssignment_4; }
		
		//MotionSettings
		public RuleCall getValueMotionSettingsParserRuleCall_4_0() { return cValueMotionSettingsParserRuleCall_4_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_5() { return cRightCurlyBracketKeyword_5; }
	}
	public class MotionSettingsElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.MotionSettings");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cMotionSettingsAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cProfilesKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cProfileSettingsAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cProfileSettingsProfileSettingsMapEntryParserRuleCall_3_0 = (RuleCall)cProfileSettingsAssignment_3.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Keyword cPositionsKeyword_5_0 = (Keyword)cGroup_5.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_5_1 = (Keyword)cGroup_5.eContents().get(1);
		private final Assignment cLocationSettingsAssignment_5_2 = (Assignment)cGroup_5.eContents().get(2);
		private final RuleCall cLocationSettingsLocationSettingsMapEntryParserRuleCall_5_2_0 = (RuleCall)cLocationSettingsAssignment_5_2.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_5_3 = (Keyword)cGroup_5.eContents().get(3);
		private final Group cGroup_6 = (Group)cGroup.eContents().get(6);
		private final Keyword cDistancesKeyword_6_0 = (Keyword)cGroup_6.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_6_1 = (Keyword)cGroup_6.eContents().get(1);
		private final Assignment cDistanceSettingsAssignment_6_2 = (Assignment)cGroup_6.eContents().get(2);
		private final RuleCall cDistanceSettingsDistanceSettingsMapEntryParserRuleCall_6_2_0 = (RuleCall)cDistanceSettingsAssignment_6_2.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_6_3 = (Keyword)cGroup_6.eContents().get(3);
		
		//MotionSettings returns MotionSettings:
		//    {MotionSettings}
		//    'Profiles' '{' profileSettings+=ProfileSettingsMapEntry* '}'
		//    ('Positions' '{' locationSettings+=LocationSettingsMapEntry* '}')?
		//    ('Distances' '{' distanceSettings+=DistanceSettingsMapEntry* '}')?;
		@Override public ParserRule getRule() { return rule; }
		
		//{MotionSettings}
		//'Profiles' '{' profileSettings+=ProfileSettingsMapEntry* '}'
		//('Positions' '{' locationSettings+=LocationSettingsMapEntry* '}')?
		//('Distances' '{' distanceSettings+=DistanceSettingsMapEntry* '}')?
		public Group getGroup() { return cGroup; }
		
		//{MotionSettings}
		public Action getMotionSettingsAction_0() { return cMotionSettingsAction_0; }
		
		//'Profiles'
		public Keyword getProfilesKeyword_1() { return cProfilesKeyword_1; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_2() { return cLeftCurlyBracketKeyword_2; }
		
		//profileSettings+=ProfileSettingsMapEntry*
		public Assignment getProfileSettingsAssignment_3() { return cProfileSettingsAssignment_3; }
		
		//ProfileSettingsMapEntry
		public RuleCall getProfileSettingsProfileSettingsMapEntryParserRuleCall_3_0() { return cProfileSettingsProfileSettingsMapEntryParserRuleCall_3_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_4() { return cRightCurlyBracketKeyword_4; }
		
		//('Positions' '{' locationSettings+=LocationSettingsMapEntry* '}')?
		public Group getGroup_5() { return cGroup_5; }
		
		//'Positions'
		public Keyword getPositionsKeyword_5_0() { return cPositionsKeyword_5_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_5_1() { return cLeftCurlyBracketKeyword_5_1; }
		
		//locationSettings+=LocationSettingsMapEntry*
		public Assignment getLocationSettingsAssignment_5_2() { return cLocationSettingsAssignment_5_2; }
		
		//LocationSettingsMapEntry
		public RuleCall getLocationSettingsLocationSettingsMapEntryParserRuleCall_5_2_0() { return cLocationSettingsLocationSettingsMapEntryParserRuleCall_5_2_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_5_3() { return cRightCurlyBracketKeyword_5_3; }
		
		//('Distances' '{' distanceSettings+=DistanceSettingsMapEntry* '}')?
		public Group getGroup_6() { return cGroup_6; }
		
		//'Distances'
		public Keyword getDistancesKeyword_6_0() { return cDistancesKeyword_6_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_6_1() { return cLeftCurlyBracketKeyword_6_1; }
		
		//distanceSettings+=DistanceSettingsMapEntry*
		public Assignment getDistanceSettingsAssignment_6_2() { return cDistanceSettingsAssignment_6_2; }
		
		//DistanceSettingsMapEntry
		public RuleCall getDistanceSettingsDistanceSettingsMapEntryParserRuleCall_6_2_0() { return cDistanceSettingsDistanceSettingsMapEntryParserRuleCall_6_2_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_6_3() { return cRightCurlyBracketKeyword_6_3; }
	}
	public class ProfileSettingsMapEntryElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.ProfileSettingsMapEntry");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cKeyAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cKeyProfileCrossReference_0_0 = (CrossReference)cKeyAssignment_0.eContents().get(0);
		private final RuleCall cKeyProfileIDTerminalRuleCall_0_0_1 = (RuleCall)cKeyProfileCrossReference_0_0.eContents().get(1);
		private final Assignment cValueAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cValueMotionProfileSettingsParserRuleCall_1_0 = (RuleCall)cValueAssignment_1.eContents().get(0);
		
		//ProfileSettingsMapEntry returns ProfileSettingsMapEntry:
		//    key=[machine::Profile|ID] value=MotionProfileSettings;
		@Override public ParserRule getRule() { return rule; }
		
		//key=[machine::Profile|ID] value=MotionProfileSettings
		public Group getGroup() { return cGroup; }
		
		//key=[machine::Profile|ID]
		public Assignment getKeyAssignment_0() { return cKeyAssignment_0; }
		
		//[machine::Profile|ID]
		public CrossReference getKeyProfileCrossReference_0_0() { return cKeyProfileCrossReference_0_0; }
		
		//ID
		public RuleCall getKeyProfileIDTerminalRuleCall_0_0_1() { return cKeyProfileIDTerminalRuleCall_0_0_1; }
		
		//value=MotionProfileSettings
		public Assignment getValueAssignment_1() { return cValueAssignment_1; }
		
		//MotionProfileSettings
		public RuleCall getValueMotionProfileSettingsParserRuleCall_1_0() { return cValueMotionProfileSettingsParserRuleCall_1_0; }
	}
	public class LocationSettingsMapEntryElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.LocationSettingsMapEntry");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cKeyAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cKeyPositionCrossReference_0_0 = (CrossReference)cKeyAssignment_0.eContents().get(0);
		private final RuleCall cKeyPositionIDTerminalRuleCall_0_0_1 = (RuleCall)cKeyPositionCrossReference_0_0.eContents().get(1);
		private final Assignment cValueAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cValuePhysicalLocationParserRuleCall_1_0 = (RuleCall)cValueAssignment_1.eContents().get(0);
		
		//LocationSettingsMapEntry returns LocationSettingsMapEntry:
		//    key=[machine::Position|ID] value=PhysicalLocation;
		@Override public ParserRule getRule() { return rule; }
		
		//key=[machine::Position|ID] value=PhysicalLocation
		public Group getGroup() { return cGroup; }
		
		//key=[machine::Position|ID]
		public Assignment getKeyAssignment_0() { return cKeyAssignment_0; }
		
		//[machine::Position|ID]
		public CrossReference getKeyPositionCrossReference_0_0() { return cKeyPositionCrossReference_0_0; }
		
		//ID
		public RuleCall getKeyPositionIDTerminalRuleCall_0_0_1() { return cKeyPositionIDTerminalRuleCall_0_0_1; }
		
		//value=PhysicalLocation
		public Assignment getValueAssignment_1() { return cValueAssignment_1; }
		
		//PhysicalLocation
		public RuleCall getValuePhysicalLocationParserRuleCall_1_0() { return cValuePhysicalLocationParserRuleCall_1_0; }
	}
	public class DistanceSettingsMapEntryElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.DistanceSettingsMapEntry");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cKeyAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cKeyDistanceCrossReference_0_0 = (CrossReference)cKeyAssignment_0.eContents().get(0);
		private final RuleCall cKeyDistanceIDTerminalRuleCall_0_0_1 = (RuleCall)cKeyDistanceCrossReference_0_0.eContents().get(1);
		private final Keyword cEqualsSignKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cValueAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cValueExpressionParserRuleCall_2_0 = (RuleCall)cValueAssignment_2.eContents().get(0);
		
		//DistanceSettingsMapEntry returns DistanceSettingsMapEntry:
		//    key=[machine::Distance|ID] '=' value=Expression;
		@Override public ParserRule getRule() { return rule; }
		
		//key=[machine::Distance|ID] '=' value=Expression
		public Group getGroup() { return cGroup; }
		
		//key=[machine::Distance|ID]
		public Assignment getKeyAssignment_0() { return cKeyAssignment_0; }
		
		//[machine::Distance|ID]
		public CrossReference getKeyDistanceCrossReference_0_0() { return cKeyDistanceCrossReference_0_0; }
		
		//ID
		public RuleCall getKeyDistanceIDTerminalRuleCall_0_0_1() { return cKeyDistanceIDTerminalRuleCall_0_0_1; }
		
		//'='
		public Keyword getEqualsSignKeyword_1() { return cEqualsSignKeyword_1; }
		
		//value=Expression
		public Assignment getValueAssignment_2() { return cValueAssignment_2; }
		
		//Expression
		public RuleCall getValueExpressionParserRuleCall_2_0() { return cValueExpressionParserRuleCall_2_0; }
	}
	public class TimingSettingsMapEntryElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.TimingSettingsMapEntry");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cKeyAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cKeyActionTypeCrossReference_0_0 = (CrossReference)cKeyAssignment_0.eContents().get(0);
		private final RuleCall cKeyActionTypeIDTerminalRuleCall_0_0_1 = (RuleCall)cKeyActionTypeCrossReference_0_0.eContents().get(1);
		private final Keyword cEqualsSignKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cValueAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cValueTimingParserRuleCall_2_0 = (RuleCall)cValueAssignment_2.eContents().get(0);
		
		//TimingSettingsMapEntry returns TimingSettingsMapEntry:
		//    key = [machine::ActionType|ID] '=' value = Timing;
		@Override public ParserRule getRule() { return rule; }
		
		//key = [machine::ActionType|ID] '=' value = Timing
		public Group getGroup() { return cGroup; }
		
		//key = [machine::ActionType|ID]
		public Assignment getKeyAssignment_0() { return cKeyAssignment_0; }
		
		//[machine::ActionType|ID]
		public CrossReference getKeyActionTypeCrossReference_0_0() { return cKeyActionTypeCrossReference_0_0; }
		
		//ID
		public RuleCall getKeyActionTypeIDTerminalRuleCall_0_0_1() { return cKeyActionTypeIDTerminalRuleCall_0_0_1; }
		
		//'='
		public Keyword getEqualsSignKeyword_1() { return cEqualsSignKeyword_1; }
		
		//value = Timing
		public Assignment getValueAssignment_2() { return cValueAssignment_2; }
		
		//Timing
		public RuleCall getValueTimingParserRuleCall_2_0() { return cValueTimingParserRuleCall_2_0; }
	}
	public class MotionProfileSettingsElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.MotionProfileSettings");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cMotionProfileSettingsAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cMotionProfileAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cMotionProfileIDTerminalRuleCall_1_0 = (RuleCall)cMotionProfileAssignment_1.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Assignment cMotionArgumentsAssignment_3_0 = (Assignment)cGroup_3.eContents().get(0);
		private final RuleCall cMotionArgumentsMotionArgumentsMapEntryParserRuleCall_3_0_0 = (RuleCall)cMotionArgumentsAssignment_3_0.eContents().get(0);
		private final Group cGroup_3_1 = (Group)cGroup_3.eContents().get(1);
		private final Keyword cCommaKeyword_3_1_0 = (Keyword)cGroup_3_1.eContents().get(0);
		private final Assignment cMotionArgumentsAssignment_3_1_1 = (Assignment)cGroup_3_1.eContents().get(1);
		private final RuleCall cMotionArgumentsMotionArgumentsMapEntryParserRuleCall_3_1_1_0 = (RuleCall)cMotionArgumentsAssignment_3_1_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//MotionProfileSettings returns MotionProfileSettings:
		//    {MotionProfileSettings}
		//    motionProfile=ID? '(' (motionArguments+= MotionArgumentsMapEntry (',' motionArguments+= MotionArgumentsMapEntry)*)? ')';
		@Override public ParserRule getRule() { return rule; }
		
		//{MotionProfileSettings}
		//motionProfile=ID? '(' (motionArguments+= MotionArgumentsMapEntry (',' motionArguments+= MotionArgumentsMapEntry)*)? ')'
		public Group getGroup() { return cGroup; }
		
		//{MotionProfileSettings}
		public Action getMotionProfileSettingsAction_0() { return cMotionProfileSettingsAction_0; }
		
		//motionProfile=ID?
		public Assignment getMotionProfileAssignment_1() { return cMotionProfileAssignment_1; }
		
		//ID
		public RuleCall getMotionProfileIDTerminalRuleCall_1_0() { return cMotionProfileIDTerminalRuleCall_1_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_2() { return cLeftParenthesisKeyword_2; }
		
		//(motionArguments+= MotionArgumentsMapEntry (',' motionArguments+= MotionArgumentsMapEntry)*)?
		public Group getGroup_3() { return cGroup_3; }
		
		//motionArguments+= MotionArgumentsMapEntry
		public Assignment getMotionArgumentsAssignment_3_0() { return cMotionArgumentsAssignment_3_0; }
		
		//MotionArgumentsMapEntry
		public RuleCall getMotionArgumentsMotionArgumentsMapEntryParserRuleCall_3_0_0() { return cMotionArgumentsMotionArgumentsMapEntryParserRuleCall_3_0_0; }
		
		//(',' motionArguments+= MotionArgumentsMapEntry)*
		public Group getGroup_3_1() { return cGroup_3_1; }
		
		//','
		public Keyword getCommaKeyword_3_1_0() { return cCommaKeyword_3_1_0; }
		
		//motionArguments+= MotionArgumentsMapEntry
		public Assignment getMotionArgumentsAssignment_3_1_1() { return cMotionArgumentsAssignment_3_1_1; }
		
		//MotionArgumentsMapEntry
		public RuleCall getMotionArgumentsMotionArgumentsMapEntryParserRuleCall_3_1_1_0() { return cMotionArgumentsMotionArgumentsMapEntryParserRuleCall_3_1_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_4() { return cRightParenthesisKeyword_4; }
	}
	public class MotionArgumentsMapEntryElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.MotionArgumentsMapEntry");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cKeyAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cKeyIDTerminalRuleCall_0_0 = (RuleCall)cKeyAssignment_0.eContents().get(0);
		private final Keyword cEqualsSignKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cValueAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cValueExpressionParserRuleCall_2_0 = (RuleCall)cValueAssignment_2.eContents().get(0);
		
		//MotionArgumentsMapEntry returns MotionArgumentsMapEntry:
		//    key=ID '=' value=Expression;
		@Override public ParserRule getRule() { return rule; }
		
		//key=ID '=' value=Expression
		public Group getGroup() { return cGroup; }
		
		//key=ID
		public Assignment getKeyAssignment_0() { return cKeyAssignment_0; }
		
		//ID
		public RuleCall getKeyIDTerminalRuleCall_0_0() { return cKeyIDTerminalRuleCall_0_0; }
		
		//'='
		public Keyword getEqualsSignKeyword_1() { return cEqualsSignKeyword_1; }
		
		//value=Expression
		public Assignment getValueAssignment_2() { return cValueAssignment_2; }
		
		//Expression
		public RuleCall getValueExpressionParserRuleCall_2_0() { return cValueExpressionParserRuleCall_2_0; }
	}
	public class PhysicalLocationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.PhysicalLocation");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cAlternatives.eContents().get(0);
		private final Keyword cEqualsSignKeyword_0_0 = (Keyword)cGroup_0.eContents().get(0);
		private final Assignment cDefaultExpAssignment_0_1 = (Assignment)cGroup_0.eContents().get(1);
		private final RuleCall cDefaultExpExpressionParserRuleCall_0_1_0 = (RuleCall)cDefaultExpAssignment_0_1.eContents().get(0);
		private final Group cGroup_1 = (Group)cAlternatives.eContents().get(1);
		private final Keyword cLeftParenthesisKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Group cGroup_1_1 = (Group)cGroup_1.eContents().get(1);
		private final Keyword cMinKeyword_1_1_0 = (Keyword)cGroup_1_1.eContents().get(0);
		private final Keyword cEqualsSignKeyword_1_1_1 = (Keyword)cGroup_1_1.eContents().get(1);
		private final Assignment cMinExpAssignment_1_1_2 = (Assignment)cGroup_1_1.eContents().get(2);
		private final RuleCall cMinExpExpressionParserRuleCall_1_1_2_0 = (RuleCall)cMinExpAssignment_1_1_2.eContents().get(0);
		private final Keyword cCommaKeyword_1_1_3 = (Keyword)cGroup_1_1.eContents().get(3);
		private final Group cGroup_1_2 = (Group)cGroup_1.eContents().get(2);
		private final Keyword cMaxKeyword_1_2_0 = (Keyword)cGroup_1_2.eContents().get(0);
		private final Keyword cEqualsSignKeyword_1_2_1 = (Keyword)cGroup_1_2.eContents().get(1);
		private final Assignment cMaxExpAssignment_1_2_2 = (Assignment)cGroup_1_2.eContents().get(2);
		private final RuleCall cMaxExpExpressionParserRuleCall_1_2_2_0 = (RuleCall)cMaxExpAssignment_1_2_2.eContents().get(0);
		private final Keyword cCommaKeyword_1_2_3 = (Keyword)cGroup_1_2.eContents().get(3);
		private final Keyword cDefaultKeyword_1_3 = (Keyword)cGroup_1.eContents().get(3);
		private final Keyword cEqualsSignKeyword_1_4 = (Keyword)cGroup_1.eContents().get(4);
		private final Assignment cDefaultExpAssignment_1_5 = (Assignment)cGroup_1.eContents().get(5);
		private final RuleCall cDefaultExpExpressionParserRuleCall_1_5_0 = (RuleCall)cDefaultExpAssignment_1_5.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_1_6 = (Keyword)cGroup_1.eContents().get(6);
		
		//PhysicalLocation returns PhysicalLocation:
		//    ('=' defaultExp=Expression) | '(' ('min' '=' minExp=Expression ',')? ('max' '=' maxExp=Expression ',')? 'default' '=' defaultExp=Expression ')';
		@Override public ParserRule getRule() { return rule; }
		
		//('=' defaultExp=Expression) | '(' ('min' '=' minExp=Expression ',')? ('max' '=' maxExp=Expression ',')? 'default' '=' defaultExp=Expression ')'
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//('=' defaultExp=Expression)
		public Group getGroup_0() { return cGroup_0; }
		
		//'='
		public Keyword getEqualsSignKeyword_0_0() { return cEqualsSignKeyword_0_0; }
		
		//defaultExp=Expression
		public Assignment getDefaultExpAssignment_0_1() { return cDefaultExpAssignment_0_1; }
		
		//Expression
		public RuleCall getDefaultExpExpressionParserRuleCall_0_1_0() { return cDefaultExpExpressionParserRuleCall_0_1_0; }
		
		//'(' ('min' '=' minExp=Expression ',')? ('max' '=' maxExp=Expression ',')? 'default' '=' defaultExp=Expression ')'
		public Group getGroup_1() { return cGroup_1; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1_0() { return cLeftParenthesisKeyword_1_0; }
		
		//('min' '=' minExp=Expression ',')?
		public Group getGroup_1_1() { return cGroup_1_1; }
		
		//'min'
		public Keyword getMinKeyword_1_1_0() { return cMinKeyword_1_1_0; }
		
		//'='
		public Keyword getEqualsSignKeyword_1_1_1() { return cEqualsSignKeyword_1_1_1; }
		
		//minExp=Expression
		public Assignment getMinExpAssignment_1_1_2() { return cMinExpAssignment_1_1_2; }
		
		//Expression
		public RuleCall getMinExpExpressionParserRuleCall_1_1_2_0() { return cMinExpExpressionParserRuleCall_1_1_2_0; }
		
		//','
		public Keyword getCommaKeyword_1_1_3() { return cCommaKeyword_1_1_3; }
		
		//('max' '=' maxExp=Expression ',')?
		public Group getGroup_1_2() { return cGroup_1_2; }
		
		//'max'
		public Keyword getMaxKeyword_1_2_0() { return cMaxKeyword_1_2_0; }
		
		//'='
		public Keyword getEqualsSignKeyword_1_2_1() { return cEqualsSignKeyword_1_2_1; }
		
		//maxExp=Expression
		public Assignment getMaxExpAssignment_1_2_2() { return cMaxExpAssignment_1_2_2; }
		
		//Expression
		public RuleCall getMaxExpExpressionParserRuleCall_1_2_2_0() { return cMaxExpExpressionParserRuleCall_1_2_2_0; }
		
		//','
		public Keyword getCommaKeyword_1_2_3() { return cCommaKeyword_1_2_3; }
		
		//'default'
		public Keyword getDefaultKeyword_1_3() { return cDefaultKeyword_1_3; }
		
		//'='
		public Keyword getEqualsSignKeyword_1_4() { return cEqualsSignKeyword_1_4; }
		
		//defaultExp=Expression
		public Assignment getDefaultExpAssignment_1_5() { return cDefaultExpAssignment_1_5; }
		
		//Expression
		public RuleCall getDefaultExpExpressionParserRuleCall_1_5_0() { return cDefaultExpExpressionParserRuleCall_1_5_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_1_6() { return cRightParenthesisKeyword_1_6; }
	}
	public class TimingElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.Timing");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cFixedValueParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cArrayParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cTriangularDistributionParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cPertDistributionParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		private final RuleCall cNormalDistributionParserRuleCall_4 = (RuleCall)cAlternatives.eContents().get(4);
		private final RuleCall cEnumeratedDistributionParserRuleCall_5 = (RuleCall)cAlternatives.eContents().get(5);
		
		//// timing part
		//Timing returns timing::Timing:
		//    FixedValue|Array|TriangularDistribution|PertDistribution|NormalDistribution|EnumeratedDistribution;
		@Override public ParserRule getRule() { return rule; }
		
		//FixedValue|Array|TriangularDistribution|PertDistribution|NormalDistribution|EnumeratedDistribution
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//FixedValue
		public RuleCall getFixedValueParserRuleCall_0() { return cFixedValueParserRuleCall_0; }
		
		//Array
		public RuleCall getArrayParserRuleCall_1() { return cArrayParserRuleCall_1; }
		
		//TriangularDistribution
		public RuleCall getTriangularDistributionParserRuleCall_2() { return cTriangularDistributionParserRuleCall_2; }
		
		//PertDistribution
		public RuleCall getPertDistributionParserRuleCall_3() { return cPertDistributionParserRuleCall_3; }
		
		//NormalDistribution
		public RuleCall getNormalDistributionParserRuleCall_4() { return cNormalDistributionParserRuleCall_4; }
		
		//EnumeratedDistribution
		public RuleCall getEnumeratedDistributionParserRuleCall_5() { return cEnumeratedDistributionParserRuleCall_5; }
	}
	public class FixedValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.FixedValue");
		private final Assignment cValueExpAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cValueExpExpressionParserRuleCall_0 = (RuleCall)cValueExpAssignment.eContents().get(0);
		
		//FixedValue returns timing::FixedValue:
		//    valueExp=Expression;
		@Override public ParserRule getRule() { return rule; }
		
		//valueExp=Expression
		public Assignment getValueExpAssignment() { return cValueExpAssignment; }
		
		//Expression
		public RuleCall getValueExpExpressionParserRuleCall_0() { return cValueExpExpressionParserRuleCall_0; }
	}
	public class ArrayElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.Array");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cArrayKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cValuesExpAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cValuesExpExpressionParserRuleCall_2_0 = (RuleCall)cValuesExpAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cCommaKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cValuesExpAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cValuesExpExpressionParserRuleCall_3_1_0 = (RuleCall)cValuesExpAssignment_3_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//Array returns timing::Array:
		//    'Array' '(' valuesExp+=Expression ( "," valuesExp+=Expression)* ')';
		@Override public ParserRule getRule() { return rule; }
		
		//'Array' '(' valuesExp+=Expression ( "," valuesExp+=Expression)* ')'
		public Group getGroup() { return cGroup; }
		
		//'Array'
		public Keyword getArrayKeyword_0() { return cArrayKeyword_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//valuesExp+=Expression
		public Assignment getValuesExpAssignment_2() { return cValuesExpAssignment_2; }
		
		//Expression
		public RuleCall getValuesExpExpressionParserRuleCall_2_0() { return cValuesExpExpressionParserRuleCall_2_0; }
		
		//( "," valuesExp+=Expression)*
		public Group getGroup_3() { return cGroup_3; }
		
		//","
		public Keyword getCommaKeyword_3_0() { return cCommaKeyword_3_0; }
		
		//valuesExp+=Expression
		public Assignment getValuesExpAssignment_3_1() { return cValuesExpAssignment_3_1; }
		
		//Expression
		public RuleCall getValuesExpExpressionParserRuleCall_3_1_0() { return cValuesExpExpressionParserRuleCall_3_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_4() { return cRightParenthesisKeyword_4; }
	}
	public class TriangularDistributionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.TriangularDistribution");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cTriangularKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cMinKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Keyword cEqualsSignKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cMinExpAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cMinExpExpressionParserRuleCall_4_0 = (RuleCall)cMinExpAssignment_4.eContents().get(0);
		private final Keyword cCommaKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Keyword cMaxKeyword_6 = (Keyword)cGroup.eContents().get(6);
		private final Keyword cEqualsSignKeyword_7 = (Keyword)cGroup.eContents().get(7);
		private final Assignment cMaxExpAssignment_8 = (Assignment)cGroup.eContents().get(8);
		private final RuleCall cMaxExpExpressionParserRuleCall_8_0 = (RuleCall)cMaxExpAssignment_8.eContents().get(0);
		private final Keyword cCommaKeyword_9 = (Keyword)cGroup.eContents().get(9);
		private final Keyword cModeKeyword_10 = (Keyword)cGroup.eContents().get(10);
		private final Keyword cEqualsSignKeyword_11 = (Keyword)cGroup.eContents().get(11);
		private final Assignment cModeExpAssignment_12 = (Assignment)cGroup.eContents().get(12);
		private final RuleCall cModeExpExpressionParserRuleCall_12_0 = (RuleCall)cModeExpAssignment_12.eContents().get(0);
		private final Group cGroup_13 = (Group)cGroup.eContents().get(13);
		private final Keyword cCommaKeyword_13_0 = (Keyword)cGroup_13.eContents().get(0);
		private final Keyword cDefaultKeyword_13_1 = (Keyword)cGroup_13.eContents().get(1);
		private final Keyword cEqualsSignKeyword_13_2 = (Keyword)cGroup_13.eContents().get(2);
		private final Assignment cDefaultExpAssignment_13_3 = (Assignment)cGroup_13.eContents().get(3);
		private final RuleCall cDefaultExpExpressionParserRuleCall_13_3_0 = (RuleCall)cDefaultExpAssignment_13_3.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_14 = (Keyword)cGroup.eContents().get(14);
		
		//TriangularDistribution returns timing::TriangularDistribution:
		//    'Triangular' '(' 'min' '=' minExp=Expression ',' 'max' '=' maxExp=Expression ',' 'mode' '=' modeExp=Expression (',' 'default' '=' defaultExp=Expression)? ')';
		@Override public ParserRule getRule() { return rule; }
		
		//'Triangular' '(' 'min' '=' minExp=Expression ',' 'max' '=' maxExp=Expression ',' 'mode' '=' modeExp=Expression (',' 'default' '=' defaultExp=Expression)? ')'
		public Group getGroup() { return cGroup; }
		
		//'Triangular'
		public Keyword getTriangularKeyword_0() { return cTriangularKeyword_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//'min'
		public Keyword getMinKeyword_2() { return cMinKeyword_2; }
		
		//'='
		public Keyword getEqualsSignKeyword_3() { return cEqualsSignKeyword_3; }
		
		//minExp=Expression
		public Assignment getMinExpAssignment_4() { return cMinExpAssignment_4; }
		
		//Expression
		public RuleCall getMinExpExpressionParserRuleCall_4_0() { return cMinExpExpressionParserRuleCall_4_0; }
		
		//','
		public Keyword getCommaKeyword_5() { return cCommaKeyword_5; }
		
		//'max'
		public Keyword getMaxKeyword_6() { return cMaxKeyword_6; }
		
		//'='
		public Keyword getEqualsSignKeyword_7() { return cEqualsSignKeyword_7; }
		
		//maxExp=Expression
		public Assignment getMaxExpAssignment_8() { return cMaxExpAssignment_8; }
		
		//Expression
		public RuleCall getMaxExpExpressionParserRuleCall_8_0() { return cMaxExpExpressionParserRuleCall_8_0; }
		
		//','
		public Keyword getCommaKeyword_9() { return cCommaKeyword_9; }
		
		//'mode'
		public Keyword getModeKeyword_10() { return cModeKeyword_10; }
		
		//'='
		public Keyword getEqualsSignKeyword_11() { return cEqualsSignKeyword_11; }
		
		//modeExp=Expression
		public Assignment getModeExpAssignment_12() { return cModeExpAssignment_12; }
		
		//Expression
		public RuleCall getModeExpExpressionParserRuleCall_12_0() { return cModeExpExpressionParserRuleCall_12_0; }
		
		//(',' 'default' '=' defaultExp=Expression)?
		public Group getGroup_13() { return cGroup_13; }
		
		//','
		public Keyword getCommaKeyword_13_0() { return cCommaKeyword_13_0; }
		
		//'default'
		public Keyword getDefaultKeyword_13_1() { return cDefaultKeyword_13_1; }
		
		//'='
		public Keyword getEqualsSignKeyword_13_2() { return cEqualsSignKeyword_13_2; }
		
		//defaultExp=Expression
		public Assignment getDefaultExpAssignment_13_3() { return cDefaultExpAssignment_13_3; }
		
		//Expression
		public RuleCall getDefaultExpExpressionParserRuleCall_13_3_0() { return cDefaultExpExpressionParserRuleCall_13_3_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_14() { return cRightParenthesisKeyword_14; }
	}
	public class PertDistributionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.PertDistribution");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cPertKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cMinKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Keyword cEqualsSignKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cMinExpAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cMinExpExpressionParserRuleCall_4_0 = (RuleCall)cMinExpAssignment_4.eContents().get(0);
		private final Keyword cCommaKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Keyword cMaxKeyword_6 = (Keyword)cGroup.eContents().get(6);
		private final Keyword cEqualsSignKeyword_7 = (Keyword)cGroup.eContents().get(7);
		private final Assignment cMaxExpAssignment_8 = (Assignment)cGroup.eContents().get(8);
		private final RuleCall cMaxExpExpressionParserRuleCall_8_0 = (RuleCall)cMaxExpAssignment_8.eContents().get(0);
		private final Keyword cCommaKeyword_9 = (Keyword)cGroup.eContents().get(9);
		private final Keyword cModeKeyword_10 = (Keyword)cGroup.eContents().get(10);
		private final Keyword cEqualsSignKeyword_11 = (Keyword)cGroup.eContents().get(11);
		private final Assignment cModeExpAssignment_12 = (Assignment)cGroup.eContents().get(12);
		private final RuleCall cModeExpExpressionParserRuleCall_12_0 = (RuleCall)cModeExpAssignment_12.eContents().get(0);
		private final Keyword cCommaKeyword_13 = (Keyword)cGroup.eContents().get(13);
		private final Keyword cGammaKeyword_14 = (Keyword)cGroup.eContents().get(14);
		private final Keyword cEqualsSignKeyword_15 = (Keyword)cGroup.eContents().get(15);
		private final Assignment cGammaExpAssignment_16 = (Assignment)cGroup.eContents().get(16);
		private final RuleCall cGammaExpExpressionParserRuleCall_16_0 = (RuleCall)cGammaExpAssignment_16.eContents().get(0);
		private final Group cGroup_17 = (Group)cGroup.eContents().get(17);
		private final Keyword cCommaKeyword_17_0 = (Keyword)cGroup_17.eContents().get(0);
		private final Keyword cDefaultKeyword_17_1 = (Keyword)cGroup_17.eContents().get(1);
		private final Keyword cEqualsSignKeyword_17_2 = (Keyword)cGroup_17.eContents().get(2);
		private final Assignment cDefaultExpAssignment_17_3 = (Assignment)cGroup_17.eContents().get(3);
		private final RuleCall cDefaultExpExpressionParserRuleCall_17_3_0 = (RuleCall)cDefaultExpAssignment_17_3.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_18 = (Keyword)cGroup.eContents().get(18);
		
		//PertDistribution returns timing::PertDistribution:
		//    'Pert' '(' 'min' '=' minExp=Expression ',' 'max' '=' maxExp=Expression ',' 'mode' '=' modeExp=Expression ',' 'gamma' '=' gammaExp=Expression (',' 'default' '=' defaultExp=Expression)? ')';
		@Override public ParserRule getRule() { return rule; }
		
		//'Pert' '(' 'min' '=' minExp=Expression ',' 'max' '=' maxExp=Expression ',' 'mode' '=' modeExp=Expression ',' 'gamma' '=' gammaExp=Expression (',' 'default' '=' defaultExp=Expression)? ')'
		public Group getGroup() { return cGroup; }
		
		//'Pert'
		public Keyword getPertKeyword_0() { return cPertKeyword_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//'min'
		public Keyword getMinKeyword_2() { return cMinKeyword_2; }
		
		//'='
		public Keyword getEqualsSignKeyword_3() { return cEqualsSignKeyword_3; }
		
		//minExp=Expression
		public Assignment getMinExpAssignment_4() { return cMinExpAssignment_4; }
		
		//Expression
		public RuleCall getMinExpExpressionParserRuleCall_4_0() { return cMinExpExpressionParserRuleCall_4_0; }
		
		//','
		public Keyword getCommaKeyword_5() { return cCommaKeyword_5; }
		
		//'max'
		public Keyword getMaxKeyword_6() { return cMaxKeyword_6; }
		
		//'='
		public Keyword getEqualsSignKeyword_7() { return cEqualsSignKeyword_7; }
		
		//maxExp=Expression
		public Assignment getMaxExpAssignment_8() { return cMaxExpAssignment_8; }
		
		//Expression
		public RuleCall getMaxExpExpressionParserRuleCall_8_0() { return cMaxExpExpressionParserRuleCall_8_0; }
		
		//','
		public Keyword getCommaKeyword_9() { return cCommaKeyword_9; }
		
		//'mode'
		public Keyword getModeKeyword_10() { return cModeKeyword_10; }
		
		//'='
		public Keyword getEqualsSignKeyword_11() { return cEqualsSignKeyword_11; }
		
		//modeExp=Expression
		public Assignment getModeExpAssignment_12() { return cModeExpAssignment_12; }
		
		//Expression
		public RuleCall getModeExpExpressionParserRuleCall_12_0() { return cModeExpExpressionParserRuleCall_12_0; }
		
		//','
		public Keyword getCommaKeyword_13() { return cCommaKeyword_13; }
		
		//'gamma'
		public Keyword getGammaKeyword_14() { return cGammaKeyword_14; }
		
		//'='
		public Keyword getEqualsSignKeyword_15() { return cEqualsSignKeyword_15; }
		
		//gammaExp=Expression
		public Assignment getGammaExpAssignment_16() { return cGammaExpAssignment_16; }
		
		//Expression
		public RuleCall getGammaExpExpressionParserRuleCall_16_0() { return cGammaExpExpressionParserRuleCall_16_0; }
		
		//(',' 'default' '=' defaultExp=Expression)?
		public Group getGroup_17() { return cGroup_17; }
		
		//','
		public Keyword getCommaKeyword_17_0() { return cCommaKeyword_17_0; }
		
		//'default'
		public Keyword getDefaultKeyword_17_1() { return cDefaultKeyword_17_1; }
		
		//'='
		public Keyword getEqualsSignKeyword_17_2() { return cEqualsSignKeyword_17_2; }
		
		//defaultExp=Expression
		public Assignment getDefaultExpAssignment_17_3() { return cDefaultExpAssignment_17_3; }
		
		//Expression
		public RuleCall getDefaultExpExpressionParserRuleCall_17_3_0() { return cDefaultExpExpressionParserRuleCall_17_3_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_18() { return cRightParenthesisKeyword_18; }
	}
	public class NormalDistributionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.NormalDistribution");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cNormalKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Keyword cMeanKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Keyword cEqualsSignKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cMeanExpAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cMeanExpExpressionParserRuleCall_4_0 = (RuleCall)cMeanExpAssignment_4.eContents().get(0);
		private final Keyword cCommaKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Keyword cSdKeyword_6 = (Keyword)cGroup.eContents().get(6);
		private final Keyword cEqualsSignKeyword_7 = (Keyword)cGroup.eContents().get(7);
		private final Assignment cSdExpAssignment_8 = (Assignment)cGroup.eContents().get(8);
		private final RuleCall cSdExpExpressionParserRuleCall_8_0 = (RuleCall)cSdExpAssignment_8.eContents().get(0);
		private final Group cGroup_9 = (Group)cGroup.eContents().get(9);
		private final Keyword cCommaKeyword_9_0 = (Keyword)cGroup_9.eContents().get(0);
		private final Keyword cDefaultKeyword_9_1 = (Keyword)cGroup_9.eContents().get(1);
		private final Keyword cEqualsSignKeyword_9_2 = (Keyword)cGroup_9.eContents().get(2);
		private final Assignment cDefaultExpAssignment_9_3 = (Assignment)cGroup_9.eContents().get(3);
		private final RuleCall cDefaultExpExpressionParserRuleCall_9_3_0 = (RuleCall)cDefaultExpAssignment_9_3.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_10 = (Keyword)cGroup.eContents().get(10);
		
		//NormalDistribution returns timing::NormalDistribution:
		//    'Normal' '(' 'mean' '=' meanExp=Expression ',' 'sd' '=' sdExp=Expression (',' 'default' '=' defaultExp=Expression)? ')';
		@Override public ParserRule getRule() { return rule; }
		
		//'Normal' '(' 'mean' '=' meanExp=Expression ',' 'sd' '=' sdExp=Expression (',' 'default' '=' defaultExp=Expression)? ')'
		public Group getGroup() { return cGroup; }
		
		//'Normal'
		public Keyword getNormalKeyword_0() { return cNormalKeyword_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//'mean'
		public Keyword getMeanKeyword_2() { return cMeanKeyword_2; }
		
		//'='
		public Keyword getEqualsSignKeyword_3() { return cEqualsSignKeyword_3; }
		
		//meanExp=Expression
		public Assignment getMeanExpAssignment_4() { return cMeanExpAssignment_4; }
		
		//Expression
		public RuleCall getMeanExpExpressionParserRuleCall_4_0() { return cMeanExpExpressionParserRuleCall_4_0; }
		
		//','
		public Keyword getCommaKeyword_5() { return cCommaKeyword_5; }
		
		//'sd'
		public Keyword getSdKeyword_6() { return cSdKeyword_6; }
		
		//'='
		public Keyword getEqualsSignKeyword_7() { return cEqualsSignKeyword_7; }
		
		//sdExp=Expression
		public Assignment getSdExpAssignment_8() { return cSdExpAssignment_8; }
		
		//Expression
		public RuleCall getSdExpExpressionParserRuleCall_8_0() { return cSdExpExpressionParserRuleCall_8_0; }
		
		//(',' 'default' '=' defaultExp=Expression)?
		public Group getGroup_9() { return cGroup_9; }
		
		//','
		public Keyword getCommaKeyword_9_0() { return cCommaKeyword_9_0; }
		
		//'default'
		public Keyword getDefaultKeyword_9_1() { return cDefaultKeyword_9_1; }
		
		//'='
		public Keyword getEqualsSignKeyword_9_2() { return cEqualsSignKeyword_9_2; }
		
		//defaultExp=Expression
		public Assignment getDefaultExpAssignment_9_3() { return cDefaultExpAssignment_9_3; }
		
		//Expression
		public RuleCall getDefaultExpExpressionParserRuleCall_9_3_0() { return cDefaultExpExpressionParserRuleCall_9_3_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_10() { return cRightParenthesisKeyword_10; }
	}
	public class EnumeratedDistributionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.EnumeratedDistribution");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cEnumeratedKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cValuesExpAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cValuesExpExpressionParserRuleCall_2_0 = (RuleCall)cValuesExpAssignment_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cCommaKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cValuesExpAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cValuesExpExpressionParserRuleCall_3_1_0 = (RuleCall)cValuesExpAssignment_3_1.eContents().get(0);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Keyword cCommaKeyword_4_0 = (Keyword)cGroup_4.eContents().get(0);
		private final Keyword cDefaultKeyword_4_1 = (Keyword)cGroup_4.eContents().get(1);
		private final Keyword cEqualsSignKeyword_4_2 = (Keyword)cGroup_4.eContents().get(2);
		private final Assignment cDefaultExpAssignment_4_3 = (Assignment)cGroup_4.eContents().get(3);
		private final RuleCall cDefaultExpExpressionParserRuleCall_4_3_0 = (RuleCall)cDefaultExpAssignment_4_3.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_5 = (Keyword)cGroup.eContents().get(5);
		
		//EnumeratedDistribution returns timing::EnumeratedDistribution:
		//    'Enumerated' '(' valuesExp+=Expression ( "," valuesExp+=Expression)* (',' 'default' '=' defaultExp=Expression)? ')';
		@Override public ParserRule getRule() { return rule; }
		
		//'Enumerated' '(' valuesExp+=Expression ( "," valuesExp+=Expression)* (',' 'default' '=' defaultExp=Expression)? ')'
		public Group getGroup() { return cGroup; }
		
		//'Enumerated'
		public Keyword getEnumeratedKeyword_0() { return cEnumeratedKeyword_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//valuesExp+=Expression
		public Assignment getValuesExpAssignment_2() { return cValuesExpAssignment_2; }
		
		//Expression
		public RuleCall getValuesExpExpressionParserRuleCall_2_0() { return cValuesExpExpressionParserRuleCall_2_0; }
		
		//( "," valuesExp+=Expression)*
		public Group getGroup_3() { return cGroup_3; }
		
		//","
		public Keyword getCommaKeyword_3_0() { return cCommaKeyword_3_0; }
		
		//valuesExp+=Expression
		public Assignment getValuesExpAssignment_3_1() { return cValuesExpAssignment_3_1; }
		
		//Expression
		public RuleCall getValuesExpExpressionParserRuleCall_3_1_0() { return cValuesExpExpressionParserRuleCall_3_1_0; }
		
		//(',' 'default' '=' defaultExp=Expression)?
		public Group getGroup_4() { return cGroup_4; }
		
		//','
		public Keyword getCommaKeyword_4_0() { return cCommaKeyword_4_0; }
		
		//'default'
		public Keyword getDefaultKeyword_4_1() { return cDefaultKeyword_4_1; }
		
		//'='
		public Keyword getEqualsSignKeyword_4_2() { return cEqualsSignKeyword_4_2; }
		
		//defaultExp=Expression
		public Assignment getDefaultExpAssignment_4_3() { return cDefaultExpAssignment_4_3; }
		
		//Expression
		public RuleCall getDefaultExpExpressionParserRuleCall_4_3_0() { return cDefaultExpExpressionParserRuleCall_4_3_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_5() { return cRightParenthesisKeyword_5; }
	}
	public class DeclarationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.Declaration");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cDeclarationAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cValKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cNameAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cNameIDTerminalRuleCall_2_0 = (RuleCall)cNameAssignment_2.eContents().get(0);
		private final Keyword cEqualsSignKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cExpressionAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cExpressionExpressionParserRuleCall_4_0 = (RuleCall)cExpressionAssignment_4.eContents().get(0);
		
		//// expressions part
		//Declaration returns expressions::Declaration:
		//    {expressions::Declaration}
		//    'val' name=ID '=' expression=Expression
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//{expressions::Declaration}
		//'val' name=ID '=' expression=Expression
		public Group getGroup() { return cGroup; }
		
		//{expressions::Declaration}
		public Action getDeclarationAction_0() { return cDeclarationAction_0; }
		
		//'val'
		public Keyword getValKeyword_1() { return cValKeyword_1; }
		
		//name=ID
		public Assignment getNameAssignment_2() { return cNameAssignment_2; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_2_0() { return cNameIDTerminalRuleCall_2_0; }
		
		//'='
		public Keyword getEqualsSignKeyword_3() { return cEqualsSignKeyword_3; }
		
		//expression=Expression
		public Assignment getExpressionAssignment_4() { return cExpressionAssignment_4; }
		
		//Expression
		public RuleCall getExpressionExpressionParserRuleCall_4_0() { return cExpressionExpressionParserRuleCall_4_0; }
	}
	public class ExpressionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.Expression");
		private final RuleCall cPlusOrMinusParserRuleCall = (RuleCall)rule.eContents().get(1);
		
		//Expression returns expressions::Expression:
		//    PlusOrMinus
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//PlusOrMinus
		public RuleCall getPlusOrMinusParserRuleCall() { return cPlusOrMinusParserRuleCall; }
	}
	public class PlusOrMinusElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.PlusOrMinus");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cMulOrDivParserRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Alternatives cAlternatives_1_0 = (Alternatives)cGroup_1.eContents().get(0);
		private final Group cGroup_1_0_0 = (Group)cAlternatives_1_0.eContents().get(0);
		private final Action cAddLeftAction_1_0_0_0 = (Action)cGroup_1_0_0.eContents().get(0);
		private final Keyword cPlusSignKeyword_1_0_0_1 = (Keyword)cGroup_1_0_0.eContents().get(1);
		private final Group cGroup_1_0_1 = (Group)cAlternatives_1_0.eContents().get(1);
		private final Action cSubtractLeftAction_1_0_1_0 = (Action)cGroup_1_0_1.eContents().get(0);
		private final Keyword cHyphenMinusKeyword_1_0_1_1 = (Keyword)cGroup_1_0_1.eContents().get(1);
		private final Assignment cRightAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cRightMulOrDivParserRuleCall_1_1_0 = (RuleCall)cRightAssignment_1_1.eContents().get(0);
		
		//PlusOrMinus returns expressions::Expression:
		//    MulOrDiv (
		//        ({expressions::Add.left=current} '+' | {expressions::Subtract.left=current} '-')
		//        right=MulOrDiv
		//    )*
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//MulOrDiv (
		//    ({expressions::Add.left=current} '+' | {expressions::Subtract.left=current} '-')
		//    right=MulOrDiv
		//)*
		public Group getGroup() { return cGroup; }
		
		//MulOrDiv
		public RuleCall getMulOrDivParserRuleCall_0() { return cMulOrDivParserRuleCall_0; }
		
		//(
		//       ({expressions::Add.left=current} '+' | {expressions::Subtract.left=current} '-')
		//       right=MulOrDiv
		//   )*
		public Group getGroup_1() { return cGroup_1; }
		
		//({expressions::Add.left=current} '+' | {expressions::Subtract.left=current} '-')
		public Alternatives getAlternatives_1_0() { return cAlternatives_1_0; }
		
		//{expressions::Add.left=current} '+'
		public Group getGroup_1_0_0() { return cGroup_1_0_0; }
		
		//{expressions::Add.left=current}
		public Action getAddLeftAction_1_0_0_0() { return cAddLeftAction_1_0_0_0; }
		
		//'+'
		public Keyword getPlusSignKeyword_1_0_0_1() { return cPlusSignKeyword_1_0_0_1; }
		
		//{expressions::Subtract.left=current} '-'
		public Group getGroup_1_0_1() { return cGroup_1_0_1; }
		
		//{expressions::Subtract.left=current}
		public Action getSubtractLeftAction_1_0_1_0() { return cSubtractLeftAction_1_0_1_0; }
		
		//'-'
		public Keyword getHyphenMinusKeyword_1_0_1_1() { return cHyphenMinusKeyword_1_0_1_1; }
		
		//right=MulOrDiv
		public Assignment getRightAssignment_1_1() { return cRightAssignment_1_1; }
		
		//MulOrDiv
		public RuleCall getRightMulOrDivParserRuleCall_1_1_0() { return cRightMulOrDivParserRuleCall_1_1_0; }
	}
	public class MulOrDivElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.MulOrDiv");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cPrimaryParserRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Alternatives cAlternatives_1_0 = (Alternatives)cGroup_1.eContents().get(0);
		private final Group cGroup_1_0_0 = (Group)cAlternatives_1_0.eContents().get(0);
		private final Action cMultiplyLeftAction_1_0_0_0 = (Action)cGroup_1_0_0.eContents().get(0);
		private final Keyword cAsteriskKeyword_1_0_0_1 = (Keyword)cGroup_1_0_0.eContents().get(1);
		private final Group cGroup_1_0_1 = (Group)cAlternatives_1_0.eContents().get(1);
		private final Action cDivideLeftAction_1_0_1_0 = (Action)cGroup_1_0_1.eContents().get(0);
		private final Keyword cSolidusKeyword_1_0_1_1 = (Keyword)cGroup_1_0_1.eContents().get(1);
		private final Assignment cRightAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cRightPrimaryParserRuleCall_1_1_0 = (RuleCall)cRightAssignment_1_1.eContents().get(0);
		
		//MulOrDiv returns expressions::Expression:
		//    Primary (
		//        ({expressions::Multiply.left=current} '*' | {expressions::Divide.left=current} '/')
		//        right=Primary
		//    )*
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//Primary (
		//    ({expressions::Multiply.left=current} '*' | {expressions::Divide.left=current} '/')
		//    right=Primary
		//)*
		public Group getGroup() { return cGroup; }
		
		//Primary
		public RuleCall getPrimaryParserRuleCall_0() { return cPrimaryParserRuleCall_0; }
		
		//(
		//       ({expressions::Multiply.left=current} '*' | {expressions::Divide.left=current} '/')
		//       right=Primary
		//   )*
		public Group getGroup_1() { return cGroup_1; }
		
		//({expressions::Multiply.left=current} '*' | {expressions::Divide.left=current} '/')
		public Alternatives getAlternatives_1_0() { return cAlternatives_1_0; }
		
		//{expressions::Multiply.left=current} '*'
		public Group getGroup_1_0_0() { return cGroup_1_0_0; }
		
		//{expressions::Multiply.left=current}
		public Action getMultiplyLeftAction_1_0_0_0() { return cMultiplyLeftAction_1_0_0_0; }
		
		//'*'
		public Keyword getAsteriskKeyword_1_0_0_1() { return cAsteriskKeyword_1_0_0_1; }
		
		//{expressions::Divide.left=current} '/'
		public Group getGroup_1_0_1() { return cGroup_1_0_1; }
		
		//{expressions::Divide.left=current}
		public Action getDivideLeftAction_1_0_1_0() { return cDivideLeftAction_1_0_1_0; }
		
		//'/'
		public Keyword getSolidusKeyword_1_0_1_1() { return cSolidusKeyword_1_0_1_1; }
		
		//right=Primary
		public Assignment getRightAssignment_1_1() { return cRightAssignment_1_1; }
		
		//Primary
		public RuleCall getRightPrimaryParserRuleCall_1_1_0() { return cRightPrimaryParserRuleCall_1_1_0; }
	}
	public class PrimaryElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.Primary");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cAlternatives.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_0_0 = (Keyword)cGroup_0.eContents().get(0);
		private final RuleCall cExpressionParserRuleCall_0_1 = (RuleCall)cGroup_0.eContents().get(1);
		private final Keyword cRightParenthesisKeyword_0_2 = (Keyword)cGroup_0.eContents().get(2);
		private final RuleCall cAtomicParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//Primary returns expressions::Expression:
		//    '(' Expression ')' |  Atomic
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//'(' Expression ')' |  Atomic
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//'(' Expression ')'
		public Group getGroup_0() { return cGroup_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_0_0() { return cLeftParenthesisKeyword_0_0; }
		
		//Expression
		public RuleCall getExpressionParserRuleCall_0_1() { return cExpressionParserRuleCall_0_1; }
		
		//')'
		public Keyword getRightParenthesisKeyword_0_2() { return cRightParenthesisKeyword_0_2; }
		
		//Atomic
		public RuleCall getAtomicParserRuleCall_1() { return cAtomicParserRuleCall_1; }
	}
	public class AtomicElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.Atomic");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cAlternatives.eContents().get(0);
		private final Action cBigDecimalConstantAction_0_0 = (Action)cGroup_0.eContents().get(0);
		private final Assignment cValueAssignment_0_1 = (Assignment)cGroup_0.eContents().get(1);
		private final RuleCall cValueEBigDecimalParserRuleCall_0_1_0 = (RuleCall)cValueAssignment_0_1.eContents().get(0);
		private final Group cGroup_1 = (Group)cAlternatives.eContents().get(1);
		private final Action cDeclarationRefAction_1_0 = (Action)cGroup_1.eContents().get(0);
		private final Assignment cDeclarationAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final CrossReference cDeclarationDeclarationCrossReference_1_1_0 = (CrossReference)cDeclarationAssignment_1_1.eContents().get(0);
		private final RuleCall cDeclarationDeclarationIDTerminalRuleCall_1_1_0_1 = (RuleCall)cDeclarationDeclarationCrossReference_1_1_0.eContents().get(1);
		
		//Atomic returns expressions::Expression:
		//    {expressions::BigDecimalConstant} value=EBigDecimal |
		//    {expressions::DeclarationRef} declaration=[expressions::Declaration]
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//{expressions::BigDecimalConstant} value=EBigDecimal |
		//{expressions::DeclarationRef} declaration=[expressions::Declaration]
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//{expressions::BigDecimalConstant} value=EBigDecimal
		public Group getGroup_0() { return cGroup_0; }
		
		//{expressions::BigDecimalConstant}
		public Action getBigDecimalConstantAction_0_0() { return cBigDecimalConstantAction_0_0; }
		
		//value=EBigDecimal
		public Assignment getValueAssignment_0_1() { return cValueAssignment_0_1; }
		
		//EBigDecimal
		public RuleCall getValueEBigDecimalParserRuleCall_0_1_0() { return cValueEBigDecimalParserRuleCall_0_1_0; }
		
		//{expressions::DeclarationRef} declaration=[expressions::Declaration]
		public Group getGroup_1() { return cGroup_1; }
		
		//{expressions::DeclarationRef}
		public Action getDeclarationRefAction_1_0() { return cDeclarationRefAction_1_0; }
		
		//declaration=[expressions::Declaration]
		public Assignment getDeclarationAssignment_1_1() { return cDeclarationAssignment_1_1; }
		
		//[expressions::Declaration]
		public CrossReference getDeclarationDeclarationCrossReference_1_1_0() { return cDeclarationDeclarationCrossReference_1_1_0; }
		
		//ID
		public RuleCall getDeclarationDeclarationIDTerminalRuleCall_1_1_0_1() { return cDeclarationDeclarationIDTerminalRuleCall_1_1_0_1; }
	}
	public class EBigDecimalElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.EBigDecimal");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cHyphenMinusKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final RuleCall cINTTerminalRuleCall_1 = (RuleCall)cGroup.eContents().get(1);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cFullStopKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final RuleCall cINTTerminalRuleCall_2_1 = (RuleCall)cGroup_2.eContents().get(1);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Alternatives cAlternatives_3_0 = (Alternatives)cGroup_3.eContents().get(0);
		private final Keyword cEKeyword_3_0_0 = (Keyword)cAlternatives_3_0.eContents().get(0);
		private final Keyword cEKeyword_3_0_1 = (Keyword)cAlternatives_3_0.eContents().get(1);
		private final Keyword cHyphenMinusKeyword_3_1 = (Keyword)cGroup_3.eContents().get(1);
		private final RuleCall cINTTerminalRuleCall_3_2 = (RuleCall)cGroup_3.eContents().get(2);
		
		//// general part
		//EBigDecimal returns ecore::EBigDecimal:
		//    '-'? INT ('.' INT)? (('E'|'e') '-'? INT)?;
		@Override public ParserRule getRule() { return rule; }
		
		//'-'? INT ('.' INT)? (('E'|'e') '-'? INT)?
		public Group getGroup() { return cGroup; }
		
		//'-'?
		public Keyword getHyphenMinusKeyword_0() { return cHyphenMinusKeyword_0; }
		
		//INT
		public RuleCall getINTTerminalRuleCall_1() { return cINTTerminalRuleCall_1; }
		
		//('.' INT)?
		public Group getGroup_2() { return cGroup_2; }
		
		//'.'
		public Keyword getFullStopKeyword_2_0() { return cFullStopKeyword_2_0; }
		
		//INT
		public RuleCall getINTTerminalRuleCall_2_1() { return cINTTerminalRuleCall_2_1; }
		
		//(('E'|'e') '-'? INT)?
		public Group getGroup_3() { return cGroup_3; }
		
		//('E'|'e')
		public Alternatives getAlternatives_3_0() { return cAlternatives_3_0; }
		
		//'E'
		public Keyword getEKeyword_3_0_0() { return cEKeyword_3_0_0; }
		
		//'e'
		public Keyword getEKeyword_3_0_1() { return cEKeyword_3_0_1; }
		
		//'-'?
		public Keyword getHyphenMinusKeyword_3_1() { return cHyphenMinusKeyword_3_1; }
		
		//INT
		public RuleCall getINTTerminalRuleCall_3_2() { return cINTTerminalRuleCall_3_2; }
	}
	public class IIDElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.IID");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cINTTerminalRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cIDTerminalRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//IID returns ecore::EString:
		//    INT | ID
		//;
		@Override public ParserRule getRule() { return rule; }
		
		//INT | ID
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//INT
		public RuleCall getINTTerminalRuleCall_0() { return cINTTerminalRuleCall_0; }
		
		//ID
		public RuleCall getIDTerminalRuleCall_1() { return cIDTerminalRuleCall_1; }
	}
	public class ResourceQualifiedNameElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.lsat.setting.teditor.Setting.ResourceQualifiedName");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final RuleCall cIIDParserRuleCall_0 = (RuleCall)cGroup.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cFullStopKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final RuleCall cIIDParserRuleCall_1_1 = (RuleCall)cGroup_1.eContents().get(1);
		
		//ResourceQualifiedName:
		//   IID ('.' IID)?;
		@Override public ParserRule getRule() { return rule; }
		
		//IID ('.' IID)?
		public Group getGroup() { return cGroup; }
		
		//IID
		public RuleCall getIIDParserRuleCall_0() { return cIIDParserRuleCall_0; }
		
		//('.' IID)?
		public Group getGroup_1() { return cGroup_1; }
		
		//'.'
		public Keyword getFullStopKeyword_1_0() { return cFullStopKeyword_1_0; }
		
		//IID
		public RuleCall getIIDParserRuleCall_1_1() { return cIIDParserRuleCall_1_1; }
	}
	
	
	private final SettingsElements pSettings;
	private final ImportElements pImport;
	private final PhysicalSettingsElements pPhysicalSettings;
	private final MotionSettingsMapEntryElements pMotionSettingsMapEntry;
	private final MotionSettingsElements pMotionSettings;
	private final ProfileSettingsMapEntryElements pProfileSettingsMapEntry;
	private final LocationSettingsMapEntryElements pLocationSettingsMapEntry;
	private final DistanceSettingsMapEntryElements pDistanceSettingsMapEntry;
	private final TimingSettingsMapEntryElements pTimingSettingsMapEntry;
	private final MotionProfileSettingsElements pMotionProfileSettings;
	private final MotionArgumentsMapEntryElements pMotionArgumentsMapEntry;
	private final PhysicalLocationElements pPhysicalLocation;
	private final TimingElements pTiming;
	private final FixedValueElements pFixedValue;
	private final ArrayElements pArray;
	private final TriangularDistributionElements pTriangularDistribution;
	private final PertDistributionElements pPertDistribution;
	private final NormalDistributionElements pNormalDistribution;
	private final EnumeratedDistributionElements pEnumeratedDistribution;
	private final DeclarationElements pDeclaration;
	private final ExpressionElements pExpression;
	private final PlusOrMinusElements pPlusOrMinus;
	private final MulOrDivElements pMulOrDiv;
	private final PrimaryElements pPrimary;
	private final AtomicElements pAtomic;
	private final EBigDecimalElements pEBigDecimal;
	private final IIDElements pIID;
	private final ResourceQualifiedNameElements pResourceQualifiedName;
	
	private final Grammar grammar;
	
	private final TerminalsGrammarAccess gaTerminals;

	@Inject
	public SettingGrammarAccess(GrammarProvider grammarProvider,
			TerminalsGrammarAccess gaTerminals) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.gaTerminals = gaTerminals;
		this.pSettings = new SettingsElements();
		this.pImport = new ImportElements();
		this.pPhysicalSettings = new PhysicalSettingsElements();
		this.pMotionSettingsMapEntry = new MotionSettingsMapEntryElements();
		this.pMotionSettings = new MotionSettingsElements();
		this.pProfileSettingsMapEntry = new ProfileSettingsMapEntryElements();
		this.pLocationSettingsMapEntry = new LocationSettingsMapEntryElements();
		this.pDistanceSettingsMapEntry = new DistanceSettingsMapEntryElements();
		this.pTimingSettingsMapEntry = new TimingSettingsMapEntryElements();
		this.pMotionProfileSettings = new MotionProfileSettingsElements();
		this.pMotionArgumentsMapEntry = new MotionArgumentsMapEntryElements();
		this.pPhysicalLocation = new PhysicalLocationElements();
		this.pTiming = new TimingElements();
		this.pFixedValue = new FixedValueElements();
		this.pArray = new ArrayElements();
		this.pTriangularDistribution = new TriangularDistributionElements();
		this.pPertDistribution = new PertDistributionElements();
		this.pNormalDistribution = new NormalDistributionElements();
		this.pEnumeratedDistribution = new EnumeratedDistributionElements();
		this.pDeclaration = new DeclarationElements();
		this.pExpression = new ExpressionElements();
		this.pPlusOrMinus = new PlusOrMinusElements();
		this.pMulOrDiv = new MulOrDivElements();
		this.pPrimary = new PrimaryElements();
		this.pAtomic = new AtomicElements();
		this.pEBigDecimal = new EBigDecimalElements();
		this.pIID = new IIDElements();
		this.pResourceQualifiedName = new ResourceQualifiedNameElements();
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.lsat.setting.teditor.Setting".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	@Override
	public Grammar getGrammar() {
		return grammar;
	}
	
	
	public TerminalsGrammarAccess getTerminalsGrammarAccess() {
		return gaTerminals;
	}

	
	//Settings returns Settings:
	//    {Settings}
	//    imports+=Import*
	//    declarations += Declaration*
	//    physicalSettings += PhysicalSettings*;
	public SettingsElements getSettingsAccess() {
		return pSettings;
	}
	
	public ParserRule getSettingsRule() {
		return getSettingsAccess().getRule();
	}
	
	//Import returns machine::Import:
	//    "import" importURI=STRING;
	public ImportElements getImportAccess() {
		return pImport;
	}
	
	public ParserRule getImportRule() {
		return getImportAccess().getRule();
	}
	
	//PhysicalSettings returns PhysicalSettings:
	//    {PhysicalSettings}
	//    resource=[machine::IResource|ResourceQualifiedName] '.' (peripheral=[machine::Peripheral|IID]) '{'
	//        ('Timings' '{' timingSettings+=TimingSettingsMapEntry* '}' )?
	//        motionSettings+=MotionSettingsMapEntry*
	//    '}';
	public PhysicalSettingsElements getPhysicalSettingsAccess() {
		return pPhysicalSettings;
	}
	
	public ParserRule getPhysicalSettingsRule() {
		return getPhysicalSettingsAccess().getRule();
	}
	
	//MotionSettingsMapEntry returns MotionSettingsMapEntry:
	//    {MotionSettingsMapEntry}
	//    'Axis' key=[machine::Axis|ID] '{' value=MotionSettings '}';
	public MotionSettingsMapEntryElements getMotionSettingsMapEntryAccess() {
		return pMotionSettingsMapEntry;
	}
	
	public ParserRule getMotionSettingsMapEntryRule() {
		return getMotionSettingsMapEntryAccess().getRule();
	}
	
	//MotionSettings returns MotionSettings:
	//    {MotionSettings}
	//    'Profiles' '{' profileSettings+=ProfileSettingsMapEntry* '}'
	//    ('Positions' '{' locationSettings+=LocationSettingsMapEntry* '}')?
	//    ('Distances' '{' distanceSettings+=DistanceSettingsMapEntry* '}')?;
	public MotionSettingsElements getMotionSettingsAccess() {
		return pMotionSettings;
	}
	
	public ParserRule getMotionSettingsRule() {
		return getMotionSettingsAccess().getRule();
	}
	
	//ProfileSettingsMapEntry returns ProfileSettingsMapEntry:
	//    key=[machine::Profile|ID] value=MotionProfileSettings;
	public ProfileSettingsMapEntryElements getProfileSettingsMapEntryAccess() {
		return pProfileSettingsMapEntry;
	}
	
	public ParserRule getProfileSettingsMapEntryRule() {
		return getProfileSettingsMapEntryAccess().getRule();
	}
	
	//LocationSettingsMapEntry returns LocationSettingsMapEntry:
	//    key=[machine::Position|ID] value=PhysicalLocation;
	public LocationSettingsMapEntryElements getLocationSettingsMapEntryAccess() {
		return pLocationSettingsMapEntry;
	}
	
	public ParserRule getLocationSettingsMapEntryRule() {
		return getLocationSettingsMapEntryAccess().getRule();
	}
	
	//DistanceSettingsMapEntry returns DistanceSettingsMapEntry:
	//    key=[machine::Distance|ID] '=' value=Expression;
	public DistanceSettingsMapEntryElements getDistanceSettingsMapEntryAccess() {
		return pDistanceSettingsMapEntry;
	}
	
	public ParserRule getDistanceSettingsMapEntryRule() {
		return getDistanceSettingsMapEntryAccess().getRule();
	}
	
	//TimingSettingsMapEntry returns TimingSettingsMapEntry:
	//    key = [machine::ActionType|ID] '=' value = Timing;
	public TimingSettingsMapEntryElements getTimingSettingsMapEntryAccess() {
		return pTimingSettingsMapEntry;
	}
	
	public ParserRule getTimingSettingsMapEntryRule() {
		return getTimingSettingsMapEntryAccess().getRule();
	}
	
	//MotionProfileSettings returns MotionProfileSettings:
	//    {MotionProfileSettings}
	//    motionProfile=ID? '(' (motionArguments+= MotionArgumentsMapEntry (',' motionArguments+= MotionArgumentsMapEntry)*)? ')';
	public MotionProfileSettingsElements getMotionProfileSettingsAccess() {
		return pMotionProfileSettings;
	}
	
	public ParserRule getMotionProfileSettingsRule() {
		return getMotionProfileSettingsAccess().getRule();
	}
	
	//MotionArgumentsMapEntry returns MotionArgumentsMapEntry:
	//    key=ID '=' value=Expression;
	public MotionArgumentsMapEntryElements getMotionArgumentsMapEntryAccess() {
		return pMotionArgumentsMapEntry;
	}
	
	public ParserRule getMotionArgumentsMapEntryRule() {
		return getMotionArgumentsMapEntryAccess().getRule();
	}
	
	//PhysicalLocation returns PhysicalLocation:
	//    ('=' defaultExp=Expression) | '(' ('min' '=' minExp=Expression ',')? ('max' '=' maxExp=Expression ',')? 'default' '=' defaultExp=Expression ')';
	public PhysicalLocationElements getPhysicalLocationAccess() {
		return pPhysicalLocation;
	}
	
	public ParserRule getPhysicalLocationRule() {
		return getPhysicalLocationAccess().getRule();
	}
	
	//// timing part
	//Timing returns timing::Timing:
	//    FixedValue|Array|TriangularDistribution|PertDistribution|NormalDistribution|EnumeratedDistribution;
	public TimingElements getTimingAccess() {
		return pTiming;
	}
	
	public ParserRule getTimingRule() {
		return getTimingAccess().getRule();
	}
	
	//FixedValue returns timing::FixedValue:
	//    valueExp=Expression;
	public FixedValueElements getFixedValueAccess() {
		return pFixedValue;
	}
	
	public ParserRule getFixedValueRule() {
		return getFixedValueAccess().getRule();
	}
	
	//Array returns timing::Array:
	//    'Array' '(' valuesExp+=Expression ( "," valuesExp+=Expression)* ')';
	public ArrayElements getArrayAccess() {
		return pArray;
	}
	
	public ParserRule getArrayRule() {
		return getArrayAccess().getRule();
	}
	
	//TriangularDistribution returns timing::TriangularDistribution:
	//    'Triangular' '(' 'min' '=' minExp=Expression ',' 'max' '=' maxExp=Expression ',' 'mode' '=' modeExp=Expression (',' 'default' '=' defaultExp=Expression)? ')';
	public TriangularDistributionElements getTriangularDistributionAccess() {
		return pTriangularDistribution;
	}
	
	public ParserRule getTriangularDistributionRule() {
		return getTriangularDistributionAccess().getRule();
	}
	
	//PertDistribution returns timing::PertDistribution:
	//    'Pert' '(' 'min' '=' minExp=Expression ',' 'max' '=' maxExp=Expression ',' 'mode' '=' modeExp=Expression ',' 'gamma' '=' gammaExp=Expression (',' 'default' '=' defaultExp=Expression)? ')';
	public PertDistributionElements getPertDistributionAccess() {
		return pPertDistribution;
	}
	
	public ParserRule getPertDistributionRule() {
		return getPertDistributionAccess().getRule();
	}
	
	//NormalDistribution returns timing::NormalDistribution:
	//    'Normal' '(' 'mean' '=' meanExp=Expression ',' 'sd' '=' sdExp=Expression (',' 'default' '=' defaultExp=Expression)? ')';
	public NormalDistributionElements getNormalDistributionAccess() {
		return pNormalDistribution;
	}
	
	public ParserRule getNormalDistributionRule() {
		return getNormalDistributionAccess().getRule();
	}
	
	//EnumeratedDistribution returns timing::EnumeratedDistribution:
	//    'Enumerated' '(' valuesExp+=Expression ( "," valuesExp+=Expression)* (',' 'default' '=' defaultExp=Expression)? ')';
	public EnumeratedDistributionElements getEnumeratedDistributionAccess() {
		return pEnumeratedDistribution;
	}
	
	public ParserRule getEnumeratedDistributionRule() {
		return getEnumeratedDistributionAccess().getRule();
	}
	
	//// expressions part
	//Declaration returns expressions::Declaration:
	//    {expressions::Declaration}
	//    'val' name=ID '=' expression=Expression
	//;
	public DeclarationElements getDeclarationAccess() {
		return pDeclaration;
	}
	
	public ParserRule getDeclarationRule() {
		return getDeclarationAccess().getRule();
	}
	
	//Expression returns expressions::Expression:
	//    PlusOrMinus
	//;
	public ExpressionElements getExpressionAccess() {
		return pExpression;
	}
	
	public ParserRule getExpressionRule() {
		return getExpressionAccess().getRule();
	}
	
	//PlusOrMinus returns expressions::Expression:
	//    MulOrDiv (
	//        ({expressions::Add.left=current} '+' | {expressions::Subtract.left=current} '-')
	//        right=MulOrDiv
	//    )*
	//;
	public PlusOrMinusElements getPlusOrMinusAccess() {
		return pPlusOrMinus;
	}
	
	public ParserRule getPlusOrMinusRule() {
		return getPlusOrMinusAccess().getRule();
	}
	
	//MulOrDiv returns expressions::Expression:
	//    Primary (
	//        ({expressions::Multiply.left=current} '*' | {expressions::Divide.left=current} '/')
	//        right=Primary
	//    )*
	//;
	public MulOrDivElements getMulOrDivAccess() {
		return pMulOrDiv;
	}
	
	public ParserRule getMulOrDivRule() {
		return getMulOrDivAccess().getRule();
	}
	
	//Primary returns expressions::Expression:
	//    '(' Expression ')' |  Atomic
	//;
	public PrimaryElements getPrimaryAccess() {
		return pPrimary;
	}
	
	public ParserRule getPrimaryRule() {
		return getPrimaryAccess().getRule();
	}
	
	//Atomic returns expressions::Expression:
	//    {expressions::BigDecimalConstant} value=EBigDecimal |
	//    {expressions::DeclarationRef} declaration=[expressions::Declaration]
	//;
	public AtomicElements getAtomicAccess() {
		return pAtomic;
	}
	
	public ParserRule getAtomicRule() {
		return getAtomicAccess().getRule();
	}
	
	//// general part
	//EBigDecimal returns ecore::EBigDecimal:
	//    '-'? INT ('.' INT)? (('E'|'e') '-'? INT)?;
	public EBigDecimalElements getEBigDecimalAccess() {
		return pEBigDecimal;
	}
	
	public ParserRule getEBigDecimalRule() {
		return getEBigDecimalAccess().getRule();
	}
	
	//IID returns ecore::EString:
	//    INT | ID
	//;
	public IIDElements getIIDAccess() {
		return pIID;
	}
	
	public ParserRule getIIDRule() {
		return getIIDAccess().getRule();
	}
	
	//ResourceQualifiedName:
	//   IID ('.' IID)?;
	public ResourceQualifiedNameElements getResourceQualifiedNameAccess() {
		return pResourceQualifiedName;
	}
	
	public ParserRule getResourceQualifiedNameRule() {
		return getResourceQualifiedNameAccess().getRule();
	}
	
	//terminal ID: '^'?('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;
	public TerminalRule getIDRule() {
		return gaTerminals.getIDRule();
	}
	
	//terminal INT returns ecore::EInt: ('0'..'9')+;
	public TerminalRule getINTRule() {
		return gaTerminals.getINTRule();
	}
	
	//terminal STRING:
	//            '"' ( '\\' . /* 'b'|'t'|'n'|'f'|'r'|'u'|'"'|"'"|'\\' */ | !('\\'|'"') )* '"' |
	//            "'" ( '\\' . /* 'b'|'t'|'n'|'f'|'r'|'u'|'"'|"'"|'\\' */ | !('\\'|"'") )* "'"
	//        ;
	public TerminalRule getSTRINGRule() {
		return gaTerminals.getSTRINGRule();
	}
	
	//terminal ML_COMMENT : '/*' -> '*/';
	public TerminalRule getML_COMMENTRule() {
		return gaTerminals.getML_COMMENTRule();
	}
	
	//terminal SL_COMMENT : '//' !('\n'|'\r')* ('\r'? '\n')?;
	public TerminalRule getSL_COMMENTRule() {
		return gaTerminals.getSL_COMMENTRule();
	}
	
	//terminal WS         : (' '|'\t'|'\r'|'\n')+;
	public TerminalRule getWSRule() {
		return gaTerminals.getWSRule();
	}
	
	//terminal ANY_OTHER: .;
	public TerminalRule getANY_OTHERRule() {
		return gaTerminals.getANY_OTHERRule();
	}
}
