/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
package org.eclipse.lsat.activity.teditor.serializer;

import activity.Activity;
import activity.ActivityPackage;
import activity.ActivitySet;
import activity.Claim;
import activity.Event;
import activity.EventItem;
import activity.LocationPrerequisite;
import activity.Move;
import activity.RaiseEvent;
import activity.Release;
import activity.RequireEvent;
import activity.SimpleAction;
import activity.TracePoint;
import com.google.inject.Inject;
import java.util.Set;
import machine.Import;
import machine.MachinePackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.lsat.activity.teditor.services.ActivityGrammarAccess;
import org.eclipse.lsat.common.graph.directed.editable.EdgPackage;
import org.eclipse.lsat.common.graph.directed.editable.Edge;
import org.eclipse.lsat.common.graph.directed.editable.SourceReference;
import org.eclipse.lsat.common.graph.directed.editable.TargetReference;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public abstract class AbstractActivitySemanticSequencer extends AbstractDelegatingSemanticSequencer {

    @Inject
    private ActivityGrammarAccess grammarAccess;

    @Override
    public void sequence(ISerializationContext context, EObject semanticObject) {
        EPackage epackage = semanticObject.eClass().getEPackage();
        ParserRule rule = context.getParserRule();
        Action action = context.getAssignedAction();
        Set<Parameter> parameters = context.getEnabledBooleanParameters();
        if (epackage == ActivityPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case ActivityPackage.ACTIVITY:
                sequence_Activity(context, (Activity) semanticObject); 
                return; 
            case ActivityPackage.ACTIVITY_SET:
                sequence_ActivitySet(context, (ActivitySet) semanticObject); 
                return; 
            case ActivityPackage.CLAIM:
                sequence_Claim(context, (Claim) semanticObject); 
                return; 
            case ActivityPackage.EVENT:
                sequence_Event(context, (Event) semanticObject); 
                return; 
            case ActivityPackage.EVENT_ITEM:
                sequence_EventItem(context, (EventItem) semanticObject); 
                return; 
            case ActivityPackage.LOCATION_PREREQUISITE:
                sequence_LocationPrerequisite(context, (LocationPrerequisite) semanticObject); 
                return; 
            case ActivityPackage.MOVE:
                sequence_Move(context, (Move) semanticObject); 
                return; 
            case ActivityPackage.RAISE_EVENT:
                sequence_RaiseEvent(context, (RaiseEvent) semanticObject); 
                return; 
            case ActivityPackage.RELEASE:
                sequence_Release(context, (Release) semanticObject); 
                return; 
            case ActivityPackage.REQUIRE_EVENT:
                sequence_RequireEvent(context, (RequireEvent) semanticObject); 
                return; 
            case ActivityPackage.SIMPLE_ACTION:
                sequence_SimpleAction(context, (SimpleAction) semanticObject); 
                return; 
            case ActivityPackage.TRACE_POINT:
                sequence_TracePoint(context, (TracePoint) semanticObject); 
                return; 
            }
        else if (epackage == EdgPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case EdgPackage.EDGE:
                sequence_Edge(context, (Edge) semanticObject); 
                return; 
            case EdgPackage.SOURCE_REFERENCE:
                sequence_SourceReference(context, (SourceReference) semanticObject); 
                return; 
            case EdgPackage.TARGET_REFERENCE:
                sequence_TargetReference(context, (TargetReference) semanticObject); 
                return; 
            }
        else if (epackage == MachinePackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case MachinePackage.IMPORT:
                sequence_Import(context, (Import) semanticObject); 
                return; 
            }
        if (errorAcceptor != null)
            errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
    }

    /**
     * <pre>
     * Contexts:
     *     ActivitySet returns ActivitySet
     *
     * Constraint:
     *     (imports+=Import* (activities+=Activity | events+=Event)*)
     * </pre>
     */
                protected void sequence_ActivitySet(ISerializationContext context, ActivitySet semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Activity returns Activity
     *
     * Constraint:
     *     (name=IID prerequisites+=LocationPrerequisite* nodes+=Node* edges+=Edges*)
     * </pre>
     */
                protected void sequence_Activity(ISerializationContext context, Activity semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Node returns Claim
     *     Claim returns Claim
     *
     * Constraint:
     *     (
     *         name=IID 
     *         (entry=TracePoint | (outerEntry=TracePoint entry=TracePoint))? 
     *         passive?='passive'? 
     *         resource=[IResource|ResourceQualifiedName] 
     *         (exit=TracePoint | (exit=TracePoint outerExit=TracePoint))?
     *     )
     * </pre>
     */
                protected void sequence_Claim(ISerializationContext context, Claim semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Edges returns Edge
     *     Edge returns Edge
     *     DependencyTarget returns Edge
     *
     * Constraint:
     *     (source=SourceReference target=DependencyTarget)
     * </pre>
     */
                protected void sequence_Edge(ISerializationContext context, Edge semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, EdgPackage.Literals.EDGE__SOURCE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EdgPackage.Literals.EDGE__SOURCE));
        if (transientValues.isValueTransient(semanticObject, EdgPackage.Literals.EDGE__TARGET) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EdgPackage.Literals.EDGE__TARGET));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getEdgeAccess().getSourceSourceReferenceParserRuleCall_1_0(), semanticObject.getSource());
    feeder.accept(grammarAccess.getEdgeAccess().getTargetDependencyTargetParserRuleCall_3_0(), semanticObject.getTarget());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     EventItem returns EventItem
     *
     * Constraint:
     *     name=IID
     * </pre>
     */
                protected void sequence_EventItem(ISerializationContext context, EventItem semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MachinePackage.Literals.IRESOURCE__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MachinePackage.Literals.IRESOURCE__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getEventItemAccess().getNameIIDParserRuleCall_1_0(), semanticObject.getName());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Event returns Event
     *
     * Constraint:
     *     (name=ID (items+=EventItem items+=EventItem*)?)
     * </pre>
     */
                protected void sequence_Event(ISerializationContext context, Event semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Import returns Import
     *
     * Constraint:
     *     importURI=STRING
     * </pre>
     */
                protected void sequence_Import(ISerializationContext context, Import semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MachinePackage.Literals.IMPORT__IMPORT_URI) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MachinePackage.Literals.IMPORT__IMPORT_URI));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_1_0(), semanticObject.getImportURI());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     LocationPrerequisite returns LocationPrerequisite
     *
     * Constraint:
     *     (resource=[IResource|ResourceQualifiedName] peripheral=[Peripheral|IID] position=[SymbolicPosition|IID])
     * </pre>
     */
                protected void sequence_LocationPrerequisite(ISerializationContext context, LocationPrerequisite semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.LOCATION_PREREQUISITE__RESOURCE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.LOCATION_PREREQUISITE__RESOURCE));
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.LOCATION_PREREQUISITE__PERIPHERAL) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.LOCATION_PREREQUISITE__PERIPHERAL));
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.LOCATION_PREREQUISITE__POSITION) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.LOCATION_PREREQUISITE__POSITION));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getLocationPrerequisiteAccess().getResourceIResourceResourceQualifiedNameParserRuleCall_0_0_1(), semanticObject.eGet(ActivityPackage.Literals.LOCATION_PREREQUISITE__RESOURCE, false));
    feeder.accept(grammarAccess.getLocationPrerequisiteAccess().getPeripheralPeripheralIIDParserRuleCall_2_0_1(), semanticObject.eGet(ActivityPackage.Literals.LOCATION_PREREQUISITE__PERIPHERAL, false));
    feeder.accept(grammarAccess.getLocationPrerequisiteAccess().getPositionSymbolicPositionIIDParserRuleCall_4_0_1(), semanticObject.eGet(ActivityPackage.Literals.LOCATION_PREREQUISITE__POSITION, false));
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Node returns Move
     *     Move returns Move
     *
     * Constraint:
     *     (
     *         name=IID 
     *         (entry=TracePoint | (outerEntry=TracePoint entry=TracePoint))? 
     *         resource=[IResource|ResourceQualifiedName] 
     *         peripheral=[Peripheral|IID] 
     *         ((passing?='passing'? targetPosition=[SymbolicPosition|IID]) | (continuing?='continuing'? distance=[Distance|IID])) 
     *         profile=[Profile|IID] 
     *         schedulingType=Scheduling? 
     *         (exit=TracePoint | (exit=TracePoint outerExit=TracePoint))?
     *     )
     * </pre>
     */
                protected void sequence_Move(ISerializationContext context, Move semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Node returns RaiseEvent
     *     RaiseEvent returns RaiseEvent
     *
     * Constraint:
     *     (name=IID resource=[IResource|ResourceQualifiedName])
     * </pre>
     */
                protected void sequence_RaiseEvent(ISerializationContext context, RaiseEvent semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, EdgPackage.Literals.NODE__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EdgPackage.Literals.NODE__NAME));
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.RESOURCE_ACTION__RESOURCE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.RESOURCE_ACTION__RESOURCE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getRaiseEventAccess().getNameIIDParserRuleCall_1_0(), semanticObject.getName());
    feeder.accept(grammarAccess.getRaiseEventAccess().getResourceIResourceResourceQualifiedNameParserRuleCall_4_0_1(), semanticObject.eGet(ActivityPackage.Literals.RESOURCE_ACTION__RESOURCE, false));
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Node returns Release
     *     Release returns Release
     *
     * Constraint:
     *     (
     *         name=IID 
     *         (entry=TracePoint | (outerEntry=TracePoint entry=TracePoint))? 
     *         resource=[IResource|ResourceQualifiedName] 
     *         (exit=TracePoint | (exit=TracePoint outerExit=TracePoint))?
     *     )
     * </pre>
     */
                protected void sequence_Release(ISerializationContext context, Release semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Node returns RequireEvent
     *     RequireEvent returns RequireEvent
     *
     * Constraint:
     *     (name=IID resource=[IResource|ResourceQualifiedName])
     * </pre>
     */
                protected void sequence_RequireEvent(ISerializationContext context, RequireEvent semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, EdgPackage.Literals.NODE__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EdgPackage.Literals.NODE__NAME));
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.RESOURCE_ACTION__RESOURCE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.RESOURCE_ACTION__RESOURCE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getRequireEventAccess().getNameIIDParserRuleCall_1_0(), semanticObject.getName());
    feeder.accept(grammarAccess.getRequireEventAccess().getResourceIResourceResourceQualifiedNameParserRuleCall_4_0_1(), semanticObject.eGet(ActivityPackage.Literals.RESOURCE_ACTION__RESOURCE, false));
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Node returns SimpleAction
     *     SimpleAction returns SimpleAction
     *
     * Constraint:
     *     (
     *         name=IID 
     *         (entry=TracePoint | (outerEntry=TracePoint entry=TracePoint))? 
     *         resource=[IResource|ResourceQualifiedName] 
     *         peripheral=[Peripheral|IID] 
     *         type=[ActionType|IID] 
     *         schedulingType=Scheduling? 
     *         (exit=TracePoint | (exit=TracePoint outerExit=TracePoint))?
     *     )
     * </pre>
     */
                protected void sequence_SimpleAction(ISerializationContext context, SimpleAction semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     SourceReference returns SourceReference
     *
     * Constraint:
     *     (node=[Action|IID] | node=[SyncBar|IID])
     * </pre>
     */
                protected void sequence_SourceReference(ISerializationContext context, SourceReference semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     DependencyTarget returns TargetReference
     *     TargetReference returns TargetReference
     *
     * Constraint:
     *     (node=[Action|IID] | node=[SyncBar|IID])
     * </pre>
     */
                protected void sequence_TargetReference(ISerializationContext context, TargetReference semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     TracePoint returns TracePoint
     *
     * Constraint:
     *     (regex?='~'? value=EString)
     * </pre>
     */
                protected void sequence_TracePoint(ISerializationContext context, TracePoint semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

}
