/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.petri_net.design;

import activity.Action;
import activity.Claim;
import activity.Move;
import activity.Release;
import activity.SimpleAction;
import org.eclipse.lsat.petri_net.Place;
import org.eclipse.lsat.petri_net.Transition;
import org.eclipse.lsat.trace.TraceLine;

public class PetriNetService {
    public String getTooltip(Place place) {
        Object tooltip;
        Action action = place.getAction();
        Object object = tooltip = place.getName() == null ? "" : place.getName();
        if (action instanceof Claim) {
            tooltip = (String)tooltip + String.format(": claim %s", ((Claim)action).getResource().getName());
        } else if (action instanceof Release) {
            tooltip = (String)tooltip + String.format(": release %s", ((Release)action).getResource().getName());
        } else if (action instanceof SimpleAction) {
            SimpleAction pa = (SimpleAction)place.getAction();
            tooltip = (String)tooltip + String.format(": %s.%s.%s", pa.getResource().fqn(), pa.getPeripheral().getName(), pa.getType().getName());
        } else if (action instanceof Move) {
            Move move = (Move)action;
            tooltip = move.isPositionMove() ? (String)tooltip + String.format(": move %s.%s to %s using speed profile %s", move.getResource().fqn(), move.getPeripheral().getName(), move.getTargetPosition().getName(), move.getProfile().getName()) : (String)tooltip + String.format(": move %s.%s for %s using speed profile %s", move.getResource().fqn(), move.getPeripheral().getName(), move.getDistance().getName(), move.getProfile().getName());
        }
        return ((String)tooltip).isEmpty() ? null : tooltip;
    }

    public String getTooltip(Transition transition) {
        Object tooltip = "";
        for (TraceLine tl : transition.getTraceLines()) {
            if (!((String)tooltip).isEmpty()) {
                tooltip = (String)tooltip + "\n";
            }
            tooltip = (String)tooltip + String.format("%s, line %s: %s", tl.getModel().getName(), tl.getLineNumber(), tl.getTracePoint());
        }
        return ((String)tooltip).isEmpty() ? null : tooltip;
    }
}

