/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.view;

import activity.Move;
import java.awt.Paint;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsat.activity.teditor.validation.ActivityValidator;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.motioncalculator.MotionSegment;
import org.eclipse.lsat.motioncalculator.PositionInfo;
import org.eclipse.lsat.motioncalculator.util.PositionInfoUtilities;
import org.eclipse.lsat.timing.calculator.MotionCalculatorExtension;
import org.eclipse.lsat.timing.util.MotionCalculatorHelper;
import org.eclipse.lsat.timing.util.MoveHelper;
import org.eclipse.lsat.timing.view.XYPlotView;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import setting.SettingUtil;
import setting.Settings;

public class MotionViewJob
extends Job {
    public static final String SHOW_DEBUG_INFO = "org.eclipse.lsat.timing.view.debug";
    private final Move move;

    public MotionViewJob(Move move) {
        super("Plot " + ActivityValidator.id((Node)move));
        this.move = move;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Calculating plot info", -1);
            Settings settings = SettingUtil.getSettings((Resource)this.move.eResource());
            MotionCalculatorExtension motionCalculator = MotionCalculatorExtension.getSelectedMotionCalculator();
            MotionCalculatorHelper util = new MotionCalculatorHelper(settings, motionCalculator);
            List<Move> concatenatedMove = util.getConcatenatedMove(this.move);
            List<MotionSegment> motionSegments = util.createMotionSegments(concatenatedMove);
            List<Double> motionTimes = motionCalculator.calculateTimes(motionSegments);
            Collection<PositionInfo> plotInfo = motionCalculator.getPositionInfo(motionSegments);
            Set setPoints = PositionInfoUtilities.getSetPointIds(plotInfo);
            if (plotInfo == null || plotInfo.size() == 0 || monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.subTask("Rendering plot");
            JFreeChart jfreechart = null;
            Iterator iter = setPoints.iterator();
            int i = 0;
            while (iter.hasNext()) {
                String setPoint = (String)iter.next();
                XYSeries setPointSeries = new XYSeries((Comparable)((Object)("Position " + setPoint)));
                PositionInfo posInfo = plotInfo.stream().filter(p -> setPoint.equals(p.getSetPointId())).findFirst().get();
                posInfo.getTimePositions().forEach(e -> setPointSeries.add(e.getTime(), e.getPosition()));
                XYSeriesCollection dataSet = new XYSeriesCollection(setPointSeries);
                if (i == 0) {
                    jfreechart = ChartFactory.createXYLineChart((String)this.getTitle(concatenatedMove), (String)"Time", (String)setPoint, (XYDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                    jfreechart.addSubtitle((Title)new TextTitle(this.getSubTitle(concatenatedMove)));
                    this.updateRenderer(jfreechart.getXYPlot(), i);
                } else {
                    XYPlot xyplot = jfreechart.getXYPlot();
                    NumberAxis numberaxis = new NumberAxis(setPoint);
                    numberaxis.setAutoRangeIncludesZero(false);
                    xyplot.setRangeAxis(i, (ValueAxis)numberaxis);
                    xyplot.setDataset(i, (XYDataset)dataSet);
                    xyplot.mapDatasetToRangeAxis(i, i);
                    this.updateRenderer(xyplot, i);
                }
                ++i;
            }
            XYPlot xyplot = jfreechart.getXYPlot();
            xyplot.setDomainPannable(true);
            xyplot.setRangePannable(true);
            int i2 = 0;
            while (i2 < motionTimes.size()) {
                ValueMarker marker = new ValueMarker(motionTimes.get(i2).doubleValue());
                Move move = concatenatedMove.get(i2);
                String text = move.isPositionMove() ? String.format("%s %s at %.4f", i2 < motionTimes.size() - 1 ? "Passing" : "At", move.getTargetPosition().getName(), motionTimes.get(i2)) : String.format("Completed %s at %.4f", move.getDistance().getName(), motionTimes.get(i2));
                marker.setLabel(text);
                marker.setLabelAnchor(RectangleAnchor.BOTTOM_LEFT);
                xyplot.addDomainMarker((Marker)marker);
                ++i2;
            }
            XYPlotView.showJFreeChart(jfreechart);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e2) {
            Status status = new Status(4, "org.eclipse.lsat.timing", e2.getMessage(), (Throwable)e2);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    private XYItemRenderer updateRenderer(XYPlot xyplot, int index) {
        StandardXYItemRenderer standardxyitemrenderer = new StandardXYItemRenderer();
        xyplot.setRenderer(index, (XYItemRenderer)standardxyitemrenderer);
        Paint paint = standardxyitemrenderer.lookupSeriesPaint(0);
        xyplot.getRangeAxis(index).setLabelPaint(paint);
        xyplot.getRangeAxis(index).setTickLabelPaint(paint);
        return standardxyitemrenderer;
    }

    private String getTitle(List<Move> concatenatedMove) {
        if (concatenatedMove.size() == 1) {
            return ActivityValidator.id((Node)((Node)concatenatedMove.get(0)));
        }
        return "Concatenated move: " + ActivityValidator.names(concatenatedMove);
    }

    private String getSubTitle(List<Move> concatenatedMove) {
        if (concatenatedMove.isEmpty()) {
            return "";
        }
        if (this.isPositionMove(concatenatedMove)) {
            return this.getPositionsSubTitle(concatenatedMove);
        }
        return this.getDistancesSubTitle(concatenatedMove);
    }

    private boolean isPositionMove(List<Move> concatenatedMove) {
        return concatenatedMove.stream().anyMatch(e -> e.isPositionMove());
    }

    private String getDistancesSubTitle(List<Move> concatenatedMove) {
        StringBuffer subTitle = new StringBuffer();
        String currentName = MoveHelper.getName(concatenatedMove.get(0));
        int count = 1;
        int i = 1;
        while (i < concatenatedMove.size()) {
            String name = MoveHelper.getName(concatenatedMove.get(i));
            if (name.equals(currentName)) {
                ++count;
            } else {
                this.appendDistances(subTitle, currentName, count);
                currentName = name;
                count = 1;
            }
            ++i;
        }
        this.appendDistances(subTitle, currentName, count);
        return subTitle.toString();
    }

    private StringBuffer appendDistances(StringBuffer subTitle, String name, int count) {
        if (subTitle.length() > 0) {
            subTitle.append(" \u25ba ");
        }
        subTitle.append(name);
        if (count > 1) {
            subTitle.append(" (").append(count).append("x)");
        }
        return subTitle;
    }

    private String getPositionsSubTitle(List<Move> concatenatedMove) {
        StringBuffer subTitle = new StringBuffer();
        int i = 0;
        while (i < concatenatedMove.size()) {
            if (concatenatedMove.get(i).isPositionMove()) {
                Move move = concatenatedMove.get(i);
                if (i == 0) {
                    subTitle.append(move.getSourcePosition().getName());
                }
                subTitle.append(" \u25ba ");
                subTitle.append(move.getTargetPosition().getName());
            }
            ++i;
        }
        return subTitle.toString();
    }
}

