/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.validation;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import machine.Axis;
import machine.BidirectionalPath;
import machine.FullMeshPath;
import machine.IResource;
import machine.Machine;
import machine.Path;
import machine.PathTargetReference;
import machine.Peripheral;
import machine.SymbolicPosition;
import machine.UnidirectionalPath;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsat.common.emf.common.util.BufferedDiagnosticChain;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.timing.calculator.MotionCalculatorExtension;
import org.eclipse.lsat.timing.util.AxesLocation;
import org.eclipse.lsat.timing.util.MotionCalculatorHelper;
import org.eclipse.lsat.timing.util.SpecificationException;
import setting.SettingUtil;
import setting.Settings;

public class MachineEValidator
implements EValidator {
    public static final MachineEValidator INSTANCE = new MachineEValidator();

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return eObject == null ? true : this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        BufferedDiagnosticChain bufferedDiagnostics = new BufferedDiagnosticChain(diagnostics);
        switch (eClass.getClassifierID()) {
            case 6: {
                this.validateMachine((Machine)eObject, (DiagnosticChain)bufferedDiagnostics);
            }
        }
        return bufferedDiagnostics.getMaxSeverity() < 2;
    }

    private void validateMachine(Machine machine, DiagnosticChain diagnostics) {
        try {
            Settings settings = SettingUtil.getSettings((Resource)machine.eResource());
            MotionCalculatorExtension motionCalculator = MotionCalculatorExtension.getSelectedMotionCalculator();
            MotionCalculatorHelper helper = new MotionCalculatorHelper(settings, motionCalculator);
            for (Path path : QueryableIterable.from((Iterable)machine.getResources()).xcollect(r -> r.getPeripherals()).xcollect(p -> p.getPaths())) {
                for (IResource resource : this.getUsedResources(path, settings)) {
                    switch (path.eClass().getClassifierID()) {
                        case 16: {
                            this.validateUnidirectionalPath((UnidirectionalPath)path, resource, helper, diagnostics);
                            break;
                        }
                        case 17: {
                            this.validateBidirectionalPath((BidirectionalPath)path, resource, helper, diagnostics);
                            break;
                        }
                        case 18: {
                            this.validateFullMeshPath((FullMeshPath)path, resource, helper, diagnostics);
                        }
                    }
                }
            }
        }
        catch (IOException | MotionException e) {
            this.writeDiagnostic(diagnostics, 1, "Timing validation disabled: " + e.getMessage(), new EObject[]{machine});
        }
    }

    private Collection<IResource> getUsedResources(Path path, Settings settings) {
        return this.getUsedResources(path.getPeripheral(), settings);
    }

    private Collection<IResource> getUsedResources(Peripheral peripheral, Settings settings) {
        return settings.getTransitivePhysicalSettings().stream().filter(e -> peripheral.equals(e.getPeripheral())).map(e -> e.getResource()).collect(Collectors.toSet());
    }

    private void validateUnidirectionalPath(UnidirectionalPath path, IResource resource, MotionCalculatorHelper helper, DiagnosticChain diagnostics) {
        try {
            AxesLocation source = helper.getAxesLocation(resource, path.getSource());
            AxesLocation target = helper.getAxesLocation(resource, this.safeGetPosition(path.getTarget()));
            Set<Axis> movingAxes = source.getMovingAxes(target);
            if (movingAxes.size() > 1) {
                this.writeDiagnostic(diagnostics, 2, String.format("Axes %s are moving simultaneously when moving from %s to %s", QueryableIterable.from(movingAxes).xcollectOne(a -> a.getName()), source.getPosition().getName(), target.getPosition().getName()), new EObject[]{path});
            }
        }
        catch (SpecificationException e) {
            this.writeDiagnostic(diagnostics, 1, "Physical settings validation disabled: " + e.getMessage(), new EObject[]{path});
        }
    }

    private void validateBidirectionalPath(BidirectionalPath path, IResource resource, MotionCalculatorHelper helper, DiagnosticChain diagnostics) {
        try {
            AxesLocation source = helper.getAxesLocation(resource, this.safeGetPosition((PathTargetReference)this.safeGetIndex((List)path.getEndPoints(), 0)));
            AxesLocation target = helper.getAxesLocation(resource, this.safeGetPosition((PathTargetReference)this.safeGetIndex((List)path.getEndPoints(), 1)));
            Set<Axis> movingAxes = source.getMovingAxes(target);
            if (movingAxes.size() > 1) {
                this.writeDiagnostic(diagnostics, 2, String.format("Axes %s are moving simultaneously when moving between %s and %s", QueryableIterable.from(movingAxes).xcollectOne(a -> a.getName()), source.getPosition().getName(), target.getPosition().getName()), new EObject[]{path});
            }
        }
        catch (SpecificationException e) {
            this.writeDiagnostic(diagnostics, 1, "Physical settings validation disabled: " + e.getMessage(), new EObject[]{path});
        }
    }

    private void validateFullMeshPath(FullMeshPath path, IResource resource, MotionCalculatorHelper helper, DiagnosticChain diagnostics) {
        try {
            EList endPoints = path.getEndPoints();
            int i = 0;
            while (i < endPoints.size()) {
                AxesLocation source = helper.getAxesLocation(resource, this.safeGetPosition((PathTargetReference)endPoints.get(i)));
                int j = i + 1;
                while (j < endPoints.size()) {
                    AxesLocation target = helper.getAxesLocation(resource, this.safeGetPosition((PathTargetReference)endPoints.get(j)));
                    Set<Axis> movingAxes = source.getMovingAxes(target);
                    if (movingAxes.size() > 1) {
                        this.writeDiagnostic(diagnostics, 2, String.format("Axes %s are moving simultaneously when moving between %s and %s", QueryableIterable.from(movingAxes).xcollectOne(a -> a.getName()), source.getPosition().getName(), target.getPosition().getName()), new EObject[]{path});
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (SpecificationException e) {
            this.writeDiagnostic(diagnostics, 1, "Physical settings validation disabled: " + e.getMessage(), new EObject[]{path});
        }
    }

    private SymbolicPosition safeGetPosition(PathTargetReference pathTargetReference) {
        return pathTargetReference != null ? pathTargetReference.getPosition() : null;
    }

    private <T> T safeGetIndex(List<T> coll, int index) {
        return index < coll.size() ? (T)coll.get(index) : null;
    }

    private void writeDiagnostic(DiagnosticChain diagnostics, int severity, String message, EObject ... data) {
        diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.lsat.machine.dsl", 0, message, (Object[])data));
    }
}

