/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.queries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.lsat.common.queries.IterableQueries;
import org.eclipse.lsat.common.util.IterableIterator;
import org.eclipse.lsat.common.util.IterableUtil;
import org.eclipse.lsat.common.util.LoggableIterable;
import org.eclipse.lsat.common.util.ObjIntFunction;
import org.eclipse.lsat.common.util.StreamIterator;

public class QueryableIterable<Input>
extends LoggableIterable<Input> {
    public static final QueryableIterable EMPTY = new QueryableIterable(Collections.EMPTY_LIST);
    private Iterable<Input> input;

    @SafeVarargs
    public static <T> QueryableIterable<T> from(T ... input) {
        return input == null ? QueryableIterable.empty() : new QueryableIterable<T>(IterableUtil.asList(input));
    }

    public static <T> QueryableIterable<T> from(Iterable<T> input) {
        if (input == null) {
            return QueryableIterable.empty();
        }
        if (input instanceof QueryableIterable) {
            return (QueryableIterable)input;
        }
        return new QueryableIterable<T>(input);
    }

    public static <T> QueryableIterable<T> from(Iterator<T> input) {
        return input == null ? QueryableIterable.empty() : new QueryableIterable<T>(new IterableIterator<T>(input));
    }

    public static <T> QueryableIterable<T> from(Stream<T> input) {
        return input == null ? QueryableIterable.empty() : new QueryableIterable<T>(new IterableIterator<T>(new StreamIterator<T>(input)));
    }

    public static <K, V> QueryableIterable<Map.Entry<K, V>> from(Map<K, V> input) {
        return input == null ? QueryableIterable.empty() : new QueryableIterable<Map.Entry<K, V>>(input.entrySet());
    }

    public static <T, O> QueryableIterable<T> from(O owner, ObjIntFunction<? super O, T> getter, ToIntFunction<? super O> size) {
        return owner == null ? QueryableIterable.empty() : new QueryableIterable<T>(IterableUtil.iterate(owner, getter, size));
    }

    public static <T> QueryableIterable<T> empty() {
        return EMPTY;
    }

    protected QueryableIterable(Iterable<Input> input) {
        this.input = input;
    }

    protected <T> QueryableIterable<T> wrap(Iterable<T> input) {
        return new QueryableIterable<T>(input);
    }

    @Override
    public Iterator<Input> iterator() {
        return this.input.iterator();
    }

    public Stream<Input> stream() {
        return StreamSupport.stream(this.input.spliterator(), false);
    }

    public QueryableIterable<Input> union(Iterable<? extends Input> other) {
        return this.including(other);
    }

    public QueryableIterable<Input> union(Input ... other) {
        return this.including(other);
    }

    public QueryableIterable<Input> including(Iterable<? extends Input> includes) {
        return this.wrap(IterableQueries.including(this.input, includes));
    }

    @SafeVarargs
    public final QueryableIterable<Input> including(Input ... includes) {
        return this.wrap(IterableQueries.including(this.input, includes));
    }

    public final boolean includes(Input includes) {
        return this.exists(i -> i == includes);
    }

    public QueryableIterable<Input> excluding(Iterable<?> excludes) {
        return this.wrap(IterableQueries.excluding(this.input, excludes));
    }

    @SafeVarargs
    public final QueryableIterable<Input> excluding(Object ... excludes) {
        return this.wrap(IterableQueries.excluding(this.input, excludes));
    }

    public final boolean excludes(Input excludes) {
        return !this.includes(excludes);
    }

    public QueryableIterable<Input> closure(Function<Input, Iterable<? extends Input>> functor) {
        return this.wrap(IterableQueries.closure(this.input, functor));
    }

    public QueryableIterable<Input> closure(boolean includeSelf, Function<Input, Iterable<? extends Input>> functor) {
        return this.wrap(IterableQueries.closure(this.input, includeSelf, functor));
    }

    public QueryableIterable<Input> closureWhile(boolean includeSelf, Function<Input, Iterable<? extends Input>> functor, Predicate<? super Input> predicate) {
        return this.wrap(IterableQueries.closureWhile(this.input, includeSelf, functor, predicate));
    }

    public QueryableIterable<Input> closureOne(Function<Input, ? extends Input> functor) {
        return this.wrap(IterableQueries.closureOne(this.input, functor));
    }

    public QueryableIterable<Input> closureOne(boolean includeSelf, Function<Input, ? extends Input> functor) {
        return this.wrap(IterableQueries.closureOne(this.input, includeSelf, functor));
    }

    public QueryableIterable<Input> closureOneWhile(boolean includeSelf, Function<Input, ? extends Input> functor, Predicate<? super Input> predicate) {
        return this.wrap(IterableQueries.closureOneWhile(this.input, includeSelf, functor, predicate));
    }

    public QueryableIterable<Input> climbTree(Function<Input, ? extends Input> functor) {
        return this.wrap(IterableQueries.climbTree(this.input, functor));
    }

    public QueryableIterable<Input> climbTree(boolean includeSelf, Function<Input, ? extends Input> functor) {
        return this.wrap(IterableQueries.climbTree(this.input, includeSelf, functor));
    }

    public QueryableIterable<Input> walkTree(Function<Input, Iterable<? extends Input>> functor) {
        return this.wrap(IterableQueries.walkTree(this.input, functor));
    }

    public QueryableIterable<Input> walkTree(boolean includeSelf, Function<Input, Iterable<? extends Input>> functor) {
        return this.wrap(IterableQueries.walkTree(this.input, includeSelf, functor));
    }

    public QueryableIterable<Input> select(Predicate<? super Input> functor) {
        return this.wrap(IterableQueries.select(this.input, functor));
    }

    public QueryableIterable<Input> xselect(Predicate<? super Input> functor) {
        return this.wrap(IterableQueries.xselect(this.input, functor));
    }

    public QueryableIterable<Input> reject(Predicate<? super Input> functor) {
        return this.wrap(IterableQueries.reject(this.input, functor));
    }

    public <Output> QueryableIterable<Output> objectsOfKind(Class<Output> outputType) {
        return this.wrap(IterableQueries.objectsOfKind(this.input, outputType));
    }

    public <Output> QueryableIterable<Output> objectsOfType(Class<Output> outputType) {
        return this.wrap(IterableQueries.objectsOfType(this.input, outputType));
    }

    public <Output> QueryableIterable<Output> asType(Class<Output> outputType) {
        return this.wrap(IterableQueries.asType(this.input, outputType));
    }

    public <Output> QueryableIterable<Output> collect(Function<? super Input, Iterable<? extends Output>> functor) {
        return this.wrap(IterableQueries.collect(this.input, functor));
    }

    public <Output> QueryableIterable<Output> xcollect(Function<? super Input, Iterable<? extends Output>> functor) {
        return this.wrap(IterableQueries.xcollect(this.input, functor));
    }

    public <Output> QueryableIterable<Output> collectOne(Function<? super Input, Output> functor) {
        return this.wrap(IterableQueries.collectOne(this.input, functor));
    }

    public <Output> QueryableIterable<Output> xcollectOne(Function<? super Input, Output> functor) {
        return this.wrap(IterableQueries.xcollectOne(this.input, functor));
    }

    public boolean forAll(Predicate<? super Input> functor) {
        return IterableQueries.forAll(this.input, functor);
    }

    public boolean exists(Predicate<? super Input> functor) {
        return IterableQueries.exists(this.input, functor);
    }

    public Input any(Predicate<? super Input> functor) {
        return IterableQueries.any(this.input, functor);
    }

    public Input first() {
        return IterableUtil.first(this.input);
    }

    public Input last() {
        return IterableUtil.last(this.input);
    }

    public Object[] toArray() {
        return IterableUtil.toArray(this.input);
    }

    public <Output> Output[] toArray(Class<Output> type) {
        return IterableUtil.toArray(this.input, type);
    }

    public LinkedList<Input> asList() {
        return IterableUtil.asList(this.input);
    }

    public ArrayList<Input> asList(int initialCapacity) {
        return IterableUtil.asList(this.input, initialCapacity);
    }

    public Set<Input> asSet() {
        return IterableUtil.asSet(this.input);
    }

    public LinkedHashSet<Input> asOrderedSet() {
        return IterableUtil.asOrderedSet(this.input);
    }

    public int size() {
        return IterableUtil.size(this.input);
    }

    public boolean isEmpty() {
        return IterableUtil.isEmpty(this.input);
    }

    public <Output extends Comparable<? super Output>> QueryableIterable<Input> sortedBy(Function<? super Input, Output> functor) {
        return this.wrap(IterableUtil.sortedBy(this.input, functor));
    }

    public <Output> QueryableIterable<Input> sortedBy(Function<? super Input, Output> functor, Comparator<? super Output> comparator) {
        return this.wrap(IterableUtil.sortedBy(this.input, functor, comparator));
    }

    public QueryableIterable<Input> sorted(Comparator<? super Input> comparator) {
        return this.wrap(IterableUtil.sortedBy(this.input, i -> i, comparator));
    }

    public QueryableIterable<Input> unique() {
        return this.wrap(IterableUtil.unique(this.input));
    }

    public String joinfields(CharSequence separator, CharSequence begin, CharSequence end) {
        return IterableUtil.joinfields(this.input, separator, begin, end);
    }

    public <InputB> QueryableIterable<Pair<Input, InputB>> zip(Iterable<? extends InputB> iterableB) {
        return this.wrap(IterableQueries.zip(this.input, iterableB));
    }

    public <InputB> QueryableIterable<Pair<Input, InputB>> zip(Iterable<? extends InputB> iterableB, ToIntBiFunction<? super Input, ? super InputB> comparator) {
        return this.wrap(IterableQueries.zip(this.input, iterableB, comparator));
    }

    public <InputB> Iterable<Pair<Input, InputB>> product(Iterable<? extends InputB> iterableB) {
        return this.wrap(IterableQueries.product(this.input, iterableB));
    }

    public <K> Map<K, Input> toMap(Function<? super Input, K> computeKeys) {
        return IterableQueries.toMap(this.input, computeKeys);
    }

    public <K, V> Map<K, V> toMap(Function<? super Input, K> computeKeys, Function<? super Input, V> computeValues) {
        return IterableQueries.toMap(this.input, computeKeys, computeValues);
    }

    public <K> Map<K, List<Input>> groupBy(Function<? super Input, K> computeKeys) {
        return IterableQueries.groupBy(this.input, computeKeys);
    }

    public List<List<Input>> groupBy(Iterable<Input> iterable, BiPredicate<? super Input, ? super Input> equivalence) {
        return IterableQueries.groupBy(this.input, equivalence);
    }

    public List<List<Input>> groupBy(Comparator<? super List<Input>> comparator, BiPredicate<? super Input, ? super Input> equivalence) {
        return IterableQueries.groupBy(this.input, comparator, equivalence);
    }

    public <K, V> Map<K, V> groupByAndReduce(Function<? super Input, K> computeKeys, BiFunction<? super Input, V, ? extends V> computeValues) {
        return IterableQueries.groupByAndReduce(this.input, computeKeys, computeValues);
    }

    public QueryableIterable<List<Input>> segment(BiPredicate<? super Input, ? super Input> predicate) {
        return this.wrap(IterableQueries.segment(this.input, predicate));
    }
}

