/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.graph.simple_single;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.graph.SingleWeightedGraph;
import org.eclipse.lsat.common.ludus.backend.graph.simple_single.SSEdge;
import org.eclipse.lsat.common.ludus.backend.graph.simple_single.SSVertex;

public class SSGraph
implements SingleWeightedGraph<SSVertex, SSEdge, Double> {
    private static final long serialVersionUID = 1L;
    private final Set<SSVertex> vertexSet = new HashSet<SSVertex>();
    private final Set<SSEdge> edgeSet = new HashSet<SSEdge>();

    @Override
    public Set<SSEdge> getEdges() {
        return this.edgeSet;
    }

    public void addVertex(SSVertex vertex) {
        this.vertexSet.add(vertex);
    }

    public SSEdge addEdge(SSVertex source, SSVertex target, Double weight) {
        SSEdge e = new SSEdge(source, target, weight);
        source.addOutgoing(e);
        target.addIncoming(e);
        this.edgeSet.add(e);
        return e;
    }

    @Override
    public Set<SSVertex> getVertices() {
        return this.vertexSet;
    }

    @Override
    public Collection<SSEdge> incomingEdgesOf(SSVertex v) {
        return v.getIncoming();
    }

    @Override
    public Collection<SSEdge> outgoingEdgesOf(SSVertex v) {
        return v.getOutgoing();
    }

    @Override
    public SSVertex getEdgeSource(SSEdge e) {
        return e.getSource();
    }

    @Override
    public SSVertex getEdgeTarget(SSEdge e) {
        return e.getTarget();
    }

    @Override
    public SSEdge getEdge(SSVertex source, SSVertex target) {
        return source.getOutgoing(target);
    }

    @Override
    public Double getWeight(SSEdge edge) {
        return edge.getWeight();
    }
}

