/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.graph.simple_double;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsat.common.ludus.backend.graph.simple_double.SDEdge;

public class SDVertex
implements Comparable<SDVertex> {
    private int id;
    private Map<SDVertex, SDEdge> outgoing;
    private Map<SDVertex, SDEdge> incoming;

    public SDVertex() {
        this.id = this.hashCode();
        this.outgoing = new HashMap<SDVertex, SDEdge>();
        this.incoming = new HashMap<SDVertex, SDEdge>();
    }

    public Collection<SDEdge> getIncoming() {
        return this.incoming.values();
    }

    public SDEdge getIncoming(SDVertex source) {
        return this.incoming.get(source);
    }

    public Collection<SDEdge> getOutgoing() {
        return this.outgoing.values();
    }

    public SDEdge getOutgoing(SDVertex target) {
        return this.outgoing.get(target);
    }

    public void addIncoming(SDEdge e) {
        this.incoming.put(e.getSource(), e);
    }

    public void addOutgoing(SDEdge e) {
        this.outgoing.put(e.getTarget(), e);
    }

    public SDVertex(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    @Override
    public int compareTo(SDVertex other) {
        return Integer.compare(this.id, other.id);
    }
}

