/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.xtend;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.lsat.common.queries.IterableQueries;
import org.eclipse.lsat.common.util.BranchIterable;
import org.eclipse.lsat.common.util.IterableUtil;
import org.eclipse.lsat.common.util.LoggableIterable;
import org.eclipse.lsat.common.util.ProcessingIterator;
import org.eclipse.lsat.common.util.UniqueIterable;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class Queries {
    public static <T> Iterable<T> notNull(T element) {
        Collection _xifexpression = null;
        _xifexpression = element == null ? Collections.emptyList() : Collections.singleton(element);
        return _xifexpression;
    }

    public static <T> Iterable<T> findNearest(BranchIterable<T> source, final Functions.Function1<? super T, ? extends Boolean> predicate) {
        return IterableQueries.findNearest(source, (Predicate)new Predicate<T>(){

            @Override
            public boolean test(T arg0) {
                return (Boolean)predicate.apply(arg0);
            }
        });
    }

    public static <T, R> Iterable<R> findNearest(BranchIterable<T> source, Class<R> type) {
        return IterableQueries.findNearest(source, type);
    }

    public static <T> BranchIterable<T> until(BranchIterable<T> source, final Functions.Function1<? super T, ? extends Boolean> predicate) {
        return IterableQueries.until(source, (Predicate)new Predicate<T>(){

            @Override
            public boolean test(T arg0) {
                return (Boolean)predicate.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> upToAndIncluding(BranchIterable<T> source, final Functions.Function1<? super T, ? extends Boolean> predicate) {
        return IterableQueries.upToAndIncluding(source, (Predicate)new Predicate<T>(){

            @Override
            public boolean test(T arg0) {
                return (Boolean)predicate.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> closure(Iterable<? extends T> source, final Functions.Function1<? super T, ? extends Iterable<? extends T>> transformation) {
        return IterableQueries.closure(source, (Function)new Function<T, Iterable<? extends T>>(){

            @Override
            public Iterable<? extends T> apply(T arg0) {
                return (Iterable)transformation.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> closure(Iterable<? extends T> source, boolean includeSource, final Functions.Function1<? super T, ? extends Iterable<? extends T>> transformation) {
        return IterableQueries.closure(source, (boolean)includeSource, (Function)new Function<T, Iterable<? extends T>>(){

            @Override
            public Iterable<? extends T> apply(T arg0) {
                return (Iterable)transformation.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> closureWhile(Iterable<? extends T> source, final Functions.Function1<? super T, ? extends Iterable<? extends T>> transformation, final Functions.Function1<? super T, ? extends Boolean> predicate) {
        return IterableQueries.closureWhile(source, (Function)new Function<T, Iterable<? extends T>>(){

            @Override
            public Iterable<? extends T> apply(T arg0) {
                return (Iterable)transformation.apply(arg0);
            }
        }, (Predicate)new Predicate<T>(){

            @Override
            public boolean test(T arg0) {
                return (Boolean)predicate.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> closureWhile(Iterable<? extends T> source, boolean includeSource, final Functions.Function1<? super T, ? extends Iterable<? extends T>> transformation, final Functions.Function1<? super T, ? extends Boolean> predicate) {
        return IterableQueries.closureWhile(source, (boolean)includeSource, (Function)new Function<T, Iterable<? extends T>>(){

            @Override
            public Iterable<? extends T> apply(T arg0) {
                return (Iterable)transformation.apply(arg0);
            }
        }, (Predicate)new Predicate<T>(){

            @Override
            public boolean test(T arg0) {
                return (Boolean)predicate.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> closureOne(Iterable<? extends T> source, final Functions.Function1<? super T, ? extends T> transformation) {
        return IterableQueries.closureOne(source, (Function)new Function<T, T>(){

            @Override
            public T apply(T arg0) {
                return transformation.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> closureOne(Iterable<? extends T> source, boolean includeSource, final Functions.Function1<? super T, ? extends T> transformation) {
        return IterableQueries.closureOne(source, (boolean)includeSource, (Function)new Function<T, T>(){

            @Override
            public T apply(T arg0) {
                return transformation.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> closureOneWhile(Iterable<? extends T> source, final Functions.Function1<? super T, ? extends T> transformation, final Functions.Function1<? super T, ? extends Boolean> predicate) {
        return IterableQueries.closureOneWhile(source, (Function)new Function<T, T>(){

            @Override
            public T apply(T arg0) {
                return transformation.apply(arg0);
            }
        }, (Predicate)new Predicate<T>(){

            @Override
            public boolean test(T arg0) {
                return (Boolean)predicate.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> closureOneWhile(Iterable<? extends T> source, boolean includeSource, final Functions.Function1<? super T, ? extends T> transformation, final Functions.Function1<? super T, ? extends Boolean> predicate) {
        return IterableQueries.closureOneWhile(source, (boolean)includeSource, (Function)new Function<T, T>(){

            @Override
            public T apply(T arg0) {
                return transformation.apply(arg0);
            }
        }, (Predicate)new Predicate<T>(){

            @Override
            public boolean test(T arg0) {
                return (Boolean)predicate.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> climbTree(Iterable<? extends T> source, final Functions.Function1<? super T, ? extends T> transformation) {
        return IterableQueries.climbTree(source, (Function)new Function<T, T>(){

            @Override
            public T apply(T arg0) {
                return transformation.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> climbTree(Iterable<? extends T> source, boolean includeSelf, final Functions.Function1<? super T, ? extends T> transformation) {
        return IterableQueries.climbTree(source, (boolean)includeSelf, (Function)new Function<T, T>(){

            @Override
            public T apply(T arg0) {
                return transformation.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> climbTreeWhile(Iterable<? extends T> source, final Functions.Function1<? super T, ? extends T> transformation, final Functions.Function1<? super T, ? extends Boolean> predicate) {
        return IterableQueries.climbTreeWhile(source, (Function)new Function<T, T>(){

            @Override
            public T apply(T arg0) {
                return transformation.apply(arg0);
            }
        }, (Predicate)new Predicate<T>(){

            @Override
            public boolean test(T arg0) {
                return (Boolean)predicate.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> climbTreeWhile(Iterable<? extends T> source, boolean includeSelf, final Functions.Function1<? super T, ? extends T> transformation, final Functions.Function1<? super T, ? extends Boolean> predicate) {
        return IterableQueries.climbTreeWhile(source, (boolean)includeSelf, (Function)new Function<T, T>(){

            @Override
            public T apply(T arg0) {
                return transformation.apply(arg0);
            }
        }, (Predicate)new Predicate<T>(){

            @Override
            public boolean test(T arg0) {
                return (Boolean)predicate.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> walkTree(Iterable<? extends T> source, final Functions.Function1<? super T, ? extends Iterable<? extends T>> transformation) {
        return IterableQueries.walkTree(source, (Function)new Function<T, Iterable<? extends T>>(){

            @Override
            public Iterable<? extends T> apply(T arg0) {
                return (Iterable)transformation.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> walkTree(Iterable<? extends T> source, boolean includeSelf, final Functions.Function1<? super T, ? extends Iterable<? extends T>> transformation) {
        return IterableQueries.walkTree(source, (boolean)includeSelf, (Function)new Function<T, Iterable<? extends T>>(){

            @Override
            public Iterable<? extends T> apply(T arg0) {
                return (Iterable)transformation.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> walkTreeWhile(Iterable<? extends T> source, final Functions.Function1<? super T, ? extends Iterable<? extends T>> transformation, final Functions.Function1<? super T, ? extends Boolean> predicate) {
        return IterableQueries.walkTreeWhile(source, (Function)new Function<T, Iterable<? extends T>>(){

            @Override
            public Iterable<? extends T> apply(T arg0) {
                return (Iterable)transformation.apply(arg0);
            }
        }, (Predicate)new Predicate<T>(){

            @Override
            public boolean test(T arg0) {
                return (Boolean)predicate.apply(arg0);
            }
        });
    }

    public static <T> BranchIterable<T> walkTreeWhile(Iterable<? extends T> source, boolean includeSelf, final Functions.Function1<? super T, ? extends Iterable<? extends T>> transformation, final Functions.Function1<? super T, ? extends Boolean> predicate) {
        return IterableQueries.walkTreeWhile(source, (boolean)includeSelf, (Function)new Function<T, Iterable<? extends T>>(){

            @Override
            public Iterable<? extends T> apply(T arg0) {
                return (Iterable)transformation.apply(arg0);
            }
        }, (Predicate)new Predicate<T>(){

            @Override
            public boolean test(T arg0) {
                return (Boolean)predicate.apply(arg0);
            }
        });
    }

    public static <T> Iterable<T> select(Iterable<T> source, Functions.Function1<? super T, ? extends Boolean> predicate) {
        return IterableExtensions.filter(source, predicate);
    }

    public static <T> Iterable<T> xselect(Iterable<T> source, Functions.Function1<? super T, ? extends Boolean> predicate) {
        return IterableExtensions.filter((Iterable)IterableExtensions.filterNull(source), predicate);
    }

    public static <T, R> Iterable<R> collectOne(Iterable<T> source, Functions.Function1<? super T, ? extends R> transformation) {
        return IterableExtensions.map(source, transformation);
    }

    public static <T, R> Iterable<R> xcollectOne(Iterable<T> source, Functions.Function1<? super T, ? extends R> transformation) {
        return IterableExtensions.filterNull((Iterable)IterableExtensions.map(source, transformation));
    }

    public static <T, R> Iterable<R> collect(Iterable<T> source, Functions.Function1<? super T, ? extends Iterable<? extends R>> transformation) {
        return Iterables.concat((Iterable)IterableExtensions.map(source, transformation));
    }

    public static <T, R> Iterable<R> xcollect(Iterable<T> source, Functions.Function1<? super T, ? extends Iterable<? extends R>> transformation) {
        return IterableExtensions.filterNull((Iterable)Iterables.concat((Iterable)IterableExtensions.map(source, transformation)));
    }

    public static <T> Iterable<T> objectsOfKind(Iterable<?> source, Class<T> type) {
        return Iterables.filter(source, type);
    }

    public static <T> Iterable<T> asType(Iterable<?> source, Class<T> type) {
        Functions.Function1 _function = it -> it;
        return IterableExtensions.map(source, (Functions.Function1)_function);
    }

    public static <T> Iterable<T> union(Iterable<? extends T> source, Iterable<? extends T> other) {
        return Iterables.concat(Arrays.asList(source, other));
    }

    public static <T> Iterable<T> union(Iterable<? extends T> source, T ... other) {
        return Iterables.concat(Arrays.asList(source, Arrays.asList(other)));
    }

    public static <T> Iterable<T> excluding(Iterable<T> iterable, Iterable<?> excludes) {
        Functions.Function1 _function = it -> Queries.includes(excludes, it);
        return IterableExtensions.reject(iterable, (Functions.Function1)_function);
    }

    @SafeVarargs
    public static <T> Iterable<T> excluding(Iterable<T> iterable, Object ... excludes) {
        return Queries.excluding(iterable, IterableUtil.asList((Object[])excludes));
    }

    public static <T> Iterable<T> unique(Iterable<T> source) {
        return Queries.unique(source, true);
    }

    public static <T> Iterable<T> unique(Iterable<T> source, boolean useEquals) {
        return new UniqueIterable(source, useEquals);
    }

    public static <L, R> Iterable<Pair<L, R>> product(Iterable<L> left, Iterable<R> right) {
        Functions.Function1 _function = l -> {
            Functions.Function1 _function_1 = r -> Pair.of((Object)l, (Object)r);
            return IterableExtensions.map((Iterable)right, (Functions.Function1)_function_1);
        };
        return Iterables.concat((Iterable)IterableExtensions.map(left, (Functions.Function1)_function));
    }

    public static <T> Iterable<Pair<T, T>> product(Iterable<T> source) {
        Functions.Function1 _function = l -> {
            Functions.Function1 _function_1 = it -> it == l;
            Functions.Function1 _function_2 = r -> Pair.of((Object)l, (Object)r);
            return IterableExtensions.map(Queries.after(source, _function_1), (Functions.Function1)_function_2);
        };
        return Iterables.concat((Iterable)IterableExtensions.map(source, (Functions.Function1)_function));
    }

    public static <T> boolean includes(Iterable<T> source, Object item) {
        return Iterables.contains(source, (Object)item);
    }

    public static <T> boolean excludes(Iterable<T> source, Object item) {
        boolean _contains = Iterables.contains(source, (Object)item);
        return !_contains;
    }

    public static boolean containsDuplicates(Iterable<?> source) {
        HashSet set = CollectionLiterals.newHashSet();
        Functions.Function1 _function = e -> set.add(e);
        boolean _forall = IterableExtensions.forall(source, (Functions.Function1)_function);
        return !_forall;
    }

    public static <T extends Comparable<? super T>> T max(Iterable<T> source, T _default) {
        Comparable _xifexpression = null;
        boolean _isEmpty = IterableExtensions.isEmpty(source);
        _xifexpression = _isEmpty ? (Comparable)_default : IterableExtensions.max(source);
        return (T)_xifexpression;
    }

    public static <T extends Comparable<? super T>> T min(Iterable<T> source, T _default) {
        Comparable _xifexpression = null;
        boolean _isEmpty = IterableExtensions.isEmpty(source);
        _xifexpression = _isEmpty ? (Comparable)_default : IterableExtensions.min(source);
        return (T)_xifexpression;
    }

    public static <T> Iterable<T> after(Iterable<T> source, Functions.Function1<? super T, ? extends Boolean> predicate) {
        Functions.Function1 _function = it -> {
            Boolean _apply = (Boolean)predicate.apply(it);
            return _apply == false;
        };
        return IterableExtensions.drop((Iterable)IterableExtensions.dropWhile(source, (Functions.Function1)_function), (int)1);
    }

    public static <T> Iterable<T> before(Iterable<T> source, Functions.Function1<? super T, ? extends Boolean> predicate) {
        Functions.Function1 _function = it -> {
            Boolean _apply = (Boolean)predicate.apply(it);
            return _apply == false;
        };
        return IterableExtensions.takeWhile(source, (Functions.Function1)_function);
    }

    public static <T> Iterable<T> symmetricHead(final Iterable<T> left, final Iterable<?> right) {
        return new LoggableIterable<T>(){

            public Iterator<T> iterator() {
                abstract class ____Queries_1
                extends ProcessingIterator<T> {
                    Iterator<T> iLeft;
                    Iterator<?> iRight;

                    ____Queries_1() {
                    }
                }
                return new ____Queries_1(this, left, right){
                    {
                        this.iLeft = iterable.iterator();
                        this.iRight = iterable2.iterator();
                    }

                    protected boolean toNext() {
                        if (!this.iLeft.hasNext() || !this.iRight.hasNext()) {
                            return this.done();
                        }
                        Object lNext = this.iLeft.next();
                        Object rNext = this.iRight.next();
                        boolean _xifexpression = false;
                        boolean _equals = Objects.equals(lNext, rNext);
                        _xifexpression = _equals ? this.setNext(lNext) : this.done();
                        return _xifexpression;
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> symmetricHead(final Iterable<T> left, final Iterable<?> right, boolean useEquals) {
        if (useEquals) {
            return Queries.symmetricHead(left, right);
        }
        return new LoggableIterable<T>(){

            public Iterator<T> iterator() {
                abstract class ____Queries_1
                extends ProcessingIterator<T> {
                    Iterator<T> iLeft;
                    Iterator<?> iRight;

                    ____Queries_1() {
                    }
                }
                return new ____Queries_1(this, left, right){
                    {
                        this.iLeft = iterable.iterator();
                        this.iRight = iterable2.iterator();
                    }

                    protected boolean toNext() {
                        if (!this.iLeft.hasNext() || !this.iRight.hasNext()) {
                            return this.done();
                        }
                        Object lNext = this.iLeft.next();
                        Object rNext = this.iRight.next();
                        boolean _xifexpression = false;
                        _xifexpression = lNext == rNext ? this.setNext(lNext) : this.done();
                        return _xifexpression;
                    }
                };
            }
        };
    }

    public static <T, U extends Comparable<? super U>> List<T> sortedBy(Iterable<T> input, Functions.Function1<? super T, ? extends U> function) {
        Comparator _function = ($0, $1) -> $0.compareTo($1);
        return Queries.sortedBy(input, function, _function);
    }

    public static <T, U> List<T> sortedBy(Iterable<T> input, Functions.Function1<? super T, ? extends U> function, Comparator<? super U> comparator) {
        List result = IterableExtensions.toList(input);
        Comparator _function = ($0, $1) -> comparator.compare((Object)function.apply($0), (Object)function.apply($1));
        Collections.sort(result, _function);
        return result;
    }

    public static <T> List<T> reverse(Iterable<T> source) {
        return ListExtensions.reverse((List)IterableExtensions.toList(source));
    }

    public static <T> LinkedHashSet<T> toOrderedSet(Iterable<T> source) {
        LinkedHashSet result = CollectionLiterals.newLinkedHashSet();
        Iterables.addAll((Collection)result, source);
        return result;
    }

    public static <T, K, V> Map<K, List<V>> groupBy(Iterable<? extends T> source, Functions.Function1<? super T, ? extends K> computeKeys, Functions.Function1<? super T, ? extends V> computeValues) {
        if (computeKeys == null) {
            throw new NullPointerException("computeKeys");
        }
        if (computeValues == null) {
            throw new NullPointerException("computeValues");
        }
        LinkedHashMap result = CollectionLiterals.newLinkedHashMap();
        for (T element : source) {
            Object key = computeKeys.apply(element);
            Object value = computeValues.apply(element);
            Function<Object, List> _function = it -> CollectionLiterals.newArrayList();
            List _computeIfAbsent = result.computeIfAbsent(key, _function);
            _computeIfAbsent.add(value);
        }
        return result;
    }

    public static <T> List<List<T>> groupBy(Iterable<T> iterable, final Functions.Function2<? super T, ? super T, ? extends Boolean> equivalence) {
        return IterableQueries.groupBy(iterable, (BiPredicate)new BiPredicate<T, T>(){

            @Override
            public boolean test(T arg0, T arg1) {
                return (Boolean)equivalence.apply(arg0, arg1);
            }
        });
    }

    public static <T> List<List<T>> groupBy(Iterable<T> iterable, Comparator<? super List<T>> comparator, final Functions.Function2<? super T, ? super T, ? extends Boolean> equivalence) {
        return IterableQueries.groupBy(iterable, comparator, (BiPredicate)new BiPredicate<T, T>(){

            @Override
            public boolean test(T arg0, T arg1) {
                return (Boolean)equivalence.apply(arg0, arg1);
            }
        });
    }

    public static <K, V> Map.Entry<K, V> removeFirst(Map<K, V> map, Functions.Function2<? super K, ? super V, ? extends Boolean> predicate) {
        Functions.Function1 _function = it -> (Boolean)predicate.apply(it.getKey(), it.getValue());
        return Queries.removeFirst(map.entrySet(), _function);
    }

    public static <T> T removeFirst(Iterable<T> iterable, Functions.Function1<? super T, ? extends Boolean> predicate) {
        return Queries.removeFirst(iterable.iterator(), predicate);
    }

    public static <T> T removeFirst(Iterator<T> iterator, Functions.Function1<? super T, ? extends Boolean> predicate) {
        Object result = IteratorExtensions.findFirst(iterator, predicate);
        if (result != null) {
            iterator.remove();
        }
        return (T)result;
    }

    public static <T> Iterable<List<T>> segment(Iterable<T> iterable, final Functions.Function2<? super T, ? super T, ? extends Boolean> predicate) {
        return IterableQueries.segment(iterable, (BiPredicate)new BiPredicate<T, T>(){

            @Override
            public boolean test(T arg0, T arg1) {
                return (Boolean)predicate.apply(arg0, arg1);
            }
        });
    }

    public static void main(String[] args) {
        InputOutput.println(Queries.product(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"a", "b", "c"})), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{1, 2, 3}))));
        InputOutput.println(Queries.product(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"a", "b", "c"}))));
        InputOutput.println(Queries.symmetricHead(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"a", "b", "c"})), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{"a", "b", "d"}))));
        InputOutput.println(Queries.symmetricHead(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"a", "b", "c"})), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{1, 2, 3}))));
        Functions.Function1 _function = it -> Objects.equals(it, "c");
        InputOutput.println(Queries.reverse(Queries.after(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{"a", "b", "c", "d", 5})), _function)));
        Functions.Function1 _function_1 = it -> Objects.equals(it, "c");
        InputOutput.println(Queries.reverse(Queries.before(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{"a", "b", "c", "d", 5})), _function_1)));
    }
}

