/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.TupleFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.trace.EDirectionKind;
import org.eclipse.m2m.internal.qvt.oml.trace.EMappingContext;
import org.eclipse.m2m.internal.qvt.oml.trace.EMappingOperation;
import org.eclipse.m2m.internal.qvt.oml.trace.EMappingParameters;
import org.eclipse.m2m.internal.qvt.oml.trace.EMappingResults;
import org.eclipse.m2m.internal.qvt.oml.trace.ETuplePartValue;
import org.eclipse.m2m.internal.qvt.oml.trace.EValue;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.internal.qvt.oml.trace.TraceFactory;
import org.eclipse.m2m.internal.qvt.oml.trace.TraceRecord;
import org.eclipse.m2m.internal.qvt.oml.trace.VarParameterValue;
import org.eclipse.m2m.qvt.oml.util.Dictionary;
import org.eclipse.m2m.qvt.oml.util.MutableList;
import org.eclipse.m2m.qvt.oml.util.Utils;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.util.Bag;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.PredefinedType;

public class TraceUtil {
    private TraceUtil() {
    }

    static TraceRecord getTraceRecord(QvtOperationalEvaluationEnv evalEnv, MappingOperation mappingOperation) {
        InternalEvaluationEnv internEnv = evalEnv.getAdapter(InternalEvaluationEnv.class);
        Trace trace = internEnv.getTraces();
        Object selfObj = evalEnv.getValueOf("self");
        Object key = TraceUtil.createKey(selfObj, evalEnv, mappingOperation);
        if (key != null) {
            TraceRecord record = trace.getRecordBySource(mappingOperation, key);
            if (record != null && Boolean.TRUE.equals(TraceUtil.checkResultMatch(record, evalEnv))) {
                return record;
            }
            return null;
        }
        return TraceUtil.getTraceRecordDefault(evalEnv, mappingOperation);
    }

    private static TraceRecord getTraceRecordDefault(QvtOperationalEvaluationEnv evalEnv, MappingOperation mappingOperation) {
        InternalEvaluationEnv internEnv = evalEnv.getAdapter(InternalEvaluationEnv.class);
        Trace trace = internEnv.getTraces();
        Object selfObj = evalEnv.getValueOf("self");
        if (selfObj != null && TraceUtil.isParameterLessContextual(mappingOperation)) {
            TraceRecord record = trace.getRecordBySource(mappingOperation, selfObj);
            if (record != null && Boolean.TRUE.equals(TraceUtil.checkResultMatch(record, evalEnv))) {
                return record;
            }
            return null;
        }
        EMap<MappingOperation, EList<TraceRecord>> allTraceRecordMap = trace.getTraceRecordMap();
        EList traceRecords = (EList)allTraceRecordMap.get((Object)mappingOperation);
        if (traceRecords == null) {
            return null;
        }
        block0: for (TraceRecord nextRecord : traceRecords) {
            VarParameterValue nextContext;
            if (QvtOperationalParserUtil.isContextual(mappingOperation) && ((nextContext = nextRecord.getContext().getContext()) == null || !TraceUtil.isOclEqual(selfObj, nextContext.getValue().getOclObject(), mappingOperation.getContext().getKind(), evalEnv))) continue;
            int candidateParamSize = mappingOperation.getEParameters().size();
            if (nextRecord.getParameters().getParameters().size() != candidateParamSize) continue;
            int i = 0;
            while (i < candidateParamSize) {
                EParameter param = (EParameter)mappingOperation.getEParameters().get(i);
                Object paramValue = evalEnv.getValueOf(param.getName());
                VarParameterValue traceParamVal = (VarParameterValue)nextRecord.getParameters().getParameters().get(i);
                DirectionKind paramKind = DirectionKind.IN;
                if (param instanceof VarParameter) {
                    paramKind = ((VarParameter)param).getKind();
                }
                if (paramKind != DirectionKind.OUT && !TraceUtil.isOclEqual(paramValue, traceParamVal.getValue().getOclObject(), paramKind, evalEnv)) continue block0;
                ++i;
            }
            Boolean checkResult = TraceUtil.checkResultMatch(nextRecord, evalEnv);
            if (checkResult == null || Boolean.FALSE.equals(checkResult)) continue;
            return nextRecord;
        }
        return null;
    }

    static TraceRecord addTraceRecord(QvtOperationalEvaluationEnv evalEnv, MappingOperation mappingOperation) {
        TraceRecord traceRecord = TraceFactory.eINSTANCE.createTraceRecord();
        InternalEvaluationEnv internEnv = evalEnv.getAdapter(InternalEvaluationEnv.class);
        Trace trace = internEnv.getTraces();
        EList<TraceRecord> allRecList = TraceUtil.createOrGetListElementFromMap(trace.getTraceRecordMap(), mappingOperation);
        TraceUtil.addUnique(traceRecord, allRecList);
        EMappingOperation eMappingOperation = TraceFactory.eINSTANCE.createEMappingOperation();
        traceRecord.setMappingOperation(eMappingOperation);
        eMappingOperation.setName(mappingOperation.getName());
        Module module = QvtOperationalParserUtil.getOwningModule(mappingOperation);
        eMappingOperation.setPackage(module.getNsPrefix());
        eMappingOperation.setModule(module.getName());
        eMappingOperation.setRuntimeMappingOperation(mappingOperation);
        EMappingContext eMappingContext = TraceFactory.eINSTANCE.createEMappingContext();
        traceRecord.setContext(eMappingContext);
        if (QvtOperationalParserUtil.isContextual(mappingOperation)) {
            VarParameter operContext = mappingOperation.getContext();
            VarParameterValue contextVPV = TraceUtil.createVarParameterValue(mappingOperation, operContext.getKind(), operContext.getEType(), "self", evalEnv);
            eMappingContext.setContext(contextVPV);
            EList<TraceRecord> contextMappings = TraceUtil.createOrGetListElementFromMap(trace.getSourceToTraceRecordMap(), contextVPV.getValue().getOclObject());
            TraceUtil.addUnique(traceRecord, contextMappings);
        } else {
            for (EParameter nextEParam : mappingOperation.getEParameters()) {
                Object firstInVarParam;
                if (!(nextEParam instanceof VarParameter) || (firstInVarParam = (VarParameter)nextEParam).getEType() instanceof PredefinedType || firstInVarParam.getKind() != DirectionKind.IN && firstInVarParam.getKind() != DirectionKind.INOUT) continue;
                Object val = TraceUtil.createVarParameterValue(mappingOperation, firstInVarParam.getKind(), firstInVarParam.getEType(), firstInVarParam.getName(), evalEnv).getValue().getOclObject();
                EList<TraceRecord> sourceMappings = TraceUtil.createOrGetListElementFromMap(trace.getSourceToTraceRecordMap(), val);
                TraceUtil.addUnique(traceRecord, sourceMappings);
                break;
            }
        }
        EMappingParameters eMappingParameters = TraceFactory.eINSTANCE.createEMappingParameters();
        traceRecord.setParameters(eMappingParameters);
        for (EParameter param : mappingOperation.getEParameters()) {
            VarParameter varParameter = (VarParameter)param;
            VarParameterValue paramVPV = TraceUtil.createVarParameterValue(mappingOperation, varParameter.getKind(), varParameter.getEType(), varParameter.getName(), evalEnv);
            eMappingParameters.getParameters().add((Object)paramVPV);
        }
        EMappingResults eMappingResults = TraceFactory.eINSTANCE.createEMappingResults();
        traceRecord.setResult(eMappingResults);
        EList<VarParameter> results = mappingOperation.getResult();
        if (!results.isEmpty()) {
            String resultVarName = results.size() == 1 ? ((VarParameter)results.get(0)).getName() : "result";
            EClassifier resultElementType = results.size() == 1 ? ((VarParameter)results.get(0)).getEType() : mappingOperation.getEType();
            VarParameterValue resultVPV = TraceUtil.createVarParameterValue(mappingOperation, DirectionKind.OUT, resultElementType, resultVarName, evalEnv);
            eMappingResults.getResult().add((Object)resultVPV);
            EList<TraceRecord> resultMappings = TraceUtil.createOrGetListElementFromMap(trace.getTargetToTraceRecordMap(), resultVPV.getValue().getOclObject());
            TraceUtil.addUnique(traceRecord, resultMappings);
        }
        TraceUtil.addUnique(traceRecord, trace.getTraceRecords());
        TraceUtil.addTraceRecordByMapping(mappingOperation, traceRecord, trace);
        return traceRecord;
    }

    private static void addTraceRecordByMapping(MappingOperation mappingOperation, TraceRecord traceRecord, Trace trace) {
        Object key;
        Object selfObj = null;
        if (traceRecord.getContext() != null && traceRecord.getContext().getContext() != null) {
            EValue value = traceRecord.getContext().getContext().getValue();
            selfObj = value.getOclObject();
        }
        if ((key = TraceUtil.createKey(selfObj, traceRecord)) != null) {
            trace.addRecordBySource(key, mappingOperation, traceRecord);
        }
    }

    private static Object createKey(Object selfObj, QvtOperationalEvaluationEnv evalEnv, MappingOperation mappingOperation) {
        EList eParameters = mappingOperation.getEParameters();
        if (eParameters.isEmpty()) {
            return selfObj;
        }
        ArrayList<Object> key = new ArrayList<Object>(eParameters.size() + 1);
        key.add(selfObj);
        for (EParameter param : eParameters) {
            VarParameter varParam = (VarParameter)param;
            if (varParam.getKind() == DirectionKind.OUT) continue;
            key.add(evalEnv.getValueOf(param.getName()));
        }
        return key;
    }

    private static Object createKey(Object selfObj, TraceRecord traceRecord) {
        EList<VarParameterValue> eParameters = traceRecord.getParameters().getParameters();
        if (eParameters.isEmpty()) {
            return selfObj;
        }
        ArrayList<Object> key = new ArrayList<Object>(eParameters.size() + 1);
        key.add(selfObj);
        for (VarParameterValue param : eParameters) {
            if (param.getKind() == EDirectionKind.OUT) continue;
            key.add(param.getValue().getOclObject());
        }
        return key;
    }

    static Object fetchResultFromTrace(QvtOperationalEvaluationEnv evalEnv, TraceRecord record) {
        MappingOperation operation = record.getMappingOperation().getRuntimeMappingOperation();
        if (operation.getResult().isEmpty()) {
            return null;
        }
        ListIterator<Object> itArgument = evalEnv.getOperationArgs().listIterator();
        Iterator itValues = record.getParameters().getParameters().iterator();
        while (itArgument.hasNext()) {
            VarParameterValue param = (VarParameterValue)itValues.next();
            itArgument.next();
            if (param.getKind() != EDirectionKind.OUT) continue;
            itArgument.set(param.getValue().getOclObject());
        }
        EList<VarParameterValue> traceResult = record.getResult().getResult();
        assert (traceResult.size() == 1);
        return ((VarParameterValue)traceResult.get(0)).getValue().getOclObject();
    }

    private static VarParameterValue createVarParameterValue(MappingOperation mappingOperation, DirectionKind kind, EClassifier type, String name, QvtOperationalEvaluationEnv evalEnv) {
        VarParameterValue varParameterValue = TraceFactory.eINSTANCE.createVarParameterValue();
        varParameterValue.setKind(TraceUtil.getDirectionKind(kind));
        varParameterValue.setName(name);
        varParameterValue.setType(type.getName());
        Object oclObject = evalEnv.getValueOf(name);
        varParameterValue.setValue(TraceUtil.createEValue(oclObject, kind));
        return varParameterValue;
    }

    @Deprecated
    public static EValue createEValue(Object oclObject) {
        return TraceUtil.createEValue(oclObject, DirectionKind.IN);
    }

    public static EValue createEValue(Object oclObject, DirectionKind kind) {
        EValue value = TraceFactory.eINSTANCE.createEValue();
        value.setOclObject(TraceUtil.cloneOclObject(oclObject, kind));
        if (oclObject != null) {
            if (oclObject instanceof Dictionary) {
                Dictionary dict = (Dictionary)oclObject;
                value.setCollectionType("Dictionary");
                for (Object dictKey : dict.keys()) {
                    ETuplePartValue tuplePartValue = TraceFactory.eINSTANCE.createETuplePartValue();
                    tuplePartValue.setName("key");
                    tuplePartValue.setValue(TraceUtil.createEValue(dictKey, kind));
                    value.getCollection().add((Object)tuplePartValue);
                    Object dictValue = dict.get(dictKey);
                    tuplePartValue = TraceFactory.eINSTANCE.createETuplePartValue();
                    tuplePartValue.setName("value");
                    tuplePartValue.setValue(TraceUtil.createEValue(dictValue, kind));
                    value.getCollection().add((Object)tuplePartValue);
                }
            } else if (oclObject instanceof Tuple) {
                Tuple tuple = (Tuple)oclObject;
                value.setCollectionType("Tuple");
                TupleType tupleType = tuple.getTupleType();
                for (EStructuralFeature part : tupleType.oclProperties()) {
                    Object partValue = tuple.getValue((Object)part);
                    ETuplePartValue tuplePartValue = TraceFactory.eINSTANCE.createETuplePartValue();
                    tuplePartValue.setName(part.getName());
                    EValue partEValue = TraceUtil.createEValue(partValue, kind);
                    tuplePartValue.setValue(partEValue);
                    value.getCollection().add((Object)tuplePartValue);
                }
            } else if (oclObject instanceof Collection) {
                Collection oclCollection = (Collection)oclObject;
                value.setCollectionType(TraceUtil.getCollectionTypeName(oclCollection));
                for (Object collectionElement : oclCollection) {
                    value.getCollection().add((Object)TraceUtil.createEValue(collectionElement, kind));
                }
            } else if (oclObject instanceof ModelInstance) {
                value.setCollectionType("ModelType");
                for (EObject collectionElement : ((ModelInstance)oclObject).getExtent().getInitialObjects()) {
                    value.getCollection().add((Object)TraceUtil.createEValue(collectionElement, kind));
                }
            } else if (oclObject instanceof EObject) {
                value.setModelElement((EObject)oclObject);
            } else if (oclObject != null) {
                value.setPrimitiveValue(oclObject.toString());
                value.setCollectionType(TraceUtil.getPrimitiveTypeName(oclObject));
            }
        }
        return value;
    }

    private static String getCollectionTypeName(Collection<?> c) {
        String result = "Collection";
        if (c instanceof MutableList) {
            result = "List";
        } else if (c instanceof Dictionary) {
            result = "Dictionary";
        } else if (c instanceof Bag) {
            result = "Bag";
        } else if (c instanceof LinkedHashSet) {
            result = "OrderedSet";
        } else if (c instanceof Set) {
            result = "Set";
        } else if (c instanceof ArrayList) {
            result = "Sequence";
        }
        return result;
    }

    private static String getPrimitiveTypeName(Object o) {
        if (o instanceof Boolean) {
            return "Boolean";
        }
        if (o instanceof Integer) {
            return "Integer";
        }
        if (o instanceof Double) {
            return "Real";
        }
        if (o instanceof String) {
            return "String";
        }
        return null;
    }

    private static Object cloneOclObject(Object obj, DirectionKind kind) {
        return TraceUtil.cloneOclObjectRec(obj, new IdentityHashMap<Object, Object>(), kind);
    }

    private static Object cloneOclObjectRec(Object obj, Map<Object, Object> processed, DirectionKind kind) {
        if (kind == DirectionKind.IN && obj instanceof MutableList) {
            if (processed.containsKey(obj)) {
                return processed.get(obj);
            }
            MutableList original = (MutableList)obj;
            MutableList result = Utils.createList();
            processed.put(obj, result);
            for (Object o : original) {
                result.add(TraceUtil.cloneOclObjectRec(o, processed, kind));
            }
            return result;
        }
        if (kind == DirectionKind.IN && obj instanceof Dictionary) {
            if (processed.containsKey(obj)) {
                return processed.get(obj);
            }
            Dictionary original = (Dictionary)obj;
            Dictionary<Object, Object> result = Utils.createDictionary();
            processed.put(obj, result);
            for (Object k : original.keys()) {
                result.put(TraceUtil.cloneOclObjectRec(k, processed, kind), TraceUtil.cloneOclObjectRec(original.get(k), processed, kind));
            }
            return result;
        }
        return obj;
    }

    private static EDirectionKind getDirectionKind(DirectionKind kind) {
        if (kind == DirectionKind.IN) {
            return EDirectionKind.IN;
        }
        if (kind == DirectionKind.INOUT) {
            return EDirectionKind.INOUT;
        }
        if (kind == DirectionKind.OUT) {
            return EDirectionKind.OUT;
        }
        throw new RuntimeException("Wrong DirectionKind: " + kind.name());
    }

    private static <K, T> EList<T> createOrGetListElementFromMap(EMap<K, EList<T>> map, K key) {
        EList list = (EList)map.get(key);
        if (list == null) {
            list = new BasicEList();
            map.put(key, (Object)list);
            list = (EList)map.get(key);
        }
        return list;
    }

    private static boolean isOclEqual(Object candidateObject, Object traceObject, DirectionKind directionKind, QvtOperationalEvaluationEnv evalEnv) {
        if (directionKind == DirectionKind.OUT && candidateObject == null) {
            return true;
        }
        if (candidateObject == traceObject) {
            return true;
        }
        if (QvtOperationalUtil.isUndefined(candidateObject, evalEnv)) {
            return QvtOperationalUtil.isUndefined(traceObject, evalEnv);
        }
        if (candidateObject == null || traceObject == null) {
            return false;
        }
        return candidateObject.equals(traceObject);
    }

    private static Boolean checkResultMatch(TraceRecord nextRecord, QvtOperationalEvaluationEnv evalEnv) {
        Object resultValue = evalEnv.getValueOf("result");
        if (resultValue != null) {
            ArrayList<Object> resultValues = new ArrayList<Object>(1);
            resultValues.add(resultValue);
            if (nextRecord.getResult().getResult().size() != resultValues.size()) {
                return null;
            }
            int i = 0;
            int n = resultValues.size();
            while (i < n) {
                VarParameterValue traceParamVal;
                Object paramValue = resultValues.get(i);
                if (!TraceUtil.isOclEqual(paramValue, (traceParamVal = (VarParameterValue)nextRecord.getResult().getResult().get(i)).getValue().getOclObject(), DirectionKind.OUT, evalEnv)) {
                    return Boolean.FALSE;
                }
                ++i;
            }
        }
        return Boolean.TRUE;
    }

    private static boolean isParameterLessContextual(MappingOperation mappingOperation) {
        return QvtOperationalParserUtil.isContextual(mappingOperation) && mappingOperation.getEParameters().isEmpty();
    }

    private static void addUnique(TraceRecord record, EList<TraceRecord> recordList) {
        if (recordList instanceof AbstractEList) {
            AbstractEList basicRecList = (AbstractEList)recordList;
            basicRecList.addUnique((Object)record);
        } else {
            recordList.add((Object)record);
        }
    }

    static TraceRecord getIncrementalTraceRecord(QvtOperationalEvaluationEnv evalEnv, QvtOperationalEnv env, MappingOperation mappingOperation) {
        List<EObject> traceContent = evalEnv.getContext().getTrace().getTraceContent();
        if (traceContent.isEmpty()) {
            return null;
        }
        Object selfObj = evalEnv.getValueOf("self");
        Object key = TraceUtil.createKey(selfObj, evalEnv, mappingOperation);
        if (key != null) {
            for (EObject o : traceContent) {
                TraceRecord record;
                if (!(o instanceof Trace) || (record = ((Trace)o).getRecordBySource(mappingOperation, key)) == null || !Boolean.TRUE.equals(TraceUtil.checkIncrementalResultMatch(env, record))) continue;
                return record;
            }
        }
        return null;
    }

    private static boolean checkIncrementalResultMatch(QvtOperationalEnv env, TraceRecord record) {
        MappingOperation operation = record.getMappingOperation().getRuntimeMappingOperation();
        Iterator itrRecordParams = record.getParameters().getParameters().iterator();
        for (EParameter param : operation.getEParameters()) {
            if (!itrRecordParams.hasNext()) {
                return false;
            }
            VarParameterValue recordParam = (VarParameterValue)itrRecordParams.next();
            if (recordParam.getType().equals(param.getEType().getName())) continue;
            return false;
        }
        if (operation.getResult().isEmpty()) {
            return true;
        }
        if (record.getResult().getResult().size() != 1) {
            return false;
        }
        VarParameterValue resultParam = (VarParameterValue)record.getResult().getResult().get(0);
        if (operation.getResult().size() == 1) {
            if (!resultParam.getType().equals(((VarParameter)operation.getResult().get(0)).getEType().getName())) {
                return false;
            }
        } else {
            EValue value = resultParam.getValue();
            if (!"Tuple".equals(value.getCollectionType())) {
                return false;
            }
            EClass resultType = (EClass)TraceUtil.createOclTypeFromValue(env, value);
            for (VarParameter param : operation.getResult()) {
                EStructuralFeature feature = resultType.getEStructuralFeature(param.getName());
                if (feature == null) {
                    return false;
                }
                if (param.getEType().getName().equals(feature.getEType().getName())) continue;
                return false;
            }
        }
        return true;
    }

    static void fetchIncrementalResultFromTrace(QvtOperationalEvaluationEnv evalEnv, TraceRecord record) {
        MappingOperation operation = record.getMappingOperation().getRuntimeMappingOperation();
        Iterator itParams = operation.getEParameters().iterator();
        for (VarParameterValue value : record.getParameters().getParameters()) {
            MappingParameter mappingParam = (MappingParameter)itParams.next();
            if (value.getKind() != EDirectionKind.OUT) continue;
            Object oclObject = value.getValue().getOclObject();
            if (oclObject != null) {
                evalEnv.replace(value.getName(), oclObject);
            }
            if (!(oclObject instanceof EObject)) continue;
            evalEnv.putInstanceToExtent((EObject)oclObject, mappingParam.getExtent());
        }
        if (operation.getResult().isEmpty()) {
            return;
        }
        EList<VarParameterValue> traceResult = record.getResult().getResult();
        assert (traceResult.size() == 1);
        if (operation.getResult().size() == 1) {
            Object oclObject = ((VarParameterValue)traceResult.get(0)).getValue().getOclObject();
            if (oclObject != null) {
                evalEnv.replace("result", oclObject);
            }
            if (oclObject instanceof EObject) {
                MappingParameter resultParam = (MappingParameter)operation.getResult().get(0);
                evalEnv.putInstanceToExtent((EObject)oclObject, resultParam.getExtent());
            }
        } else if (operation.getResult().size() > 1) {
            Tuple tuple = (Tuple)((VarParameterValue)traceResult.get(0)).getValue().getOclObject();
            Iterator itrResults = operation.getResult().iterator();
            TupleType tupleType = tuple.getTupleType();
            for (EStructuralFeature feature : tupleType.oclProperties()) {
                Object oclObject = tuple.getValue((Object)feature);
                if (oclObject != null) {
                    evalEnv.replace(feature.getName(), oclObject);
                }
                if (!(oclObject instanceof EObject)) continue;
                MappingParameter resultParam = (MappingParameter)itrResults.next();
                evalEnv.putInstanceToExtent((EObject)oclObject, resultParam.getExtent());
            }
        }
    }

    public static List<EObject> resolveTraces(QvtOperationalEnv env, Module qvtModule, List<EObject> traces) {
        if (traces.isEmpty()) {
            return traces;
        }
        ArrayList<EObject> result = new ArrayList<EObject>(traces.size());
        TreeMap<String, MappingOperation> mappings = null;
        for (EObject o : traces) {
            if (!(o instanceof Trace)) {
                result.add(o);
                continue;
            }
            Trace trace = (Trace)o;
            if (!trace.hasRecordsBySource() || TraceUtil.getTraceRootModule(trace) != qvtModule) {
                if (mappings == null) {
                    mappings = new TreeMap<String, MappingOperation>();
                    TraceUtil.fetchAllMappings(qvtModule, mappings);
                }
                TraceUtil.setTraceRootModule(trace, qvtModule);
                TraceUtil.processTrace(env, trace, mappings);
            }
            result.add(trace);
        }
        return result;
    }

    private static void processTrace(QvtOperationalEnv env, Trace trace, Map<String, MappingOperation> mappings) {
        trace.clearRecordsBySource();
        for (TraceRecord traceRecord : trace.getTraceRecords()) {
            EMappingOperation eMappingOperation = traceRecord.getMappingOperation();
            MappingOperation mappingOperation = mappings.get(TraceUtil.getMappingKey(eMappingOperation));
            eMappingOperation.setRuntimeMappingOperation(mappingOperation);
            if (mappingOperation == null) continue;
            if (traceRecord.getContext() != null && traceRecord.getContext().getContext() != null) {
                VarParameterValue value = traceRecord.getContext().getContext();
                value.getValue().setOclObject(TraceUtil.createOclObjectFromValue(env, value.getValue(), value.getKind()));
            }
            EList<VarParameterValue> eParameters = traceRecord.getParameters().getParameters();
            for (VarParameterValue param : eParameters) {
                param.getValue().setOclObject(TraceUtil.createOclObjectFromValue(env, param.getValue(), param.getKind()));
            }
            EList<VarParameterValue> eResults = traceRecord.getResult().getResult();
            for (VarParameterValue result : eResults) {
                result.getValue().setOclObject(TraceUtil.createOclObjectFromValue(env, result.getValue(), result.getKind()));
            }
            TraceUtil.addTraceRecordByMapping(mappingOperation, traceRecord, trace);
        }
    }

    private static Object createOclObjectFromValue(QvtOperationalEnv env, EValue value, EDirectionKind directionKind) {
        if (value.getModelElement() != null) {
            EObject modelElement = value.getModelElement();
            if (modelElement.eIsProxy()) {
                return null;
            }
            if (directionKind == EDirectionKind.OUT) {
                ((InternalEObject)modelElement).eSetResource(null, null);
            }
            return modelElement;
        }
        String type = value.getCollectionType();
        if (value.getPrimitiveValue() != null) {
            String primitiveValue = value.getPrimitiveValue();
            if ("String".equals(type)) {
                return primitiveValue;
            }
            if ("Boolean".equals(type)) {
                return Boolean.valueOf(primitiveValue);
            }
            if ("Integer".equals(type)) {
                return Integer.valueOf(primitiveValue);
            }
            if ("Real".equals(type)) {
                return Double.valueOf(primitiveValue);
            }
            if ("UnlimitedNatural".equals(type)) {
                return Integer.valueOf(primitiveValue);
            }
            assert (false) : "Unknown primitive type: " + type;
        }
        if ("Dictionary".equals(type)) {
            Dictionary<Object, Object> dict = Utils.createDictionary();
            Iterator itr = value.getCollection().iterator();
            while (itr.hasNext()) {
                ETuplePartValue key = (ETuplePartValue)itr.next();
                assert ("key".equals(key.getName()));
                ETuplePartValue val = (ETuplePartValue)itr.next();
                assert ("value".equals(val.getName()));
                dict.put(TraceUtil.createOclObjectFromValue(env, key.getValue(), directionKind), TraceUtil.createOclObjectFromValue(env, val.getValue(), directionKind));
            }
            return dict;
        }
        if ("Tuple".equals(type)) {
            ArrayList<Variable> parts = new ArrayList<Variable>(value.getCollection().size());
            for (EValue elem : value.getCollection()) {
                ETuplePartValue part = (ETuplePartValue)elem;
                Variable var = env.getOCLFactory().createVariable();
                var.setName(part.getName());
                var.setType((Object)TraceUtil.createOclTypeFromValue(env, part.getValue()));
                parts.add(var);
            }
            EClassifier tupleType = (EClassifier)env.getTypeResolver().resolve((EClassifier)env.getOCLFactory().createTupleType(parts));
            EObject tuple = TupleFactory.createTuple((EClass)tupleType);
            for (EValue elem : value.getCollection()) {
                ETuplePartValue part = (ETuplePartValue)elem;
                EStructuralFeature feature = tuple.eClass().getEStructuralFeature(part.getName());
                tuple.eSet(feature, TraceUtil.createOclObjectFromValue(env, part.getValue(), directionKind));
            }
            return tuple;
        }
        Object oclCollection = null;
        if ("List".equals(type)) {
            oclCollection = Utils.createList();
        } else if ("Bag".equals(type)) {
            oclCollection = CollectionUtil.createNewBag();
        } else if ("OrderedSet".equals(type)) {
            oclCollection = CollectionUtil.createNewOrderedSet();
        } else if ("Set".equals(type)) {
            oclCollection = CollectionUtil.createNewSet();
        } else if ("Sequence".equals(type)) {
            oclCollection = CollectionUtil.createNewSequence();
        }
        if (oclCollection != null) {
            for (EValue elem : value.getCollection()) {
                oclCollection.add(TraceUtil.createOclObjectFromValue(env, elem, directionKind));
            }
            return oclCollection;
        }
        assert (false) : "Unsupported type: " + type;
        return null;
    }

    private static EClassifier createOclTypeFromValue(QvtOperationalEnv env, EValue value) {
        if (value.getModelElement() != null) {
            return value.getModelElement().eClass();
        }
        String type = value.getCollectionType();
        if (value.getPrimitiveValue() != null) {
            if ("String".equals(type)) {
                return (EClassifier)env.getOCLStandardLibrary().getString();
            }
            if ("Boolean".equals(type)) {
                return (EClassifier)env.getOCLStandardLibrary().getBoolean();
            }
            if ("Integer".equals(type)) {
                return (EClassifier)env.getOCLStandardLibrary().getInteger();
            }
            if ("Real".equals(type)) {
                return (EClassifier)env.getOCLStandardLibrary().getReal();
            }
            if ("UnlimitedNatural".equals(type)) {
                return (EClassifier)env.getOCLStandardLibrary().getUnlimitedNatural();
            }
            assert (false) : "Unknown primitive type: " + type;
        }
        if ("Dictionary".equals(type)) {
            if (value.getCollection().isEmpty()) {
                return env.getQVTStandardLibrary().getDictionary();
            }
            Iterator itr = value.getCollection().iterator();
            if (itr.hasNext()) {
                ETuplePartValue key = (ETuplePartValue)itr.next();
                assert ("key".equals(key.getName()));
                ETuplePartValue val = (ETuplePartValue)itr.next();
                assert ("value".equals(val.getName()));
                return env.getTypeResolver().resolveDictionaryType(TraceUtil.createOclTypeFromValue(env, key.getValue()), TraceUtil.createOclTypeFromValue(env, val.getValue()));
            }
        }
        if ("Tuple".equals(type)) {
            ArrayList<Variable> parts = new ArrayList<Variable>(value.getCollection().size());
            for (EValue elem : value.getCollection()) {
                ETuplePartValue part = (ETuplePartValue)elem;
                Variable var = env.getOCLFactory().createVariable();
                var.setName(part.getName());
                var.setType((Object)TraceUtil.createOclTypeFromValue(env, part.getValue()));
                parts.add(var);
            }
            return (EClassifier)env.getTypeResolver().resolve((EClassifier)env.getOCLFactory().createTupleType(parts));
        }
        if ("List".equals(type)) {
            if (value.getCollection().isEmpty()) {
                return env.getQVTStandardLibrary().getList();
            }
            return env.getTypeResolver().resolveListType(TraceUtil.createOclTypeFromValue(env, (EValue)value.getCollection().iterator().next()));
        }
        if ("Bag".equals(type)) {
            if (value.getCollection().isEmpty()) {
                return (EClassifier)env.getOCLStandardLibrary().getBag();
            }
            return (EClassifier)TypeUtil.resolveBagType((Environment)env, (Object)TraceUtil.createOclTypeFromValue(env, (EValue)value.getCollection().iterator().next()));
        }
        if ("OrderedSet".equals(type)) {
            if (value.getCollection().isEmpty()) {
                return (EClassifier)env.getOCLStandardLibrary().getOrderedSet();
            }
            return (EClassifier)TypeUtil.resolveOrderedSetType((Environment)env, (Object)TraceUtil.createOclTypeFromValue(env, (EValue)value.getCollection().iterator().next()));
        }
        if ("Set".equals(type)) {
            if (value.getCollection().isEmpty()) {
                return (EClassifier)env.getOCLStandardLibrary().getSet();
            }
            return (EClassifier)TypeUtil.resolveSetType((Environment)env, (Object)TraceUtil.createOclTypeFromValue(env, (EValue)value.getCollection().iterator().next()));
        }
        if ("Sequence".equals(type)) {
            if (value.getCollection().isEmpty()) {
                return (EClassifier)env.getOCLStandardLibrary().getSequence();
            }
            return (EClassifier)TypeUtil.resolveSequenceType((Environment)env, (Object)TraceUtil.createOclTypeFromValue(env, (EValue)value.getCollection().iterator().next()));
        }
        assert (false) : "Unsupported type: " + type;
        return null;
    }

    private static void fetchAllMappings(Module qvtModule, Map<String, MappingOperation> mappings) {
        for (EOperation op : qvtModule.getEOperations()) {
            if (!(op instanceof MappingOperation)) continue;
            MappingOperation mappingOperation = (MappingOperation)op;
            mappings.put(TraceUtil.getMappingKey(mappingOperation), mappingOperation);
        }
        for (ModuleImport mi : qvtModule.getModuleImport()) {
            TraceUtil.fetchAllMappings(mi.getImportedModule(), mappings);
        }
    }

    private static String getMappingKey(MappingOperation mappingOperation) {
        String result = mappingOperation.getName();
        result = String.valueOf(result) + '#';
        Module module = QvtOperationalParserUtil.getOwningModule(mappingOperation);
        result = String.valueOf(result) + module.getNsPrefix();
        result = String.valueOf(result) + '#';
        result = String.valueOf(result) + module.getName();
        return result;
    }

    private static String getMappingKey(EMappingOperation eMappingOperation) {
        String result = eMappingOperation.getName();
        result = String.valueOf(result) + '#';
        result = String.valueOf(result) + eMappingOperation.getPackage();
        result = String.valueOf(result) + '#';
        result = String.valueOf(result) + eMappingOperation.getModule();
        return result;
    }

    public static void setTraceRootModule(QvtOperationalEvaluationEnv evalEnv, Module module) {
        InternalEvaluationEnv internEnv = evalEnv.getAdapter(InternalEvaluationEnv.class);
        Trace trace = internEnv.getTraces();
        TraceUtil.setTraceRootModule(trace, module);
    }

    private static void setTraceRootModule(Trace trace, Module module) {
        Adapter adapter = EcoreUtil.getAdapter((List)trace.eAdapters(), TraceModuleAdapter.class);
        if (adapter != null) {
            trace.eAdapters().remove((Object)adapter);
        }
        trace.eAdapters().add((Object)new TraceModuleAdapter(module));
    }

    private static Module getTraceRootModule(Trace trace) {
        Adapter adapter = EcoreUtil.getAdapter((List)trace.eAdapters(), TraceModuleAdapter.class);
        if (adapter instanceof TraceModuleAdapter) {
            return ((TraceModuleAdapter)adapter).getModule();
        }
        return null;
    }

    private static class TraceModuleAdapter
    extends AdapterImpl {
        private final Module fModule;

        TraceModuleAdapter(Module module) {
            assert (module != null);
            this.fModule = module;
        }

        public boolean isAdapterForType(Object type) {
            return type == TraceModuleAdapter.class;
        }

        Module getModule() {
            return this.fModule;
        }
    }
}

