/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.svg;

import java.util.Arrays;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.UserAgentAdapter;
import org.eclipse.escet.common.java.ReflectionUtils;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.svg.SvgException;
import org.eclipse.escet.common.svg.SvgUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class SvgUserAgent
extends UserAgentAdapter {
    public Throwable problem = null;

    public void displayError(Exception ex) {
        if (this.problem != null) {
            return;
        }
        this.problem = SvgUserAgent.convertBatikException(ex);
    }

    public static Throwable convertBatikException(Exception ex) {
        if (ex instanceof BridgeException) {
            String uri;
            String prefix;
            BridgeException bex = (BridgeException)ex;
            Object[] params = (Object[])ReflectionUtils.getFieldValue((Object)bex, (String)"params");
            int line = (Integer)ReflectionUtils.getFieldValue((Object)bex, (String)"line");
            Object rslt = ex.getCause();
            String msg = bex.getMessage();
            msg = msg.replace("\r", "").replace("\n", " ");
            Element elem = bex.getElement();
            SVGDocument doc = null;
            if (elem != null) {
                doc = (SVGDocument)elem.getOwnerDocument();
            }
            if (msg.startsWith(prefix = String.valueOf(uri = doc == null ? "<Unknown URI>" : doc.getURL()) + ":" + Strings.str((Object)line))) {
                msg = msg.substring(prefix.length());
            }
            msg = msg.trim();
            msg = "Problem message: " + msg;
            rslt = new SvgException(msg, (Throwable)rslt);
            String code = bex.getCode();
            String detailsTxt = String.valueOf(code) + Arrays.deepToString(params);
            msg = Strings.fmt((String)"Problem details: %s", (Object[])new Object[]{detailsTxt});
            rslt = new SvgException(msg, (Throwable)rslt);
            String elemName = elem == null ? null : elem.getLocalName();
            String elemTxt = elemName == null ? "" : "\"" + elemName + "\" ";
            String id = elem == null ? null : SvgUtils.getSvgElementId(elem);
            String idTxt = id == null ? "unknown id" : "id \"" + id + "\"";
            msg = Strings.fmt((String)"Problem for SVG %selement with %s.", (Object[])new Object[]{elemTxt, idTxt});
            rslt = new SvgException(msg, (Throwable)rslt);
            return rslt;
        }
        if (ex instanceof DOMException) {
            return new SvgException("SVG DOM problem.", ex);
        }
        return ex;
    }

    public void reportProblem() {
        if (this.problem == null) {
            return;
        }
        if (this.problem instanceof SvgException) {
            throw (SvgException)((Object)this.problem);
        }
        if (this.problem instanceof OutOfMemoryError) {
            throw (OutOfMemoryError)this.problem;
        }
        String msg = Strings.fmt((String)"%s reported problem.", (Object[])new Object[]{((Object)((Object)this)).getClass().getName()});
        throw new RuntimeException(msg, this.problem);
    }
}

