/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.texteditorbase;

import java.util.Set;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.setext.texteditorbase.ColorManager;
import org.eclipse.escet.setext.texteditorbase.GenericSpellingReconcileStrategy;
import org.eclipse.escet.setext.texteditorbase.GenericTextHover;
import org.eclipse.escet.setext.texteditorbase.scanners.GenericPartitionScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public abstract class GenericSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    public static final String DEFAULT_CONTENT_TYPE = "__dftl_partition_content_type";
    protected ColorManager colorManager;
    private GenericPartitionScanner partitionScanner;

    public void setColorManager(ColorManager colorManager) {
        Assert.check((this.colorManager == null ? 1 : 0) != 0);
        this.colorManager = colorManager;
    }

    protected void setPartitionScanner(GenericPartitionScanner scanner) {
        Assert.check((this.partitionScanner == null ? 1 : 0) != 0);
        this.partitionScanner = scanner;
    }

    public void setPreferenceStore(IPreferenceStore preferenceStore) {
        Assert.check((this.fPreferenceStore == null ? 1 : 0) != 0);
        this.fPreferenceStore = preferenceStore;
    }

    protected String[] getIndentPrefixesForTab(int tabWidth) {
        boolean spacesForTabs = this.fPreferenceStore.getBoolean("spacesForTabs");
        String[] indentPrefixes = new String[tabWidth + 2];
        int i = 0;
        while (i <= tabWidth) {
            String spaces = Strings.spaces((int)i);
            indentPrefixes[i] = i >= tabWidth ? spaces : (spacesForTabs ? Strings.spaces((int)tabWidth) : String.valueOf(spaces) + '\t');
            ++i;
        }
        indentPrefixes[tabWidth + 1] = "";
        return indentPrefixes;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        String[] contentTypes = this.partitionScanner.getTypes();
        String[] rslt = new String[contentTypes.length + 1];
        rslt[0] = DEFAULT_CONTENT_TYPE;
        System.arraycopy(contentTypes, 0, rslt, 1, contentTypes.length);
        return rslt;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        this.addDamagersRepairers(reconciler);
        return reconciler;
    }

    protected abstract void addDamagersRepairers(PresentationReconciler var1);

    protected static void addDamagerRepairer(PresentationReconciler reconciler, ITokenScanner scanner, String contentType) {
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(scanner);
        reconciler.setDamager((IPresentationDamager)dr, contentType);
        reconciler.setRepairer((IPresentationRepairer)dr, contentType);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new GenericTextHover(sourceViewer);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new GenericTextHover(sourceViewer);
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new GenericTextHover(sourceViewer);
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return null;
        }
        if (!this.fPreferenceStore.getBoolean("spellingEnabled")) {
            return null;
        }
        SpellingService spellingService = EditorsUI.getSpellingService();
        if (spellingService.getActiveSpellingEngineDescriptor(this.fPreferenceStore) == null) {
            return null;
        }
        Set<String> spellingContentTypes = this.partitionScanner.getSpellingTypes();
        if (spellingContentTypes.isEmpty()) {
            return null;
        }
        GenericSpellingReconcileStrategy strategy = new GenericSpellingReconcileStrategy(sourceViewer, spellingService, spellingContentTypes);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, true);
        return reconciler;
    }
}

