/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.explorer.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.explorer.runtime.AbstractStateFactory;
import org.eclipse.escet.cif.explorer.runtime.CollectedAlgVariable;
import org.eclipse.escet.cif.explorer.runtime.CollectedInvariants;
import org.eclipse.escet.cif.explorer.runtime.EventUsage;
import org.eclipse.escet.cif.explorer.runtime.Explorer;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeReceive;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Monitors;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ExplorerBuilder {
    public final Specification spec;
    private List<Automaton> automata = Lists.list();
    private List<Automaton> multiInitAuts = Lists.list();
    private List<PositionObject> variables = Lists.list();
    private List<DiscVariable> multiInitVars = Lists.list();
    private Map<AlgVariable, CollectedAlgVariable> algVariables = Maps.map();
    private List<Event> events = Lists.list();
    private Map<Location, CollectedInvariants> stateInvs = Maps.map();
    private Map<Event, Map<Location, CollectedInvariants>> stateEvtExclInvs = Maps.map();
    private List<Expression> markeds = Lists.list();
    private Map<Location, List<Expression>> initialLocs = Maps.map();

    public ExplorerBuilder(Specification spec) {
        this.spec = spec;
    }

    private void addInvariants(Location loc, List<Invariant> invs) {
        if (invs.isEmpty()) {
            return;
        }
        CollectedInvariants ci = this.stateInvs.get(loc);
        if (ci == null) {
            ci = new CollectedInvariants();
            this.stateInvs.put(loc, ci);
        }
        for (Invariant inv : invs) {
            if (inv.getInvKind() != InvKind.STATE) continue;
            ci.add(inv);
        }
        for (Invariant inv : invs) {
            CollectedInvariants ei;
            if (inv.getInvKind() == InvKind.STATE) continue;
            Event event = ((EventExpression)inv.getEvent()).getEvent();
            Map el = this.stateEvtExclInvs.get(event);
            if (el == null) {
                el = Maps.map();
                this.stateEvtExclInvs.put(event, el);
            }
            if ((ei = (CollectedInvariants)el.get(loc)) == null) {
                ei = new CollectedInvariants();
                el.put(loc, ei);
            }
            ei.add(inv);
        }
    }

    private void addInitials(Location loc, List<Expression> inits) {
        if (inits.isEmpty()) {
            return;
        }
        List exprs = this.initialLocs.get(loc);
        if (exprs == null) {
            exprs = Lists.copy(inits);
            this.initialLocs.put(loc, exprs);
            return;
        }
        exprs.addAll(inits);
    }

    public void collectData() {
        this.automata = Lists.list();
        this.variables = Lists.list();
        this.algVariables = Maps.map();
        this.events = Lists.list();
        this.stateInvs = Maps.map();
        this.stateEvtExclInvs = Maps.map();
        this.markeds = Lists.list();
        this.initialLocs = Maps.map();
        this.collectGroup((Group)this.spec);
    }

    private void collectGroup(Group group) {
        this.collectComponent((ComplexComponent)group, -1);
        for (Component comp : group.getComponents()) {
            if (comp instanceof Automaton) {
                this.automata.add((Automaton)comp);
                int autIndex = this.automata.size() - 1;
                this.collectComponent((ComplexComponent)comp, autIndex);
                continue;
            }
            Assert.check((boolean)(comp instanceof Group));
            this.collectGroup((Group)comp);
        }
    }

    private void collectComponent(ComplexComponent comp, int autIndex) {
        Assert.check((boolean)comp.getIoDecls().isEmpty());
        for (Declaration decl : comp.getDeclarations()) {
            if (decl instanceof AlgVariable) {
                AlgVariable av = (AlgVariable)decl;
                this.algVariables.put(av, new CollectedAlgVariable(av, autIndex));
                continue;
            }
            if (decl instanceof Event) {
                this.events.add((Event)decl);
                continue;
            }
            if (decl instanceof ContVariable) {
                this.variables.add((PositionObject)decl);
                continue;
            }
            if (!(decl instanceof DiscVariable)) continue;
            this.variables.add((PositionObject)decl);
            DiscVariable var = (DiscVariable)decl;
            if (var.getValue() == null || var.getValue().getValues().size() == 1) continue;
            this.multiInitVars.add(var);
        }
        for (Equation eq : comp.getEquations()) {
            if (eq.isDerivative()) continue;
            CollectedAlgVariable ca = this.algVariables.get(eq.getVariable());
            ca.value = eq.getValue();
        }
        this.addInitials(null, (List<Expression>)comp.getInitials());
        this.addInvariants(null, (List<Invariant>)comp.getInvariants());
        this.markeds.addAll((Collection<Expression>)comp.getMarkeds());
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            int initCnt = 0;
            for (Location loc : aut.getLocations()) {
                if (!loc.getInitials().isEmpty()) {
                    ++initCnt;
                }
                this.addInitials(loc, (List<Expression>)loc.getInitials());
                this.addInvariants(loc, (List<Invariant>)loc.getInvariants());
                for (Equation eq : loc.getEquations()) {
                    if (eq.isDerivative()) continue;
                    CollectedAlgVariable ca = this.algVariables.get(eq.getVariable());
                    if (ca.locMap == null) {
                        ca.locMap = Maps.map();
                    }
                    ca.locMap.put(loc, eq.getValue());
                }
            }
            if (initCnt > 1) {
                this.multiInitAuts.add(aut);
            }
        }
    }

    public Explorer buildExplorer(AbstractStateFactory stateFactory) {
        Automaton[] auts = new Automaton[this.automata.size()];
        auts = this.automata.toArray(auts);
        PositionObject[] vars = new PositionObject[this.variables.size()];
        vars = this.variables.toArray(vars);
        return new Explorer(auts, this.multiInitAuts, vars, this.multiInitVars, this.algVariables, this.stateInvs, this.stateEvtExclInvs, this.markeds, this.initialLocs, stateFactory);
    }

    public static List<EventUsage> getSynchronizingEventMap(Automaton[] automata, Map<Event, Map<Location, CollectedInvariants>> stateEvtExclInvs) {
        Set allEvents = Sets.set();
        List alphabets = Lists.listc((int)automata.length);
        List monitors = Lists.listc((int)automata.length);
        List sends = Lists.listc((int)automata.length);
        List recvs = Lists.listc((int)automata.length);
        Automaton[] automatonArray = automata;
        int n = automata.length;
        int n2 = 0;
        while (n2 < n) {
            Automaton aut = automatonArray[n2];
            Set alphabet = Sets.set();
            Set monitor = Sets.set();
            Set send = Sets.set();
            Set recv = Sets.set();
            if (aut.getAlphabet() != null) {
                for (Expression expr : aut.getAlphabet().getEvents()) {
                    EventExpression eve = (EventExpression)expr;
                    alphabet.add(eve.getEvent());
                }
            }
            for (Location loc : aut.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    if (edge.getEvents().isEmpty()) continue;
                    for (EdgeEvent ee : edge.getEvents()) {
                        Expression eventRef = ee.getEvent();
                        if (eventRef instanceof TauExpression) continue;
                        EventExpression eve = (EventExpression)eventRef;
                        Event event = eve.getEvent();
                        if (ee instanceof EdgeSend) {
                            send.add(event);
                            continue;
                        }
                        if (ee instanceof EdgeReceive) {
                            recv.add(event);
                            continue;
                        }
                        alphabet.add(event);
                    }
                }
            }
            if (aut.getMonitors() != null) {
                Monitors mons = aut.getMonitors();
                if (mons.getEvents().isEmpty()) {
                    monitor.addAll(alphabet);
                } else {
                    for (Expression expr : mons.getEvents()) {
                        EventExpression ee = (EventExpression)expr;
                        monitor.add(ee.getEvent());
                    }
                }
            }
            alphabets.add(alphabet);
            monitors.add(monitor);
            sends.add(send);
            recvs.add(recv);
            allEvents.addAll(alphabet);
            allEvents.addAll(monitor);
            allEvents.addAll(send);
            allEvents.addAll(recv);
            ++n2;
        }
        List eventUsages = Lists.listc((int)allEvents.size());
        for (Event event : allEvents) {
            int[] alphabetIndices = ExplorerBuilder.makeEventIndicesArray(alphabets, event);
            boolean[] monitorAuts = ExplorerBuilder.makeEventAutsArray(monitors, event);
            int[] sendIndices = ExplorerBuilder.makeEventIndicesArray(sends, event);
            int[] recvIndices = ExplorerBuilder.makeEventIndicesArray(recvs, event);
            Map evtLocInvs = stateEvtExclInvs.get(event);
            if (evtLocInvs == null) {
                evtLocInvs = Collections.EMPTY_MAP;
            }
            EventUsage eu = new EventUsage(event, alphabetIndices, monitorAuts, sendIndices, recvIndices, evtLocInvs);
            eventUsages.add(eu);
        }
        return eventUsages;
    }

    private static int[] makeEventIndicesArray(List<Set<Event>> usage, Event event) {
        int[] indices = new int[usage.size()];
        int last = 0;
        int i = 0;
        while (i < usage.size()) {
            if (usage.get(i).contains(event)) {
                indices[last++] = i;
            }
            ++i;
        }
        return Arrays.copyOf(indices, last);
    }

    private static boolean[] makeEventAutsArray(List<Set<Event>> usage, Event event) {
        boolean[] hasEvents = new boolean[usage.size()];
        int i = 0;
        while (i < usage.size()) {
            hasEvents[i] = usage.get(i).contains(event);
            ++i;
        }
        return hasEvents;
    }
}

