/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.explorer.runtime;

import java.util.Arrays;
import java.util.List;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.explorer.runtime.Explorer;
import org.eclipse.escet.cif.explorer.runtime.ExplorerEdge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class BaseState {
    protected final Explorer explorer;
    public final Location[] locations;
    public final Object[] values;
    public int stateNumber = -1;
    public List<ExplorerEdge> outgoingEdges = null;
    public List<ExplorerEdge> incomingEdges = Lists.list();

    public BaseState(Explorer explorer, Location[] locations, Object[] values) {
        this.explorer = explorer;
        this.locations = locations;
        this.values = values;
    }

    public Object eval(Expression expr, Object commVal) throws CifEvalException {
        return this.explorer.evaluator.eval(expr, this, commVal);
    }

    public List<ExplorerEdge> getOutgoingEdges() {
        if (this.outgoingEdges == null) {
            this.outgoingEdges = Lists.list();
            this.explorer.computeOutgoing(this, false);
        }
        return this.outgoingEdges;
    }

    public List<BaseState> getNewSuccessorStates() {
        Assert.check((this.outgoingEdges == null ? 1 : 0) != 0);
        this.outgoingEdges = Lists.list();
        return this.explorer.computeOutgoing(this, true);
    }

    public List<ExplorerEdge> getIncomingEdges() {
        return this.incomingEdges;
    }

    public void removeIncoming(ExplorerEdge edge) {
        int lastEdge = this.incomingEdges.size() - 1;
        int i = 0;
        while (i <= lastEdge) {
            if (this.incomingEdges.get(i) == edge) {
                if (i < lastEdge) {
                    this.incomingEdges.set(i, this.incomingEdges.get(lastEdge));
                }
                this.incomingEdges.remove(lastEdge);
                return;
            }
            ++i;
        }
        throw new RuntimeException("Could not find edge.");
    }

    public void removeOutgoing(ExplorerEdge edge) {
        int lastEdge = this.outgoingEdges.size() - 1;
        int i = 0;
        while (i <= lastEdge) {
            if (this.outgoingEdges.get(i) == edge) {
                if (i < lastEdge) {
                    this.outgoingEdges.set(i, this.outgoingEdges.get(lastEdge));
                }
                this.outgoingEdges.remove(lastEdge);
                return;
            }
            ++i;
        }
        throw new RuntimeException("Could not find edge.");
    }

    public abstract boolean isInitial();

    public abstract boolean isMarked();

    public abstract Object getVarValue(PositionObject var1);

    public abstract void setVarValue(PositionObject var1, Object var2);

    public abstract Location getCurrentLocation(int var1);

    public abstract Expression getAlgExpression(AlgVariable var1);

    public boolean equals(Object other) {
        if (!(other instanceof BaseState)) {
            return false;
        }
        BaseState otherVal = (BaseState)other;
        return Arrays.equals(this.locations, otherVal.locations) && Arrays.equals(this.values, otherVal.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.locations) + Arrays.hashCode(this.values) * 911;
    }

    public void printDebug(CodeBox box) {
        box.add(Strings.fmt((String)"State %d:", (Object[])new Object[]{this.stateNumber}));
        box.indent();
        box.add("Initial: " + (this.isInitial() ? "true" : "false"));
        box.add("Marked: " + (this.isMarked() ? "true" : "false"));
        if (this.locations.length > 0) {
            box.add();
            box.add("Locations:");
            box.indent();
            Location[] locationArray = this.locations;
            int n = this.locations.length;
            int n2 = 0;
            while (n2 < n) {
                Location loc = locationArray[n2];
                box.add(CifTextUtils.getLocationText1((Location)loc));
                ++n2;
            }
            box.dedent();
        }
        if (this.values.length > 0) {
            box.add();
            box.add("Valuation:");
            box.indent();
            String[] varNames = this.explorer.getVariableNames();
            int i = 0;
            while (i < this.values.length) {
                String valueText = CifEvalUtils.objToStr((Object)this.values[i]);
                box.add(Strings.fmt((String)"%s = %s", (Object[])new Object[]{varNames[i], valueText}));
                ++i;
            }
            box.dedent();
        }
        this.printOtherStateInformation(box);
        if (this.outgoingEdges != null && !this.outgoingEdges.isEmpty()) {
            box.add();
            box.add("Edges:");
            box.indent();
            for (ExplorerEdge edge : this.outgoingEdges) {
                String eventName = edge.event == null ? "tau" : CifTextUtils.getAbsName((PositionObject)edge.event);
                String sendValue = edge.commValue == null ? "" : " value " + CifEvalUtils.objToStr((Object)edge.commValue);
                String target = Strings.fmt((String)" goto state %d", (Object[])new Object[]{edge.next.stateNumber});
                box.add("edge " + eventName + sendValue + target);
            }
            box.dedent();
        }
        box.dedent();
    }

    protected void printOtherStateInformation(CodeBox box) {
    }

    public String toString() {
        StringBuilder txt = new StringBuilder();
        int i = 0;
        while (i < this.locations.length) {
            if (txt.length() > 0) {
                txt.append(", ");
            }
            txt.append(CifTextUtils.getAbsName((PositionObject)this.explorer.automata[i]));
            txt.append(": ");
            Location loc = this.locations[i];
            if (loc == null) {
                txt.append("?");
            } else {
                txt.append(CifLocationUtils.getName((Location)loc));
            }
            ++i;
        }
        i = 0;
        while (i < this.values.length) {
            if (txt.length() > 0) {
                txt.append(", ");
            }
            txt.append(CifTextUtils.getAbsName((PositionObject)this.explorer.variables[i]));
            txt.append(": ");
            Object value = this.values[i];
            if (value == null) {
                txt.append("?");
            } else {
                txt.append(CifEvalUtils.objToStr((Object)value));
            }
            ++i;
        }
        return txt.toString();
    }
}

