/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.explorer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifInvariantUtils;
import org.eclipse.escet.cif.common.CifMath;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ExplorerPreChecker
extends CifWalker {
    private Set<String> problems = null;
    private final EnumSet<CheckParameters> params;

    public ExplorerPreChecker(EnumSet<CheckParameters> params) {
        this.params = params;
    }

    public void checkSpec(Specification spec) {
        this.problems = Sets.set();
        this.walkSpecification(spec);
        if (this.problems.isEmpty()) {
            return;
        }
        String msg = "State space exploration failed due to unsatisfied preconditions:\n - " + StringUtils.join((Collection)Sets.sortedstrings(this.problems), (String)"\n - ");
        throw new UnsupportedException(msg);
    }

    protected void preprocessDistType(DistType tp) {
        String msg = Strings.fmt((String)"Distribution type \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)tp)});
        this.problems.add(msg);
    }

    protected void preprocessAutomaton(Automaton aut) {
        switch (aut.getKind()) {
            case NONE: {
                if (this.params.contains((Object)CheckParameters.ALLOW_NON_AUT)) break;
                String msg = Strings.fmt((String)"Regular automaton \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
                this.problems.add(msg);
                break;
            }
            case PLANT: {
                break;
            }
            case REQUIREMENT: {
                if (this.params.contains((Object)CheckParameters.ALLOW_REQ_AUT)) break;
                String msg = Strings.fmt((String)"Requirement automaton \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
                this.problems.add(msg);
                break;
            }
            case SUPERVISOR: {
                if (this.params.contains((Object)CheckParameters.ALLOW_SUP_AUT)) break;
                String msg = Strings.fmt((String)"Supervisor automaton \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
                this.problems.add(msg);
            }
        }
    }

    protected void preprocessEdge(Edge edge) {
        if (this.params.contains((Object)CheckParameters.ALLOW_TAU)) {
            return;
        }
        Location loc = (Location)edge.eContainer();
        if (edge.getEvents().isEmpty()) {
            String msg = Strings.fmt((String)"Tau events in edges of %s are not supported.", (Object[])new Object[]{CifTextUtils.getLocationText2((Location)loc)});
            this.problems.add(msg);
            return;
        }
        for (EdgeEvent ee : edge.getEvents()) {
            if (!(ee.getEvent() instanceof TauExpression)) continue;
            String msg = Strings.fmt((String)"Tau events in edges of %s are not supported.", (Object[])new Object[]{CifTextUtils.getLocationText2((Location)loc)});
            this.problems.add(msg);
            return;
        }
    }

    protected void preprocessExternalFunction(ExternalFunction func) {
        String msg = Strings.fmt((String)"External user-defined function \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)func)});
        this.problems.add(msg);
    }

    protected void preprocessInputVariable(InputVariable var) {
        String msg = Strings.fmt((String)"Input variable \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
        this.problems.add(msg);
    }

    protected void preprocessDiscVariable(DiscVariable var) {
        if (var.getValue() == null) {
            return;
        }
        EList initVals = var.getValue().getValues();
        if (initVals.size() == 1) {
            return;
        }
        if (!initVals.isEmpty()) {
            return;
        }
        double cnt = CifValueUtils.getPossibleValueCount((CifType)var.getType());
        if (cnt <= 2.147483647E9) {
            return;
        }
        String cntTxt = Double.isInfinite(cnt) ? "infinite" : CifMath.realToStr((double)cnt);
        String msg = Strings.fmt((String)"Discrete variable \"%s\" of type \"%s\" with %s potential initial values is not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var), CifTextUtils.typeToStr((CifType)var.getType()), cntTxt});
        this.problems.add(msg);
    }

    protected void preprocessInvariant(Invariant inv) {
        String parentTxt;
        EObject parent = inv.eContainer();
        if (parent instanceof Location) {
            parentTxt = CifTextUtils.getLocationText2((Location)((Location)parent));
        } else {
            Assert.check((boolean)(parent instanceof ComplexComponent));
            parentTxt = CifTextUtils.getComponentText2((ComplexComponent)((ComplexComponent)parent));
        }
        switch (CifInvariantUtils.getSupKind((Invariant)inv)) {
            case NONE: {
                if (this.params.contains((Object)CheckParameters.ALLOW_NON_INVS)) break;
                String msg = Strings.fmt((String)"Regular invariants in %s are not supported.", (Object[])new Object[]{parentTxt});
                this.problems.add(msg);
                break;
            }
            case PLANT: {
                break;
            }
            case REQUIREMENT: {
                if (this.params.contains((Object)CheckParameters.ALLOW_REQ_INVS)) break;
                String msg = Strings.fmt((String)"Requirement invariants in %s are not supported.", (Object[])new Object[]{parentTxt});
                this.problems.add(msg);
                break;
            }
            case SUPERVISOR: {
                if (this.params.contains((Object)CheckParameters.ALLOW_SUP_INVS)) break;
                String msg = Strings.fmt((String)"Supervisor invariants in %s are not supported.", (Object[])new Object[]{parentTxt});
                this.problems.add(msg);
            }
        }
    }

    protected void preprocessContVariableExpression(ContVariableExpression expr) {
        if (expr.isDerivative()) {
            String msg = "Use of derivatives of continuous variables is not supported.";
            this.problems.add(msg);
        }
    }

    protected void preprocessStdLibFunctionExpression(StdLibFunctionExpression expr) {
        if (CifTypeUtils.isDistFunction((StdLibFunction)expr.getFunction())) {
            String msg = Strings.fmt((String)"Distribution standard library function \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.functionToStr((StdLibFunction)expr.getFunction())});
            this.problems.add(msg);
        }
    }

    public static enum CheckParameters {
        ALLOW_NON_INVS,
        ALLOW_SUP_INVS,
        ALLOW_REQ_INVS,
        ALLOW_NON_AUT,
        ALLOW_SUP_AUT,
        ALLOW_REQ_AUT,
        ALLOW_TAU;

    }
}

