/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.impl;

import java.util.Map;
import org.eclipse.trace4cps.analysis.mtl.AtomicProposition;
import org.eclipse.trace4cps.core.ClaimEventType;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IClaimEvent;
import org.eclipse.trace4cps.core.impl.Event;
import org.eclipse.trace4cps.core.impl.TraceHelper;

public class ClaimEvent
extends Event
implements IClaimEvent {
    private final IClaim claim;
    private final ClaimEventType type;

    public ClaimEvent(Number t, IClaim claim, ClaimEventType type) {
        super(t);
        this.claim = claim;
        this.type = type;
    }

    @Override
    public IClaim getClaim() {
        return this.claim;
    }

    @Override
    public ClaimEventType getType() {
        return this.type;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.claim.getAttributes();
    }

    @Override
    public String getAttributeValue(String key) {
        return this.claim.getAttributeValue(key);
    }

    @Override
    public void setAttribute(String key, String value) {
        this.claim.setAttribute(key, value);
    }

    @Override
    public boolean satisfies(AtomicProposition p) {
        if (p.getType() != null && p.getType() != this.type) {
            return false;
        }
        return TraceHelper.matches(p, this);
    }

    @Override
    public String toString() {
        return "ClaimEvent[t=" + this.getTimestamp() + ", type=" + (Object)((Object)this.type) + ", attributes=" + this.getAttributes() + "]";
    }
}

