/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.api.layout;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.sirius.diagram.description.LayoutOption;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.DefaultLayoutProvider;

public final class CustomLayoutAlgorithm {
    private String id;
    private String label;
    private String description;
    private Supplier<DefaultLayoutProvider> layoutSupplier;
    private Map<String, LayoutOption> layoutOptions;
    private boolean launchSnapAfter = true;

    private CustomLayoutAlgorithm() {
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, LayoutOption> getLayoutOptions() {
        return this.layoutOptions;
    }

    public DefaultLayoutProvider getLayoutAlgorithmInstance() {
        return this.layoutSupplier.get();
    }

    public boolean isLaunchSnapAfter() {
        return this.launchSnapAfter;
    }

    public String toString() {
        return this.id;
    }

    public static CustomLayoutAlgorithmBuilder newCustomLayoutAlgorithm(String algorithmId) {
        return new CustomLayoutAlgorithmBuilder(algorithmId);
    }

    /* synthetic */ CustomLayoutAlgorithm(CustomLayoutAlgorithm customLayoutAlgorithm) {
        this();
    }

    public static final class CustomLayoutAlgorithmBuilder {
        private String id;
        private String label;
        private String description;
        private Supplier<DefaultLayoutProvider> layoutSupplier;
        private Map<String, LayoutOption> layoutOptions;
        private boolean launchSnapAfter;

        CustomLayoutAlgorithmBuilder(String id) {
            this.id = Objects.requireNonNull(id);
        }

        public CustomLayoutAlgorithmBuilder setLabel(String label) {
            this.label = Objects.requireNonNull(label);
            return this;
        }

        public CustomLayoutAlgorithmBuilder setDescription(String description) {
            this.description = Objects.requireNonNull(description);
            return this;
        }

        public CustomLayoutAlgorithmBuilder setLayoutSupplier(Supplier<DefaultLayoutProvider> layoutSupplier) {
            this.layoutSupplier = Objects.requireNonNull(layoutSupplier);
            return this;
        }

        public CustomLayoutAlgorithmBuilder setLayoutOptions(Map<String, LayoutOption> layoutOptions) {
            this.layoutOptions = Objects.requireNonNull(layoutOptions);
            return this;
        }

        public CustomLayoutAlgorithmBuilder setLaunchSnapAfter(boolean launchSnapAfter) {
            this.launchSnapAfter = launchSnapAfter;
            return this;
        }

        public CustomLayoutAlgorithm build() {
            CustomLayoutAlgorithm customLayoutAlgorithm = new CustomLayoutAlgorithm(null);
            customLayoutAlgorithm.id = Objects.requireNonNull(this.id);
            customLayoutAlgorithm.label = Objects.requireNonNull(this.label);
            customLayoutAlgorithm.description = Objects.requireNonNull(this.description);
            customLayoutAlgorithm.layoutSupplier = Objects.requireNonNull(this.layoutSupplier);
            customLayoutAlgorithm.layoutOptions = Objects.requireNonNull(this.layoutOptions);
            customLayoutAlgorithm.launchSnapAfter = this.launchSnapAfter;
            return customLayoutAlgorithm;
        }
    }
}

