/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.io;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.java.Strings;

public class OutputStreamAppStream
extends AppStream {
    private final OutputStream stream;

    public OutputStreamAppStream(OutputStream stream) {
        this.stream = stream;
    }

    @Override
    protected void writeImpl(byte b) {
        try {
            this.stream.write(b);
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to write to an output stream.", (Object[])new Object[0]);
            throw new InputOutputException(msg, ex);
        }
    }

    @Override
    protected void writeImpl(byte[] bytes, int offset, int length) {
        try {
            this.stream.write(bytes, offset, length);
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to write to an output stream.", (Object[])new Object[0]);
            throw new InputOutputException(msg, ex);
        }
    }

    @Override
    protected void flushImpl() {
        try {
            this.stream.flush();
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to flush an output stream.", (Object[])new Object[0]);
            throw new InputOutputException(msg, ex);
        }
    }

    @Override
    protected void closeImpl() {
        try {
            this.stream.close();
        }
        catch (IOException ex) {
            String msg = Strings.fmt((String)"Failed to close an output stream.", (Object[])new Object[0]);
            throw new InputOutputException(msg, ex);
        }
    }
}

