/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.typeinfos;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.ExprProperties;
import org.eclipse.escet.cif.codegen.ExpressionAnalysisSupport;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.typeinfos.NegateOperation;
import org.eclipse.escet.cif.codegen.typeinfos.OrderingOperations;
import org.eclipse.escet.cif.codegen.typeinfos.RangeCheckErrorLevelText;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfoHelper;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.common.box.CodeBox;

public abstract class RealTypeInfo
extends TypeInfo
implements NegateOperation,
OrderingOperations {
    public RealTypeInfo(CifType cifType) {
        super(cifType);
    }

    @Override
    protected String makeTypeName() {
        return "R";
    }

    @Override
    public ExprCode convertLessThan(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, this.getBinaryExpressionTemplate(BinaryOperator.LESS_THAN), dest, ctxt);
    }

    @Override
    public ExprCode convertLessEqual(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, this.getBinaryExpressionTemplate(BinaryOperator.LESS_EQUAL), dest, ctxt);
    }

    @Override
    public ExprCode convertGreaterEqual(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, this.getBinaryExpressionTemplate(BinaryOperator.GREATER_EQUAL), dest, ctxt);
    }

    @Override
    public ExprCode convertGreaterThan(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, this.getBinaryExpressionTemplate(BinaryOperator.GREATER_THAN), dest, ctxt);
    }

    public abstract ExprCode convertLiteral(String var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertTimeExpression(Destination var1, CodeContext var2);

    public abstract ExprCode convertAddition(BinaryExpression var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertSubtraction(BinaryExpression var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertMultiplication(BinaryExpression var1, Destination var2, CodeContext var3);

    public ExprCode convertDivision(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
        CifType rtype = CifTypeUtils.normalizeType((CifType)expr.getRight().getType());
        EnumSet<ExprProperties> properties = EnumSet.noneOf(ExprProperties.class);
        if (ltype instanceof IntType && rtype instanceof IntType) {
            properties.add(ExprProperties.INT_INT_DIVIDE);
        } else {
            properties.add(ExprProperties.RANGE_FAILURE);
        }
        if (rtype instanceof RealType || ExpressionAnalysisSupport.typeAllowsZero(rtype)) {
            properties.add(ExprProperties.ZERO_DIVIDE_FAILURE);
        }
        return this.convertDivision(expr, properties, dest, ctxt);
    }

    protected abstract ExprCode convertDivision(BinaryExpression var1, EnumSet<ExprProperties> var2, Destination var3, CodeContext var4);

    public abstract ExprCode convertAbsStdLib(Expression var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertMaximumStdLib(List<Expression> var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertMinimumStdLib(List<Expression> var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertSignStdLib(Expression var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertPowerStdLib(List<Expression> var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertSqrtStdLib(Expression var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertCbrtStdLib(Expression var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertScaleStdLib(List<Expression> var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertTrigonometryStdLib(StdLibFunction var1, Expression var2, Destination var3, CodeContext var4);

    public abstract ExprCode convertLogarithmicStdLib(StdLibFunction var1, Expression var2, Destination var3, CodeContext var4);

    @Override
    public void checkRange(CifType lhsType, CifType rhsType, DataValue rhsValue, CifType varType, String varName, List<RangeCheckErrorLevelText> errorTexts, int level, CodeBox code, CodeContext ctxt) {
    }
}

