/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen;

import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.IfElseGenerator;
import org.eclipse.escet.cif.codegen.updates.tree.UpdateData;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.AssignmentFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.BreakFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ContinueFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.ElifFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.IfFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.ReturnFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.functions.WhileFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.emf.EMFHelper;

public abstract class FunctionCodeGen {
    protected InternalFunction function;

    public FunctionCodeGen(InternalFunction function) {
        this.function = function;
    }

    public CifType getReturnType() {
        return CifTypeUtils.makeTupleType((List)EMFHelper.deepclone((List)this.function.getReturnTypes()));
    }

    protected void addFuncStatements(List<FunctionStatement> statements, CodeBox code, CodeContext ctxt) {
        this.addFuncStatements(statements, code, false, ctxt);
    }

    private void addFuncStatements(List<FunctionStatement> statements, CodeBox code, boolean safeScope, CodeContext ctxt) {
        safeScope = safeScope && statements.size() == 1;
        int i = 0;
        while (i < statements.size()) {
            FunctionStatement statement = statements.get(i);
            if (i > 0) {
                code.add();
            }
            this.addFuncStatement(statement, code, safeScope, ctxt);
            ++i;
        }
    }

    private void addFuncStatement(FunctionStatement statement, CodeBox code, boolean safeScope, CodeContext ctxt) {
        if (statement instanceof AssignmentFuncStatement) {
            AssignmentFuncStatement asgn = (AssignmentFuncStatement)statement;
            UpdateData.generateAssignment(asgn, code, safeScope, ctxt);
        } else if (statement instanceof BreakFuncStatement) {
            this.generateBreakFuncStatement(code);
        } else if (statement instanceof ContinueFuncStatement) {
            this.generateContinueFuncStatement(code);
        } else if (statement instanceof IfFuncStatement) {
            IfFuncStatement istat = (IfFuncStatement)statement;
            IfElseGenerator ifElseFrame = this.getIfElseFuncGenerator();
            ExprCode guardCode = ctxt.predsToTarget((List<Expression>)istat.getGuards());
            ifElseFrame.generateIf(guardCode, code);
            this.addFuncStatements((List<FunctionStatement>)istat.getThens(), code, ifElseFrame.branchIsSafeScope(), ctxt);
            for (ElifFuncStatement elif : istat.getElifs()) {
                ExprCode elifGuardCode = ctxt.predsToTarget((List<Expression>)elif.getGuards());
                ifElseFrame.generateElseIf(elifGuardCode, code);
                this.addFuncStatements((List<FunctionStatement>)elif.getThens(), code, ifElseFrame.branchIsSafeScope(), ctxt);
            }
            if (!istat.getElses().isEmpty()) {
                ifElseFrame.generateElse(code);
                this.addFuncStatements((List<FunctionStatement>)istat.getElses(), code, ifElseFrame.branchIsSafeScope(), ctxt);
            }
            ifElseFrame.generateEndIf(code);
        } else if (statement instanceof ReturnFuncStatement) {
            ReturnFuncStatement rstat = (ReturnFuncStatement)statement;
            Expression retValue = CifValueUtils.makeTuple((List)EMFHelper.deepclone((List)rstat.getValues()));
            this.generateReturnFuncStatement(retValue, code, safeScope, ctxt);
        } else if (statement instanceof WhileFuncStatement) {
            WhileFuncStatement wstat = (WhileFuncStatement)statement;
            ExprCode guardCode = ctxt.predsToTarget((List<Expression>)wstat.getGuards());
            safeScope = this.generateWhileFuncStatement(guardCode, code, safeScope);
            this.addFuncStatements((List<FunctionStatement>)wstat.getStatements(), code, safeScope, ctxt);
            this.generateEndWhileFuncStatement(code);
        } else {
            throw new RuntimeException("Unknown func stat: " + statement);
        }
    }

    protected abstract IfElseGenerator getIfElseFuncGenerator();

    protected abstract void generateBreakFuncStatement(CodeBox var1);

    protected abstract void generateContinueFuncStatement(CodeBox var1);

    protected abstract void generateReturnFuncStatement(Expression var1, CodeBox var2, boolean var3, CodeContext var4);

    protected abstract boolean generateWhileFuncStatement(ExprCode var1, CodeBox var2, boolean var3);

    protected abstract void generateEndWhileFuncStatement(CodeBox var1);
}

