/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen;

import java.util.List;
import org.eclipse.escet.cif.codegen.c89.C89CodeGen;
import org.eclipse.escet.cif.codegen.c99.C99CodeGen;
import org.eclipse.escet.cif.codegen.java.JavaCodeGen;
import org.eclipse.escet.cif.codegen.options.CodePrefixOption;
import org.eclipse.escet.cif.codegen.options.JavaPackageOption;
import org.eclipse.escet.cif.codegen.options.OutputDirOption;
import org.eclipse.escet.cif.codegen.options.SimulinkOutputsOption;
import org.eclipse.escet.cif.codegen.options.SimulinkSampleOffsetOption;
import org.eclipse.escet.cif.codegen.options.SimulinkSampleTimeOption;
import org.eclipse.escet.cif.codegen.options.TargetLanguage;
import org.eclipse.escet.cif.codegen.options.TargetLanguageOption;
import org.eclipse.escet.cif.codegen.simulink.SimulinkCodeGen;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class CodeGenApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        CodeGenApp app = new CodeGenApp();
        app.run(args);
    }

    public CodeGenApp() {
    }

    public CodeGenApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF code generator";
    }

    public String getAppDescription() {
        return "Generates implementation code from CIF specifications, for various languages and platforms.";
    }

    protected int runInternal() {
        Specification spec = (Specification)((CifReader)new CifReader().init()).read();
        if (this.isTerminationRequested()) {
            return 0;
        }
        String path = OutputDirOption.getPath();
        TargetLanguage lang = TargetLanguageOption.getLanguage();
        try {
            switch (lang) {
                case JAVA: {
                    new JavaCodeGen().generate(spec, path);
                    break;
                }
                case C89: {
                    new C89CodeGen().generate(spec, path);
                    break;
                }
                case C99: {
                    new C99CodeGen().generate(spec, path);
                    break;
                }
                case SIMULINK: {
                    new SimulinkCodeGen().generate(spec, path);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown target language");
                }
            }
        }
        catch (UnsupportedException ex) {
            String msg = Strings.fmt((String)"Code generation to %s failed for CIF file \"%s\".", (Object[])new Object[]{lang.readableName, InputFileOption.getPath()});
            throw new UnsupportedException(msg, (Throwable)ex);
        }
        return 0;
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = CodeGenApp.getGeneralOptionCategory();
        List javaOpts = Lists.list();
        javaOpts.add(Options.getInstance(JavaPackageOption.class));
        List javaSubCats = Lists.list();
        OptionCategory javaCat = new OptionCategory("Java", "Java code generation options.", javaSubCats, javaOpts);
        List simulinkOpts = Lists.list();
        simulinkOpts.add(Options.getInstance(SimulinkOutputsOption.class));
        simulinkOpts.add(Options.getInstance(SimulinkSampleTimeOption.class));
        simulinkOpts.add(Options.getInstance(SimulinkSampleOffsetOption.class));
        List simulinkSubCats = Lists.list();
        OptionCategory simulinkCat = new OptionCategory("Simulink", "Simulink code generation options.", simulinkSubCats, simulinkOpts);
        List genOpts = Lists.list();
        genOpts.add(Options.getInstance(InputFileOption.class));
        genOpts.add(Options.getInstance(OutputDirOption.class));
        genOpts.add(Options.getInstance(TargetLanguageOption.class));
        genOpts.add(Options.getInstance(CodePrefixOption.class));
        List genSubCats = Lists.list((Object[])new OptionCategory[]{simulinkCat, javaCat});
        OptionCategory genCat = new OptionCategory("Generation", "Generation options.", genSubCats, genOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, genCat});
        OptionCategory options = new OptionCategory("CIF Code Generator Options", "All options for the CIF code generator.", cats, Lists.list());
        return options;
    }
}

