/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.options;

import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSpec;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.StringOption;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Strings;

public class InteractiveAutoChooseOption
extends StringOption {
    private static final Pattern FILTER_PATTERN = Pattern.compile("[a-zA-Z_*][a-zA-Z0-9_*]*(\\.[a-zA-Z_*][a-zA-Z0-9_*]*)*");

    public InteractiveAutoChooseOption() {
        super("Interactive mode automatic transition choice", "Option to use in interactive input mode, to make it semi-automatic, by automatically choosing certain transitions. If no automatic choices are available, the user is still asked to choose interactively. Specify comma separated filters for AUTOC. The filters may be absolute names of events, \"urgent\", \"time\", \"timedur\", or \"1\". The \"*\" character can be used as wildcard in event names, and indicates zero or more characters. Use \"urgent\" to automatically choose transitions for all urgent events. Use \"time\" to automatically choose time transitions. Use \"timedur\" to automatically choose the delay duration for time transitions. Use \"1\" to automatically choose the one available transition in case it is the only one possible. If multiple transitions can be automatically chosen, the choice is made using the automatic input mode. [DEFAULT=\"\"]", null, "auto-choose", "AUTOC", "", false, true, "Option to use in interactive input mode, to make it semi-automatic, by automatically choosing certain transitions. If no automatic choices are available, the user is still asked to choose interactively. Specify comma separated filters for AUTOC. The filters may be absolute names of events, \"urgent\", \"time\", \"timedur\", or \"1\". The \"*\" character can be used as wildcard in event names, and indicates zero or more characters. Use \"urgent\" to automatically choose transitions for all urgent events. Use \"time\" to automatically choose time transitions. Use \"timedur\" to automatically choose the delay duration for time transitions. Use \"1\" to automatically choose the one available transition in case it is the only one possible. If multiple transitions can be automatically chosen, the choice is made using the automatic input mode.", null);
    }

    public static boolean isSpecified() {
        String value = (String)Options.get(InteractiveAutoChooseOption.class);
        return !value.isEmpty();
    }

    public static String[] getFilters() {
        String value = (String)Options.get(InteractiveAutoChooseOption.class);
        String[] filters = StringUtils.split((String)value, (String)",");
        int i = 0;
        while (i < filters.length) {
            filters[i] = filters[i].trim();
            if (!filters[i].equals("1") && !FILTER_PATTERN.matcher(filters[i]).matches()) {
                String msg = Strings.fmt((String)"Interactive mode automatic transition choice filter \"%s\" has invalid syntax.", (Object[])new Object[]{filters[i]});
                throw new InvalidOptionException(msg);
            }
            ++i;
        }
        return filters;
    }

    public static boolean autoChooseSingle(String[] filters) {
        return ArrayUtils.contains((Object[])filters, (Object)"1");
    }

    public static boolean autoChooseTime(String[] filters) {
        return ArrayUtils.contains((Object[])filters, (Object)"time");
    }

    public static boolean autoChooseTimeDur(String[] filters) {
        return ArrayUtils.contains((Object[])filters, (Object)"timedur");
    }

    public static <S extends RuntimeState> boolean[] autoChooseEvents(RuntimeSpec<?> spec, String[] filters) {
        boolean[] rslt = new boolean[spec.events.size()];
        if (filters.length == 0) {
            return rslt;
        }
        String[] names = new String[spec.events.size()];
        int i = 0;
        while (i < names.length) {
            names[i] = spec.events.get((int)i).name.replace("$", "");
            ++i;
        }
        String[] stringArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (!(filter.equals("1") || filter.equals("time") || filter.equals("timedur"))) {
                boolean match = false;
                boolean effect = false;
                if (filter.equals("urgent")) {
                    int i2 = 0;
                    while (i2 < spec.events.size()) {
                        if (spec.urgent[i2]) {
                            if (!rslt[i2]) {
                                effect = true;
                            }
                            rslt[i2] = true;
                            match = true;
                        }
                        ++i2;
                    }
                } else {
                    String regEx = filter.replace(".", "\\.");
                    regEx = regEx.replace("*", ".*");
                    Pattern pattern = Pattern.compile("^" + regEx + "$");
                    int i3 = 0;
                    while (i3 < names.length) {
                        if (pattern.matcher(names[i3]).matches()) {
                            if (!rslt[i3]) {
                                effect = true;
                            }
                            rslt[i3] = true;
                            match = true;
                        }
                        ++i3;
                    }
                }
                if (!match) {
                    String msg = Strings.fmt((String)"Interactive mode automatic transition choice filter \"%s\" does not match any of the events in the specification.", (Object[])new Object[]{filter});
                    if (filter.equals("urgent")) {
                        msg = String.valueOf(msg) + " None of the events of the specification are simulated as urgent.";
                    }
                    OutputProvider.warn((String)msg);
                } else if (!effect) {
                    String msg = Strings.fmt((String)"Interactive mode automatic transition choice filter \"%s\" does not have any effect. The matched events were already automatically chosen due to an earlier filter.", (Object[])new Object[]{filter});
                    OutputProvider.warn((String)msg);
                }
            }
            ++n2;
        }
        return rslt;
    }
}

