/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.scopes;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifExtFuncUtils;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.parser.ast.AEquation;
import org.eclipse.escet.cif.parser.ast.iodecls.AIoDecl;
import org.eclipse.escet.cif.parser.ast.iodecls.print.APrint;
import org.eclipse.escet.cif.parser.ast.iodecls.print.APrintFile;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgCopy;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgFile;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgIn;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgMove;
import org.eclipse.escet.cif.parser.ast.iodecls.svg.ASvgOut;
import org.eclipse.escet.cif.parser.ast.tokens.AStringToken;
import org.eclipse.escet.cif.typechecker.SourceFile;
import org.eclipse.escet.cif.typechecker.SymbolTableEntry;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.FunctionScope;
import org.eclipse.escet.cif.typechecker.scopes.GroupScope;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.cif.typechecker.scopes.SpecScope;
import org.eclipse.escet.cif.typechecker.scopes.SymbolScope;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;

public class SymbolScopeMerger {
    private SymbolScopeMerger() {
    }

    public static SpecScope mergeSpecs(SpecScope mainScope, SourceFile mainSource, SpecScope impScope, SourceFile impSource) {
        SymbolScopeMerger.fixRelativePaths(impScope, mainSource, impSource);
        SymbolScopeMerger.mergeScopes(mainScope, impScope, mainSource, impSource);
        return mainScope;
    }

    private static void mergeScopes(ParentScope<?> mainScope, ParentScope<?> impScope, SourceFile mainSource, SourceFile impSource) {
        Assert.check((mainScope instanceof SpecScope && impScope instanceof SpecScope || mainScope instanceof GroupScope && impScope instanceof GroupScope ? 1 : 0) != 0);
        SymbolScopeMerger.mergeChildDecls(mainScope, impScope);
        SymbolScopeMerger.mergeChildScopes(mainScope, impScope, mainSource, impSource);
        SymbolScopeMerger.mergeEquations(mainScope, impScope);
        SymbolScopeMerger.mergeIoDecls(mainScope, impScope, mainSource, impSource);
        mainScope.astInitPreds.addAll(impScope.astInitPreds);
        mainScope.astInvs.addAll(impScope.astInvs);
        mainScope.astMarkerPreds.addAll(impScope.astMarkerPreds);
    }

    private static void mergeChildDecls(ParentScope<?> mainScope, ParentScope<?> impScope) {
        Group mainGroup = mainScope.getGroup();
        EList mainDecls = mainGroup.getDeclarations();
        for (DeclWrap<?> declWrap : impScope.declarations.values()) {
            mainScope.addDeclaration(declWrap);
            declWrap.changeParent(mainScope);
            Object decl = declWrap.getObject();
            if (decl instanceof Declaration) {
                mainDecls.add((Declaration)decl);
                continue;
            }
            if (decl instanceof EnumLiteral) continue;
            throw new RuntimeException("Unexpected child decl: " + decl);
        }
    }

    private static void mergeChildScopes(ParentScope<?> mainScope, ParentScope<?> impScope, SourceFile mainSource, SourceFile impSource) {
        Group mainGroup = mainScope.getGroup();
        EList mainDecls = mainGroup.getDeclarations();
        EList mainComps = mainGroup.getComponents();
        EList mainDefs = mainGroup.getDefinitions();
        for (SymbolScope<?> childScope : impScope.children.values()) {
            SymbolTableEntry entry;
            String name = childScope.getName();
            if (childScope instanceof GroupScope && mainScope.defines(name) && (entry = mainScope.getEntry(name)) instanceof GroupScope) {
                SymbolScopeMerger.mergeScopes((GroupScope)entry, (GroupScope)childScope, mainSource, impSource);
                continue;
            }
            mainScope.addChildScope(childScope);
            childScope.changeParent(mainScope);
            Object childObj = childScope.getObject();
            if (childObj instanceof Component) {
                mainComps.add((Component)childObj);
                continue;
            }
            if (childObj instanceof ComponentDef) {
                mainDefs.add((ComponentDef)childObj);
                continue;
            }
            if (childObj instanceof Declaration) {
                mainDecls.add((Declaration)childObj);
                continue;
            }
            throw new RuntimeException("Unknown child obj: " + childObj);
        }
    }

    private static void mergeEquations(ParentScope<?> mainScope, ParentScope<?> impScope) {
        Set<Map.Entry<String, List<AEquation>>> impEqnPairs = impScope.astEquations.entrySet();
        for (Map.Entry<String, List<AEquation>> impEqnPair : impEqnPairs) {
            String name = impEqnPair.getKey();
            List<AEquation> impEqns = impEqnPair.getValue();
            List<AEquation> mainEqns = mainScope.astEquations.get(name);
            if (mainEqns == null) {
                mainScope.astEquations.put(name, impEqns);
                continue;
            }
            mainEqns.addAll(impEqns);
        }
        Assert.check((boolean)mainScope.mmEquations.isEmpty());
        Assert.check((boolean)impScope.mmEquations.isEmpty());
    }

    private static void mergeIoDecls(ParentScope<?> mainScope, ParentScope<?> impScope, SourceFile mainSource, SourceFile impSource) {
        String path;
        Map svgFileDeclsMain = Maps.map();
        Map svgFileDeclsImp = Maps.map();
        Map printFileDeclsMain = Maps.map();
        Map printFileDeclsImp = Maps.map();
        for (AIoDecl ioDecl : mainScope.astIoDecls) {
            if (ioDecl instanceof ASvgFile) {
                path = ((ASvgFile)ioDecl).svgPath.txt;
                path = mainSource.resolve(path);
                svgFileDeclsMain.put(path, ioDecl);
                continue;
            }
            if (!(ioDecl instanceof APrintFile)) continue;
            path = ((APrintFile)ioDecl).path.txt;
            if (!path.startsWith(":")) {
                path = mainSource.resolve(path);
            }
            printFileDeclsMain.put(path, ioDecl);
        }
        for (AIoDecl ioDecl : impScope.astIoDecls) {
            if (ioDecl instanceof ASvgFile) {
                path = ((ASvgFile)ioDecl).svgPath.txt;
                path = impSource.resolve(path);
                svgFileDeclsImp.put(path, ioDecl);
                continue;
            }
            if (!(ioDecl instanceof APrintFile)) continue;
            path = ((APrintFile)ioDecl).path.txt;
            if (!path.startsWith(":")) {
                path = impSource.resolve(path);
            }
            printFileDeclsImp.put(path, ioDecl);
        }
        svgFileDeclsImp.keySet().retainAll(svgFileDeclsMain.keySet());
        printFileDeclsImp.keySet().retainAll(printFileDeclsMain.keySet());
        for (AIoDecl ioDecl : svgFileDeclsImp.values()) {
            impScope.astIoDecls.remove(ioDecl);
        }
        for (AIoDecl ioDecl : printFileDeclsImp.values()) {
            impScope.astIoDecls.remove(ioDecl);
        }
        mainScope.astIoDecls.addAll(impScope.astIoDecls);
    }

    private static void fixRelativePaths(ParentScope<?> scope, SourceFile mainSource, SourceFile impSource) {
        for (SymbolScope<?> child : scope.children.values()) {
            if (child instanceof FunctionScope) {
                FunctionScope fscope = (FunctionScope)child;
                if (fscope.obj instanceof InternalFunction) continue;
                SymbolScopeMerger.fixRelativePaths((ExternalFunction)fscope.obj, mainSource, impSource);
                continue;
            }
            if (!(child instanceof ParentScope)) continue;
            SymbolScopeMerger.fixRelativePaths((ParentScope)child, mainSource, impSource);
        }
        int i = 0;
        while (i < scope.astIoDecls.size()) {
            AIoDecl ioDecl = scope.astIoDecls.get(i);
            ioDecl = SymbolScopeMerger.fixRelativePaths(ioDecl, mainSource, impSource);
            scope.astIoDecls.set(i, ioDecl);
            ++i;
        }
    }

    private static void fixRelativePaths(ExternalFunction func, SourceFile mainSource, SourceFile impSource) {
        String extRef = func.getFunction();
        String mainSpecDir = mainSource.getAbsDirPath();
        String impSpecDir = impSource.getAbsDirPath();
        extRef = CifExtFuncUtils.updateExtRefRelPaths((String)extRef, (String)impSpecDir, (String)mainSpecDir);
        func.setFunction(extRef);
    }

    private static AIoDecl fixRelativePaths(AIoDecl ioDecl, SourceFile mainSource, SourceFile impSource) {
        if (ioDecl instanceof ASvgFile) {
            ASvgFile svgFile = (ASvgFile)ioDecl;
            String path = svgFile.svgPath.txt;
            path = impSource.resolve(path);
            path = mainSource.getRelativePathTo(path);
            AStringToken newToken = new AStringToken(path, svgFile.svgPath.position, false);
            svgFile = new ASvgFile(newToken, svgFile.position);
            return svgFile;
        }
        if (ioDecl instanceof ASvgCopy) {
            ASvgCopy svgCopy = (ASvgCopy)ioDecl;
            if (svgCopy.svgFile == null) {
                return ioDecl;
            }
            ASvgFile svgFile = svgCopy.svgFile;
            svgFile = (ASvgFile)SymbolScopeMerger.fixRelativePaths((AIoDecl)svgFile, mainSource, impSource);
            svgCopy = new ASvgCopy(svgCopy.svgId, svgCopy.pre, svgCopy.post, svgFile, svgCopy.position);
            return svgCopy;
        }
        if (ioDecl instanceof ASvgMove) {
            ASvgMove svgMove = (ASvgMove)ioDecl;
            if (svgMove.svgFile == null) {
                return ioDecl;
            }
            ASvgFile svgFile = svgMove.svgFile;
            svgFile = (ASvgFile)SymbolScopeMerger.fixRelativePaths((AIoDecl)svgFile, mainSource, impSource);
            svgMove = new ASvgMove(svgMove.svgId, svgMove.x, svgMove.y, svgFile, svgMove.position);
            return svgMove;
        }
        if (ioDecl instanceof ASvgOut) {
            ASvgOut svgOut = (ASvgOut)ioDecl;
            if (svgOut.svgFile == null) {
                return ioDecl;
            }
            ASvgFile svgFile = svgOut.svgFile;
            svgFile = (ASvgFile)SymbolScopeMerger.fixRelativePaths((AIoDecl)svgFile, mainSource, impSource);
            svgOut = new ASvgOut(svgOut.svgId, svgOut.svgAttr, svgOut.svgTextPos, svgOut.value, svgFile, svgOut.position);
            return svgOut;
        }
        if (ioDecl instanceof ASvgIn) {
            ASvgIn svgIn = (ASvgIn)ioDecl;
            if (svgIn.svgFile == null) {
                return ioDecl;
            }
            ASvgFile svgFile = svgIn.svgFile;
            svgFile = (ASvgFile)SymbolScopeMerger.fixRelativePaths((AIoDecl)svgFile, mainSource, impSource);
            svgIn = new ASvgIn(svgIn.svgId, svgIn.event, svgFile, svgIn.position);
            return svgIn;
        }
        if (ioDecl instanceof APrintFile) {
            APrintFile printFile = (APrintFile)ioDecl;
            if (printFile.path.txt.startsWith(":")) {
                return ioDecl;
            }
            String path = printFile.path.txt;
            path = impSource.resolve(path);
            path = mainSource.getRelativePathTo(path);
            AStringToken newToken = new AStringToken(path, printFile.path.position, false);
            printFile = new APrintFile(newToken, printFile.position);
            return printFile;
        }
        if (ioDecl instanceof APrint) {
            APrint print = (APrint)ioDecl;
            if (print.file == null) {
                return ioDecl;
            }
            APrintFile printFile = print.file;
            if (printFile.path.txt.startsWith(":")) {
                return ioDecl;
            }
            printFile = (APrintFile)SymbolScopeMerger.fixRelativePaths((AIoDecl)printFile, mainSource, impSource);
            print = new APrint(print.txt, print.fors, print.when, printFile, print.position);
            return print;
        }
        throw new RuntimeException("Unknown I/O decl: " + ioDecl);
    }
}

