/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif.app;

import java.util.List;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.cif2cif.app.CifToCifTransOption;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class CifToCifApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        CifToCifApp app = new CifToCifApp();
        app.run(args);
    }

    public CifToCifApp() {
    }

    public CifToCifApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF transformer";
    }

    public String getAppDescription() {
        return "Transforms CIF files by applying some CIF to CIF transformations.";
    }

    protected int runInternal() {
        CifReader cifReader = (CifReader)new CifReader().init();
        Specification spec = (Specification)cifReader.read();
        if (this.isTerminationRequested()) {
            return 0;
        }
        List<CifToCifTransformation> transformations = CifToCifTransOption.getTransformations();
        for (CifToCifTransformation trans : transformations) {
            try {
                trans.transform(spec);
                if (!this.isTerminationRequested()) continue;
                return 0;
            }
            catch (CifToCifPreconditionException ex) {
                String msg = Strings.fmt((String)"File \"%s\": Unsatisfied precondition for CIF to CIF transformation.", (Object[])new Object[]{InputFileOption.getPath()});
                throw new InvalidInputException(msg, (Throwable)ex);
            }
        }
        String outPath = OutputFileOption.getDerivedPath((String)".cif", (String)".transformed.cif");
        outPath = Paths.resolve((String)outPath);
        CifWriter.writeCifSpec((Specification)spec, (String)outPath, (String)cifReader.getAbsDirPath());
        return 0;
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalOpts = CifToCifApp.getGeneralOptionCategory();
        OptionCategory transOpts = new OptionCategory("Transformations", "Transformation options.", Lists.list(), Lists.list((Object[])new Option[]{Options.getInstance(InputFileOption.class), Options.getInstance(OutputFileOption.class), Options.getInstance(CifToCifTransOption.class)}));
        OptionCategory options = new OptionCategory("CIF Transformer Options", "All options for the CIF transformer.", Lists.list((Object[])new OptionCategory[]{generalOpts, transOpts}), Lists.list());
        return options;
    }
}

