/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.parser.ast.scanner;

import java.util.Comparator;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.setext.parser.ast.Identifier;
import org.eclipse.escet.setext.parser.ast.Symbol;
import org.eclipse.escet.setext.parser.ast.TerminalDescription;
import org.eclipse.escet.setext.parser.ast.regex.RegEx;
import org.eclipse.escet.setext.parser.ast.regex.RegExChar;

public class Terminal
extends Symbol {
    public Identifier state = null;
    public final RegEx regEx;
    public final Identifier func;
    public final Identifier newState;
    public final TerminalDescription description;
    public int priority = -1;
    public static final PriorityComparer PRIORITY_COMPARER = new PriorityComparer();
    public static final NameComparer NAME_COMPARER = new NameComparer();

    public Terminal(String name, RegEx regEx, Identifier func, Identifier newState, TerminalDescription description, Position position) {
        super(name, position);
        this.regEx = regEx;
        this.func = func;
        this.newState = newState;
        this.description = description;
        Assert.notNull((Object)regEx);
        boolean isEof = this.isEof();
        Assert.implies((boolean)isEof, (name == null ? 1 : 0) != 0);
        Assert.implies((boolean)isEof, (func == null ? 1 : 0) != 0);
        Assert.implies((boolean)isEof, (newState == null ? 1 : 0) != 0);
        Assert.implies((boolean)isEof, (description == null ? 1 : 0) != 0);
    }

    public boolean isEof() {
        return this.regEx instanceof RegExChar && ((RegExChar)this.regEx).isEof();
    }

    public String getStateName() {
        return this.state == null ? "" : this.state.id;
    }

    public String getNewStateName() {
        return this.newState == null ? this.getStateName() : this.newState.id;
    }

    public String toString() {
        return Strings.fmt((String)"Terminal(%s\"%s\" [\"%s\" -> \"%s\"]%s prio=%d)", (Object[])new Object[]{this.name == null ? "" : String.valueOf(this.name) + "=", this.regEx.toString(), this.getStateName(), this.getNewStateName(), this.func == null ? "" : " {" + this.func.id + "}", this.priority});
    }

    protected static class NameComparer
    implements Comparator<Terminal> {
        protected NameComparer() {
        }

        @Override
        public int compare(Terminal o1, Terminal o2) {
            if (o1.name == null && o2.name == null) {
                return 0;
            }
            if (o1.name == null && o2.name != null) {
                return -1;
            }
            if (o1.name != null && o2.name == null) {
                return 1;
            }
            return Strings.SORTER.compare(o1.name, o2.name);
        }
    }

    protected static class PriorityComparer
    implements Comparator<Terminal> {
        protected PriorityComparer() {
        }

        @Override
        public int compare(Terminal o1, Terminal o2) {
            Integer prio1 = o1.priority;
            return prio1.compareTo(o2.priority);
        }
    }
}

