/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.parser.ast.regex;

import java.util.Set;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.setext.parser.ast.regex.RegExChars;

public class RegExChar
extends RegExChars {
    public final int character;

    public RegExChar(int character, Position position) {
        super(position);
        this.character = character;
    }

    @Override
    public boolean acceptsEmptyString() {
        return false;
    }

    @Override
    public Set<Integer> getCodePoints() {
        return Sets.set((Object)this.character);
    }

    @Override
    public Set<RegExChar> getChars() {
        return Sets.set((Object)this);
    }

    @Override
    public boolean isDescriptionText() {
        if (this.isCustomMarker()) {
            throw new RuntimeException("Unexpected custom marker: " + this);
        }
        if (this.isEof()) {
            return false;
        }
        return Strings.isGraphicCodePoint((int)this.character);
    }

    @Override
    public String getDescriptionText() {
        if (this.isCustomMarker()) {
            throw new RuntimeException("Unexpected custom marker: " + this);
        }
        if (this.isEof()) {
            return null;
        }
        if (Strings.isGraphicCodePoint((int)this.character)) {
            return Strings.codePointToStr((int)this.character);
        }
        return null;
    }

    public boolean isEof() {
        return this.character == -1;
    }

    public boolean isMarker() {
        return this.character < 0;
    }

    public boolean isCustomMarker() {
        return this.character < -1;
    }

    @Override
    public int getBindingStrength() {
        return 3;
    }

    @Override
    public String toString() {
        switch (this.character) {
            case -1: {
                return "\u00b6";
            }
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 34: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 63: 
            case 91: 
            case 93: 
            case 94: 
            case 123: 
            case 124: 
            case 125: {
                return "\\" + (char)this.character;
            }
        }
        if (this.character < 0) {
            return Strings.fmt((String)"\u00ab%d\u00bb", (Object[])new Object[]{this.character});
        }
        return Strings.codePointToStr((int)this.character);
    }
}

