/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.conn.gmf.layouter;

import java.util.HashMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.elk.conn.gmf.layouter.Draw2DOptions;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class Draw2DLayoutProvider
extends AbstractLayoutProvider {
    public static final String PARAM_COMPOUND = "Compound";
    private static final double DEF_MIN_SPACING = 16.0;
    private boolean compoundMode = false;

    public void initialize(String parameter) {
        this.compoundMode = PARAM_COMPOUND.equals(parameter);
    }

    public void layout(ElkNode layoutNode, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Draw2D Directed Graph layout", 1.0f);
        DirectedGraph graph = this.buildDraw2dGraph(layoutNode);
        CompoundDirectedGraphLayout draw2dLayout = this.compoundMode ? new CompoundDirectedGraphLayout() : new DirectedGraphLayout();
        draw2dLayout.visit(graph);
        this.applyLayout(layoutNode, graph);
        progressMonitor.done();
    }

    private DirectedGraph buildDraw2dGraph(ElkNode layoutNode) {
        DirectedGraph graph = new DirectedGraph();
        double minSpacing = (Double)layoutNode.getProperty(Draw2DOptions.SPACING_NODE_NODE);
        if (minSpacing < 0.0) {
            minSpacing = 16.0;
        }
        graph.setDefaultPadding(new Insets((int)minSpacing));
        ElkPadding padding = (ElkPadding)layoutNode.getProperty(Draw2DOptions.PADDING);
        graph.setMargin(new Insets((int)padding.top, (int)padding.left, (int)padding.bottom, (int)padding.right));
        Direction layoutDirection = (Direction)layoutNode.getProperty(Draw2DOptions.DIRECTION);
        switch (layoutDirection) {
            case DOWN: 
            case UP: {
                graph.setDirection(4);
                break;
            }
            default: {
                graph.setDirection(16);
            }
        }
        HashMap<ElkNode, Node> nodeMap = new HashMap<ElkNode, Node>();
        for (ElkNode elknode : layoutNode.getChildren()) {
            Node draw2dNode = new Node((Object)elknode);
            ElkUtil.resizeNode((ElkNode)elknode);
            draw2dNode.width = (int)elknode.getWidth();
            draw2dNode.height = (int)elknode.getHeight();
            nodeMap.put(elknode, draw2dNode);
            graph.nodes.add((Object)draw2dNode);
        }
        for (ElkNode source : layoutNode.getChildren()) {
            Node draw2dSource = (Node)nodeMap.get(source);
            for (ElkEdge kedge : source.getOutgoingEdges()) {
                ElkNode target;
                Node draw2dTarget;
                if (kedge.isHyperedge() || (draw2dTarget = (Node)nodeMap.get(target = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)kedge.getTargets().get(0))))) == null || draw2dTarget == draw2dSource) continue;
                Edge draw2dEdge = new Edge((Object)kedge, draw2dSource, draw2dTarget);
                graph.edges.add((Object)draw2dEdge);
            }
        }
        return graph;
    }

    private void applyLayout(ElkNode parentNode, DirectedGraph graph) {
        int i = 0;
        while (i < graph.nodes.size()) {
            Node node = graph.nodes.getNode(i);
            if (node.data instanceof ElkNode) {
                ElkNode knode = (ElkNode)node.data;
                knode.setLocation((double)node.x, (double)node.y);
            }
            ++i;
        }
        i = 0;
        while (i < graph.edges.size()) {
            Edge edge = graph.edges.getEdge(i);
            if (edge.data instanceof ElkEdge) {
                ElkEdge kedge = (ElkEdge)edge.data;
                ElkEdgeSection edgeSection = ElkGraphUtil.firstEdgeSection((ElkEdge)kedge, (boolean)true, (boolean)true);
                PointList pointList = edge.getPoints();
                Point startPoint = pointList.getFirstPoint();
                edgeSection.setStartLocation((double)startPoint.x, (double)startPoint.y);
                int j = 1;
                while (j < pointList.size() - 1) {
                    Point point = pointList.getPoint(j);
                    ElkGraphUtil.createBendPoint((ElkEdgeSection)edgeSection, (double)point.x, (double)point.y);
                    ++j;
                }
                Point endPoint = pointList.getFirstPoint();
                edgeSection.setStartLocation((double)endPoint.x, (double)endPoint.y);
            }
            ++i;
        }
        ElkPadding insets = (ElkPadding)parentNode.getProperty(Draw2DOptions.PADDING);
        Dimension layoutSize = graph.getLayoutSize();
        double width = insets.getLeft() + (double)layoutSize.width + insets.getRight();
        double height = insets.getTop() + (double)layoutSize.height + insets.getBottom();
        ElkUtil.resizeNode((ElkNode)parentNode, (double)width, (double)height, (boolean)false, (boolean)true);
    }
}

