/*
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.lsat.common.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class StackedIterator<E> implements Iterator<E> {
    private final LinkedList<Iterator<? extends E>> sources = new LinkedList<>();

    public StackedIterator(Iterator<? extends E> source) {
        sources.offerFirst(source);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        while (!sources.isEmpty()) {
            if (sources.peekFirst().hasNext()) {
                return true;
            }
            sources.pollFirst();
        }
        return false;
    }

    @Override
    public E next() {
        if (!hasNext()) {
            throw new NoSuchElementException();
        }
        E next = sources.peekFirst().next();
        return next;
    }

    public void push(Iterator<? extends E> iterator) {
        sources.offerFirst(iterator);
    }

    public void pop() {
        sources.removeFirst();
    }
}
