/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.meanpayoff.solvers.zwick;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.fraction.Fraction;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Triple;
import org.eclipse.lsat.common.ludus.backend.games.meanpayoff.MeanPayoffGame;
import org.eclipse.lsat.common.ludus.backend.games.meanpayoff.solvers.zwick.ZwickPatersonInt;

public class ZPSolverInt {
    private ZPSolverInt() {
    }

    public static <V, E> Triple<Set<V>, Set<V>, Set<V>> getThreeWayPartition(MeanPayoffGame<V, E, Integer> game, Fraction payoffValue) {
        Map estimateMap = ZwickPatersonInt.computeEstimate(game);
        HashSet smaller = new HashSet();
        HashSet equal = new HashSet();
        HashSet larger = new HashSet();
        game.getVertices().forEach(v -> {
            Fraction vertexValue = (Fraction)estimateMap.get(v);
            Integer n = game.getVertices().size();
            Fraction delta = n <= 1 ? Fraction.ZERO : new Fraction(1, 2 * n * (n - 1));
            Fraction leftEqualBound = payoffValue.subtract(delta);
            Fraction rightEqualBound = payoffValue.add(delta);
            if (vertexValue.compareTo(leftEqualBound) < 0) {
                smaller.add(v);
            } else if (vertexValue.compareTo(rightEqualBound) > 0) {
                larger.add(v);
            } else {
                equal.add(v);
            }
        });
        return Triple.of(smaller, equal, larger);
    }

    public static <V, E> Map<V, Fraction> getValues(MeanPayoffGame<V, E, Integer> game) {
        return ZwickPatersonInt.solve(game);
    }
}

