/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
grammar InternalActivity;

options {
	superClass=AbstractInternalAntlrParser;
}

@lexer::header {
package org.eclipse.lsat.activity.teditor.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package org.eclipse.lsat.activity.teditor.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import org.eclipse.lsat.activity.teditor.services.ActivityGrammarAccess;

}

@parser::members {

 	private ActivityGrammarAccess grammarAccess;

    public InternalActivityParser(TokenStream input, ActivityGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "ActivitySet";
   	}

   	@Override
   	protected ActivityGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRuleActivitySet
entryRuleActivitySet returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getActivitySetRule()); }
	iv_ruleActivitySet=ruleActivitySet
	{ $current=$iv_ruleActivitySet.current; }
	EOF;

// Rule ActivitySet
ruleActivitySet returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getActivitySetAccess().getActivitySetAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getActivitySetAccess().getImportsImportParserRuleCall_1_0());
				}
				lv_imports_1_0=ruleImport
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getActivitySetRule());
					}
					add(
						$current,
						"imports",
						lv_imports_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.Import");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				{
					newCompositeNode(grammarAccess.getActivitySetAccess().getActivitiesActivityParserRuleCall_2_0());
				}
				lv_activities_2_0=ruleActivity
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getActivitySetRule());
					}
					add(
						$current,
						"activities",
						lv_activities_2_0,
						"org.eclipse.lsat.activity.teditor.Activity.Activity");
					afterParserOrEnumRuleCall();
				}
			)
		)*
	)
;

// Entry rule entryRuleImport
entryRuleImport returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getImportRule()); }
	iv_ruleImport=ruleImport
	{ $current=$iv_ruleImport.current; }
	EOF;

// Rule Import
ruleImport returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='import'
		{
			newLeafNode(otherlv_0, grammarAccess.getImportAccess().getImportKeyword_0());
		}
		(
			(
				lv_importURI_1_0=RULE_STRING
				{
					newLeafNode(lv_importURI_1_0, grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getImportRule());
					}
					setWithLastConsumed(
						$current,
						"importURI",
						lv_importURI_1_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
	)
;

// Entry rule entryRuleActivity
entryRuleActivity returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getActivityRule()); }
	iv_ruleActivity=ruleActivity
	{ $current=$iv_ruleActivity.current; }
	EOF;

// Rule Activity
ruleActivity returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='activity'
		{
			newLeafNode(otherlv_0, grammarAccess.getActivityAccess().getActivityKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getActivityAccess().getNameIIDParserRuleCall_1_0());
				}
				lv_name_1_0=ruleIID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getActivityRule());
					}
					set(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.IID");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='{'
		{
			newLeafNode(otherlv_2, grammarAccess.getActivityAccess().getLeftCurlyBracketKeyword_2());
		}
		(
			otherlv_3='prerequisites'
			{
				newLeafNode(otherlv_3, grammarAccess.getActivityAccess().getPrerequisitesKeyword_3_0());
			}
			otherlv_4='{'
			{
				newLeafNode(otherlv_4, grammarAccess.getActivityAccess().getLeftCurlyBracketKeyword_3_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getActivityAccess().getPrerequisitesLocationPrerequisiteParserRuleCall_3_2_0());
					}
					lv_prerequisites_5_0=ruleLocationPrerequisite
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getActivityRule());
						}
						add(
							$current,
							"prerequisites",
							lv_prerequisites_5_0,
							"org.eclipse.lsat.activity.teditor.Activity.LocationPrerequisite");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_6='}'
			{
				newLeafNode(otherlv_6, grammarAccess.getActivityAccess().getRightCurlyBracketKeyword_3_3());
			}
		)?
		otherlv_7='actions'
		{
			newLeafNode(otherlv_7, grammarAccess.getActivityAccess().getActionsKeyword_4());
		}
		otherlv_8='{'
		{
			newLeafNode(otherlv_8, grammarAccess.getActivityAccess().getLeftCurlyBracketKeyword_5());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getActivityAccess().getNodesNodeParserRuleCall_6_0());
				}
				lv_nodes_9_0=ruleNode
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getActivityRule());
					}
					add(
						$current,
						"nodes",
						lv_nodes_9_0,
						"org.eclipse.lsat.activity.teditor.Activity.Node");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_10='}'
		{
			newLeafNode(otherlv_10, grammarAccess.getActivityAccess().getRightCurlyBracketKeyword_7());
		}
		otherlv_11='action flow'
		{
			newLeafNode(otherlv_11, grammarAccess.getActivityAccess().getActionFlowKeyword_8());
		}
		otherlv_12='{'
		{
			newLeafNode(otherlv_12, grammarAccess.getActivityAccess().getLeftCurlyBracketKeyword_9());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getActivityAccess().getEdgesEdgesParserRuleCall_10_0());
				}
				lv_edges_13_0=ruleEdges
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getActivityRule());
					}
					add(
						$current,
						"edges",
						lv_edges_13_0,
						"org.eclipse.lsat.activity.teditor.Activity.Edges");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_14='}'
		{
			newLeafNode(otherlv_14, grammarAccess.getActivityAccess().getRightCurlyBracketKeyword_11());
		}
		otherlv_15='}'
		{
			newLeafNode(otherlv_15, grammarAccess.getActivityAccess().getRightCurlyBracketKeyword_12());
		}
	)
;

// Entry rule entryRuleResourceQualifiedName
entryRuleResourceQualifiedName returns [String current=null]:
	{ newCompositeNode(grammarAccess.getResourceQualifiedNameRule()); }
	iv_ruleResourceQualifiedName=ruleResourceQualifiedName
	{ $current=$iv_ruleResourceQualifiedName.current.getText(); }
	EOF;

// Rule ResourceQualifiedName
ruleResourceQualifiedName returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getResourceQualifiedNameAccess().getIIDParserRuleCall_0());
		}
		this_IID_0=ruleIID
		{
			$current.merge(this_IID_0);
		}
		{
			afterParserOrEnumRuleCall();
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getResourceQualifiedNameAccess().getFullStopKeyword_1_0());
			}
			{
				newCompositeNode(grammarAccess.getResourceQualifiedNameAccess().getIIDParserRuleCall_1_1());
			}
			this_IID_2=ruleIID
			{
				$current.merge(this_IID_2);
			}
			{
				afterParserOrEnumRuleCall();
			}
		)?
	)
;

// Entry rule entryRuleLocationPrerequisite
entryRuleLocationPrerequisite returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLocationPrerequisiteRule()); }
	iv_ruleLocationPrerequisite=ruleLocationPrerequisite
	{ $current=$iv_ruleLocationPrerequisite.current; }
	EOF;

// Rule LocationPrerequisite
ruleLocationPrerequisite returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getLocationPrerequisiteRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getLocationPrerequisiteAccess().getResourceIResourceCrossReference_0_0());
				}
				ruleResourceQualifiedName
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_1='.'
		{
			newLeafNode(otherlv_1, grammarAccess.getLocationPrerequisiteAccess().getFullStopKeyword_1());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getLocationPrerequisiteRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getLocationPrerequisiteAccess().getPeripheralPeripheralCrossReference_2_0());
				}
				ruleIID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_3='at'
		{
			newLeafNode(otherlv_3, grammarAccess.getLocationPrerequisiteAccess().getAtKeyword_3());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getLocationPrerequisiteRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getLocationPrerequisiteAccess().getPositionSymbolicPositionCrossReference_4_0());
				}
				ruleIID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleNode
entryRuleNode returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNodeRule()); }
	iv_ruleNode=ruleNode
	{ $current=$iv_ruleNode.current; }
	EOF;

// Rule Node
ruleNode returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getNodeAccess().getClaimParserRuleCall_0());
		}
		this_Claim_0=ruleClaim
		{
			$current = $this_Claim_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getNodeAccess().getReleaseParserRuleCall_1());
		}
		this_Release_1=ruleRelease
		{
			$current = $this_Release_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getNodeAccess().getSimpleActionParserRuleCall_2());
		}
		this_SimpleAction_2=ruleSimpleAction
		{
			$current = $this_SimpleAction_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getNodeAccess().getMoveParserRuleCall_3());
		}
		this_Move_3=ruleMove
		{
			$current = $this_Move_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getNodeAccess().getRequireEventParserRuleCall_4());
		}
		this_RequireEvent_4=ruleRequireEvent
		{
			$current = $this_RequireEvent_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getNodeAccess().getRaiseEventParserRuleCall_5());
		}
		this_RaiseEvent_5=ruleRaiseEvent
		{
			$current = $this_RaiseEvent_5.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleClaim
entryRuleClaim returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getClaimRule()); }
	iv_ruleClaim=ruleClaim
	{ $current=$iv_ruleClaim.current; }
	EOF;

// Rule Claim
ruleClaim returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getClaimAccess().getClaimAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getClaimAccess().getNameIIDParserRuleCall_1_0());
				}
				lv_name_1_0=ruleIID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getClaimRule());
					}
					set(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.IID");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getClaimAccess().getColonKeyword_2());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getClaimAccess().getEntryTracePointParserRuleCall_3_0_0());
					}
					lv_entry_3_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getClaimRule());
						}
						set(
							$current,
							"entry",
							lv_entry_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getClaimAccess().getOuterEntryTracePointParserRuleCall_3_1_0_0());
						}
						lv_outerEntry_4_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getClaimRule());
							}
							set(
								$current,
								"outerEntry",
								lv_outerEntry_4_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getClaimAccess().getEntryTracePointParserRuleCall_3_1_1_0());
						}
						lv_entry_5_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getClaimRule());
							}
							set(
								$current,
								"entry",
								lv_entry_5_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
		(
			(
				lv_passive_6_0='passive'
				{
					newLeafNode(lv_passive_6_0, grammarAccess.getClaimAccess().getPassivePassiveKeyword_4_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getClaimRule());
					}
					setWithLastConsumed($current, "passive", lv_passive_6_0 != null, "passive");
				}
			)
		)?
		otherlv_7='claim'
		{
			newLeafNode(otherlv_7, grammarAccess.getClaimAccess().getClaimKeyword_5());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getClaimRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getClaimAccess().getResourceIResourceCrossReference_6_0());
				}
				ruleResourceQualifiedName
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getClaimAccess().getExitTracePointParserRuleCall_7_0_0());
					}
					lv_exit_9_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getClaimRule());
						}
						set(
							$current,
							"exit",
							lv_exit_9_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getClaimAccess().getExitTracePointParserRuleCall_7_1_0_0());
						}
						lv_exit_10_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getClaimRule());
							}
							set(
								$current,
								"exit",
								lv_exit_10_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getClaimAccess().getOuterExitTracePointParserRuleCall_7_1_1_0());
						}
						lv_outerExit_11_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getClaimRule());
							}
							set(
								$current,
								"outerExit",
								lv_outerExit_11_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
	)
;

// Entry rule entryRuleRelease
entryRuleRelease returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getReleaseRule()); }
	iv_ruleRelease=ruleRelease
	{ $current=$iv_ruleRelease.current; }
	EOF;

// Rule Release
ruleRelease returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getReleaseAccess().getReleaseAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getReleaseAccess().getNameIIDParserRuleCall_1_0());
				}
				lv_name_1_0=ruleIID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getReleaseRule());
					}
					set(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.IID");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getReleaseAccess().getColonKeyword_2());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getReleaseAccess().getEntryTracePointParserRuleCall_3_0_0());
					}
					lv_entry_3_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getReleaseRule());
						}
						set(
							$current,
							"entry",
							lv_entry_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getReleaseAccess().getOuterEntryTracePointParserRuleCall_3_1_0_0());
						}
						lv_outerEntry_4_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getReleaseRule());
							}
							set(
								$current,
								"outerEntry",
								lv_outerEntry_4_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getReleaseAccess().getEntryTracePointParserRuleCall_3_1_1_0());
						}
						lv_entry_5_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getReleaseRule());
							}
							set(
								$current,
								"entry",
								lv_entry_5_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
		otherlv_6='release'
		{
			newLeafNode(otherlv_6, grammarAccess.getReleaseAccess().getReleaseKeyword_4());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getReleaseRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getReleaseAccess().getResourceIResourceCrossReference_5_0());
				}
				ruleResourceQualifiedName
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getReleaseAccess().getExitTracePointParserRuleCall_6_0_0());
					}
					lv_exit_8_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getReleaseRule());
						}
						set(
							$current,
							"exit",
							lv_exit_8_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getReleaseAccess().getExitTracePointParserRuleCall_6_1_0_0());
						}
						lv_exit_9_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getReleaseRule());
							}
							set(
								$current,
								"exit",
								lv_exit_9_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getReleaseAccess().getOuterExitTracePointParserRuleCall_6_1_1_0());
						}
						lv_outerExit_10_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getReleaseRule());
							}
							set(
								$current,
								"outerExit",
								lv_outerExit_10_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
	)
;

// Entry rule entryRuleRaiseEvent
entryRuleRaiseEvent returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRaiseEventRule()); }
	iv_ruleRaiseEvent=ruleRaiseEvent
	{ $current=$iv_ruleRaiseEvent.current; }
	EOF;

// Rule RaiseEvent
ruleRaiseEvent returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getRaiseEventAccess().getRaiseEventAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getRaiseEventAccess().getNameIIDParserRuleCall_1_0());
				}
				lv_name_1_0=ruleIID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRaiseEventRule());
					}
					set(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.IID");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getRaiseEventAccess().getColonKeyword_2());
		}
		otherlv_3='raise'
		{
			newLeafNode(otherlv_3, grammarAccess.getRaiseEventAccess().getRaiseKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRaiseEventAccess().getEventNameIIDParserRuleCall_4_0());
				}
				lv_eventName_4_0=ruleIID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRaiseEventRule());
					}
					set(
						$current,
						"eventName",
						lv_eventName_4_0,
						"org.eclipse.lsat.activity.teditor.Activity.IID");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleRequireEvent
entryRuleRequireEvent returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRequireEventRule()); }
	iv_ruleRequireEvent=ruleRequireEvent
	{ $current=$iv_ruleRequireEvent.current; }
	EOF;

// Rule RequireEvent
ruleRequireEvent returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getRequireEventAccess().getRequireEventAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getRequireEventAccess().getNameIIDParserRuleCall_1_0());
				}
				lv_name_1_0=ruleIID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRequireEventRule());
					}
					set(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.IID");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getRequireEventAccess().getColonKeyword_2());
		}
		otherlv_3='require'
		{
			newLeafNode(otherlv_3, grammarAccess.getRequireEventAccess().getRequireKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRequireEventAccess().getEventNameIIDParserRuleCall_4_0());
				}
				lv_eventName_4_0=ruleIID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRequireEventRule());
					}
					set(
						$current,
						"eventName",
						lv_eventName_4_0,
						"org.eclipse.lsat.activity.teditor.Activity.IID");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleMove
entryRuleMove returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMoveRule()); }
	iv_ruleMove=ruleMove
	{ $current=$iv_ruleMove.current; }
	EOF;

// Rule Move
ruleMove returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getMoveAccess().getMoveAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getMoveAccess().getNameIIDParserRuleCall_1_0());
				}
				lv_name_1_0=ruleIID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMoveRule());
					}
					set(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.IID");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getMoveAccess().getColonKeyword_2());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getMoveAccess().getEntryTracePointParserRuleCall_3_0_0());
					}
					lv_entry_3_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMoveRule());
						}
						set(
							$current,
							"entry",
							lv_entry_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getMoveAccess().getOuterEntryTracePointParserRuleCall_3_1_0_0());
						}
						lv_outerEntry_4_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getMoveRule());
							}
							set(
								$current,
								"outerEntry",
								lv_outerEntry_4_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getMoveAccess().getEntryTracePointParserRuleCall_3_1_1_0());
						}
						lv_entry_5_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getMoveRule());
							}
							set(
								$current,
								"entry",
								lv_entry_5_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
		otherlv_6='move'
		{
			newLeafNode(otherlv_6, grammarAccess.getMoveAccess().getMoveKeyword_4());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMoveRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getMoveAccess().getResourceIResourceCrossReference_5_0());
				}
				ruleResourceQualifiedName
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_8='.'
		{
			newLeafNode(otherlv_8, grammarAccess.getMoveAccess().getFullStopKeyword_6());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMoveRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getMoveAccess().getPeripheralPeripheralCrossReference_7_0());
				}
				ruleIID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				(
					(
						(
							lv_passing_10_0='passing'
							{
								newLeafNode(lv_passing_10_0, grammarAccess.getMoveAccess().getPassingPassingKeyword_8_0_0_0_0());
							}
							{
								if ($current==null) {
									$current = createModelElement(grammarAccess.getMoveRule());
								}
								setWithLastConsumed($current, "passing", lv_passing_10_0 != null, "passing");
							}
						)
					)
					    |
					otherlv_11='to'
					{
						newLeafNode(otherlv_11, grammarAccess.getMoveAccess().getToKeyword_8_0_0_1());
					}
				)
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getMoveRule());
							}
						}
						{
							newCompositeNode(grammarAccess.getMoveAccess().getTargetPositionSymbolicPositionCrossReference_8_0_1_0());
						}
						ruleIID
						{
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
			    |
			(
				(
					(
						(
							lv_continuing_13_0='continuing'
							{
								newLeafNode(lv_continuing_13_0, grammarAccess.getMoveAccess().getContinuingContinuingKeyword_8_1_0_0_0());
							}
							{
								if ($current==null) {
									$current = createModelElement(grammarAccess.getMoveRule());
								}
								setWithLastConsumed($current, "continuing", lv_continuing_13_0 != null, "continuing");
							}
						)
					)
					    |
					otherlv_14='for'
					{
						newLeafNode(otherlv_14, grammarAccess.getMoveAccess().getForKeyword_8_1_0_1());
					}
				)
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getMoveRule());
							}
						}
						{
							newCompositeNode(grammarAccess.getMoveAccess().getDistanceDistanceCrossReference_8_1_1_0());
						}
						ruleIID
						{
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)
		(
			otherlv_16='with speed profile'
			{
				newLeafNode(otherlv_16, grammarAccess.getMoveAccess().getWithSpeedProfileKeyword_9_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getMoveRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getMoveAccess().getProfileProfileCrossReference_9_1_0());
					}
					ruleIID
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getMoveAccess().getSchedulingTypeSchedulingEnumRuleCall_10_0());
				}
				lv_schedulingType_18_0=ruleScheduling
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMoveRule());
					}
					set(
						$current,
						"schedulingType",
						lv_schedulingType_18_0,
						"org.eclipse.lsat.activity.teditor.Activity.Scheduling");
					afterParserOrEnumRuleCall();
				}
			)
		)?
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getMoveAccess().getExitTracePointParserRuleCall_11_0_0());
					}
					lv_exit_19_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMoveRule());
						}
						set(
							$current,
							"exit",
							lv_exit_19_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getMoveAccess().getExitTracePointParserRuleCall_11_1_0_0());
						}
						lv_exit_20_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getMoveRule());
							}
							set(
								$current,
								"exit",
								lv_exit_20_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getMoveAccess().getOuterExitTracePointParserRuleCall_11_1_1_0());
						}
						lv_outerExit_21_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getMoveRule());
							}
							set(
								$current,
								"outerExit",
								lv_outerExit_21_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
	)
;

// Entry rule entryRuleSimpleAction
entryRuleSimpleAction returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSimpleActionRule()); }
	iv_ruleSimpleAction=ruleSimpleAction
	{ $current=$iv_ruleSimpleAction.current; }
	EOF;

// Rule SimpleAction
ruleSimpleAction returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSimpleActionAccess().getSimpleActionAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getSimpleActionAccess().getNameIIDParserRuleCall_1_0());
				}
				lv_name_1_0=ruleIID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
					}
					set(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.IID");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getSimpleActionAccess().getColonKeyword_2());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getSimpleActionAccess().getEntryTracePointParserRuleCall_3_0_0());
					}
					lv_entry_3_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
						}
						set(
							$current,
							"entry",
							lv_entry_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getSimpleActionAccess().getOuterEntryTracePointParserRuleCall_3_1_0_0());
						}
						lv_outerEntry_4_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
							}
							set(
								$current,
								"outerEntry",
								lv_outerEntry_4_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getSimpleActionAccess().getEntryTracePointParserRuleCall_3_1_1_0());
						}
						lv_entry_5_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
							}
							set(
								$current,
								"entry",
								lv_entry_5_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getSimpleActionRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getSimpleActionAccess().getResourceIResourceCrossReference_4_0());
				}
				ruleResourceQualifiedName
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				('.')=>
				otherlv_7='.'
				{
					newLeafNode(otherlv_7, grammarAccess.getSimpleActionAccess().getFullStopKeyword_5_0());
				}
			)
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getSimpleActionRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getSimpleActionAccess().getPeripheralPeripheralCrossReference_5_1_0());
					}
					ruleIID
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_9='.'
			{
				newLeafNode(otherlv_9, grammarAccess.getSimpleActionAccess().getFullStopKeyword_5_2());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getSimpleActionRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getSimpleActionAccess().getTypeActionTypeCrossReference_5_3_0());
					}
					ruleIID
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getSimpleActionAccess().getSchedulingTypeSchedulingEnumRuleCall_6_0());
				}
				lv_schedulingType_11_0=ruleScheduling
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
					}
					set(
						$current,
						"schedulingType",
						lv_schedulingType_11_0,
						"org.eclipse.lsat.activity.teditor.Activity.Scheduling");
					afterParserOrEnumRuleCall();
				}
			)
		)?
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getSimpleActionAccess().getExitTracePointParserRuleCall_7_0_0());
					}
					lv_exit_12_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
						}
						set(
							$current,
							"exit",
							lv_exit_12_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getSimpleActionAccess().getExitTracePointParserRuleCall_7_1_0_0());
						}
						lv_exit_13_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
							}
							set(
								$current,
								"exit",
								lv_exit_13_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getSimpleActionAccess().getOuterExitTracePointParserRuleCall_7_1_1_0());
						}
						lv_outerExit_14_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
							}
							set(
								$current,
								"outerExit",
								lv_outerExit_14_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
	)
;

// Entry rule entryRuleTracePoint
entryRuleTracePoint returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTracePointRule()); }
	iv_ruleTracePoint=ruleTracePoint
	{ $current=$iv_ruleTracePoint.current; }
	EOF;

// Rule TracePoint
ruleTracePoint returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='['
		{
			newLeafNode(otherlv_0, grammarAccess.getTracePointAccess().getLeftSquareBracketKeyword_0());
		}
		(
			(
				lv_regex_1_0='~'
				{
					newLeafNode(lv_regex_1_0, grammarAccess.getTracePointAccess().getRegexTildeKeyword_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getTracePointRule());
					}
					setWithLastConsumed($current, "regex", lv_regex_1_0 != null, "~");
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getTracePointAccess().getValueEStringParserRuleCall_2_0());
				}
				lv_value_2_0=ruleEString
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTracePointRule());
					}
					set(
						$current,
						"value",
						lv_value_2_0,
						"org.eclipse.lsat.activity.teditor.Activity.EString");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_3=']'
		{
			newLeafNode(otherlv_3, grammarAccess.getTracePointAccess().getRightSquareBracketKeyword_3());
		}
	)
;

// Entry rule entryRuleEdges
entryRuleEdges returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEdgesRule()); }
	iv_ruleEdges=ruleEdges
	{ $current=$iv_ruleEdges.current; }
	EOF;

// Rule Edges
ruleEdges returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	{
		newCompositeNode(grammarAccess.getEdgesAccess().getEdgeParserRuleCall());
	}
	this_Edge_0=ruleEdge
	{
		$current = $this_Edge_0.current;
		afterParserOrEnumRuleCall();
	}
;

// Entry rule entryRuleEdge
entryRuleEdge returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEdgeRule()); }
	iv_ruleEdge=ruleEdge
	{ $current=$iv_ruleEdge.current; }
	EOF;

// Rule Edge
ruleEdge returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getEdgeAccess().getEdgeAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getEdgeAccess().getSourceSourceReferenceParserRuleCall_1_0());
				}
				lv_source_1_0=ruleSourceReference
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEdgeRule());
					}
					set(
						$current,
						"source",
						lv_source_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.SourceReference");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='->'
		{
			newLeafNode(otherlv_2, grammarAccess.getEdgeAccess().getHyphenMinusGreaterThanSignKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEdgeAccess().getTargetDependencyTargetParserRuleCall_3_0());
				}
				lv_target_3_0=ruleDependencyTarget
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEdgeRule());
					}
					set(
						$current,
						"target",
						lv_target_3_0,
						"org.eclipse.lsat.activity.teditor.Activity.DependencyTarget");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleSourceReference
entryRuleSourceReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSourceReferenceRule()); }
	iv_ruleSourceReference=ruleSourceReference
	{ $current=$iv_ruleSourceReference.current; }
	EOF;

// Rule SourceReference
ruleSourceReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSourceReferenceAccess().getSourceReferenceAction_0(),
					$current);
			}
		)
		(
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getSourceReferenceRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getSourceReferenceAccess().getNodeActionCrossReference_1_0_0());
					}
					ruleIID
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				otherlv_2='|'
				{
					newLeafNode(otherlv_2, grammarAccess.getSourceReferenceAccess().getVerticalLineKeyword_1_1_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getSourceReferenceRule());
							}
						}
						{
							newCompositeNode(grammarAccess.getSourceReferenceAccess().getNodeSyncBarCrossReference_1_1_1_0());
						}
						ruleIID
						{
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)
	)
;

// Entry rule entryRuleDependencyTarget
entryRuleDependencyTarget returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDependencyTargetRule()); }
	iv_ruleDependencyTarget=ruleDependencyTarget
	{ $current=$iv_ruleDependencyTarget.current; }
	EOF;

// Rule DependencyTarget
ruleDependencyTarget returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getDependencyTargetAccess().getTargetReferenceParserRuleCall_0());
		}
		this_TargetReference_0=ruleTargetReference
		{
			$current = $this_TargetReference_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getDependencyTargetAccess().getEdgeParserRuleCall_1());
		}
		this_Edge_1=ruleEdge
		{
			$current = $this_Edge_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleTargetReference
entryRuleTargetReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTargetReferenceRule()); }
	iv_ruleTargetReference=ruleTargetReference
	{ $current=$iv_ruleTargetReference.current; }
	EOF;

// Rule TargetReference
ruleTargetReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getTargetReferenceAccess().getTargetReferenceAction_0(),
					$current);
			}
		)
		(
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getTargetReferenceRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getTargetReferenceAccess().getNodeActionCrossReference_1_0_0());
					}
					ruleIID
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				otherlv_2='|'
				{
					newLeafNode(otherlv_2, grammarAccess.getTargetReferenceAccess().getVerticalLineKeyword_1_1_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getTargetReferenceRule());
							}
						}
						{
							newCompositeNode(grammarAccess.getTargetReferenceAccess().getNodeSyncBarCrossReference_1_1_1_0());
						}
						ruleIID
						{
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)
	)
;

// Entry rule entryRuleIID
entryRuleIID returns [String current=null]:
	{ newCompositeNode(grammarAccess.getIIDRule()); }
	iv_ruleIID=ruleIID
	{ $current=$iv_ruleIID.current.getText(); }
	EOF;

// Rule IID
ruleIID returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_INT_0=RULE_INT
		{
			$current.merge(this_INT_0);
		}
		{
			newLeafNode(this_INT_0, grammarAccess.getIIDAccess().getINTTerminalRuleCall_0());
		}
		    |
		this_ID_1=RULE_ID
		{
			$current.merge(this_ID_1);
		}
		{
			newLeafNode(this_ID_1, grammarAccess.getIIDAccess().getIDTerminalRuleCall_1());
		}
	)
;

// Entry rule entryRuleEString
entryRuleEString returns [String current=null]:
	{ newCompositeNode(grammarAccess.getEStringRule()); }
	iv_ruleEString=ruleEString
	{ $current=$iv_ruleEString.current.getText(); }
	EOF;

// Rule EString
ruleEString returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_STRING_0=RULE_STRING
		{
			$current.merge(this_STRING_0);
		}
		{
			newLeafNode(this_STRING_0, grammarAccess.getEStringAccess().getSTRINGTerminalRuleCall_0());
		}
		    |
		this_ID_1=RULE_ID
		{
			$current.merge(this_ID_1);
		}
		{
			newLeafNode(this_ID_1, grammarAccess.getEStringAccess().getIDTerminalRuleCall_1());
		}
	)
;

// Rule Scheduling
ruleScheduling returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='ASAP'
			{
				$current = grammarAccess.getSchedulingAccess().getASAPEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getSchedulingAccess().getASAPEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='ALAP'
			{
				$current = grammarAccess.getSchedulingAccess().getALAPEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getSchedulingAccess().getALAPEnumLiteralDeclaration_1());
			}
		)
	)
;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

RULE_INT : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
